<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Requirements Check</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            background-color: #f4f4f4;
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        .container {
            max-width: 800px;
            margin: 50px auto;
            padding: 20px;
            background-color: #fff;
            border-radius: 5px;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
        }
        h2 {
            text-align: center;
            color: #333;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 20px;
        }
        th, td {
            padding: 10px;
            border: 1px solid #ddd;
            text-align: left;
        }
        th {
            background-color: #f2f2f2;
            font-weight: bold;
        }
        tr:nth-child(even) {
            background-color: #f9f9f9;
        }
        .status {
            text-align: center;
        }
        .status span {
            padding: 5px 10px;
            border-radius: 5px;
        }
        .status .success {
            background-color: #4CAF50;
            color: white;
        }
        .status .error {
            background-color: #f44336;
            color: white;
        }
    </style>
</head>
<body>
    <div class="container">
        <h2>iCrew v4 Server Requirements Checker
            <br>
            <small>
            &copy; icrewsystems 
            </small>
        </h2>
        <p>
            You can access
            <a href="info.php">Info.php</a>
            <a href="info.php">PHPInfo</a>
        </p>        
        <table>
            <tr>
                <th>Requirement</th>
                <th>Status</th>
            </tr>
            <?php
            // Check PHP version
            $php_version = phpversion();
            $php_requirement_met = version_compare($php_version, '7.4', '>=');

            // Check OpenSSL
            $openssl_loaded = extension_loaded('openssl') && defined('OPENSSL_VERSION_NUMBER') && OPENSSL_VERSION_NUMBER >= 0x10100000;

            // Check cURL
            $curl_available = function_exists('curl_version');

            // Check file_get_contents
            $file_get_contents_enabled = ini_get('allow_url_fopen');

            $phpvms_version = file_get_contents('../core/version');            
            ?>
            <tr>
                <td>PHP version >= 7.4</td>
                <td class="status">
                <?php 
                    echo 'v' . $php_version;
                ?>    
                <br><br>
                <?php echo $php_requirement_met ? '<span class="success">✅ Okay </span>' : '<span class="error">❌ PHP version must be 7.4 or greater</span>'; ?></td>
            </tr>
            <tr>
                <td>OpenSSL</td>
                <td class="status"><?php echo $openssl_loaded ? '<span class="success">✅ Okay</span>' : '<span class="error">❌ OpenSSL extension is not secure</span>'; ?></td>
            </tr>
            <tr>
                <td>cURL</td>
                <td class="status"><?php echo $curl_available ? '<span class="success">✅ Okay</span>' : '<span class="error">❌ cURL is not available</span>'; ?></td>
            </tr>
            <tr>
                <td>file_get_contents</td>
                <td class="status"><?php echo $file_get_contents_enabled ? '<span class="success">✅ Okay</span>' : '<span class="error">❌ file_get_contents is not enabled</span>'; ?></td>
            </tr>

            <tr>
                <td>phpvms</td>
                <td class="status">
                <?php echo 'v' . $phpvms_version; ?>
                <br><br>
                <?php echo $phpvms_version ? '<span class="success">✅ Okay</span>' : '<span class="error">❌ file_get_contents is not enabled</span>'; ?></td>
            </tr>
        </table>
    </div>
</body>
</html>
