<?php
	class ICSFleet extends CodonModule {
		
		public function HTMLHead() {
			$this->set('sidebar', 'ICSFleet/sidebar.php');
		}
		
		public function NavBar() {
			echo '<li><a href="'.SITE_URL.'/admin/index.php/ICSFleet">ICS Fleet Manager <span style="color: red;">NEW!</span></a></li>';
		}
		
		public function index() {
			$this->set('title', 'Fleet Dashboard');
			$this->render('ICSFleet/index.php');
		}
		
		public function fleetmap($icao) {
			$fleet = ICSFleetData::getACbyICAO($icao);
			$this->set('fleet', $fleet);
			$this->set('icao', $icao);
			$this->show('ICSFleet/dashboardajaxmap.php');
		}
		
		public function fleet_json() {
			header('Content-Type: application/json');
			echo json_encode(ICSFleetData::getAllFleet(1));
		}
		
		public function fleetlist() {
			$this->set('title', 'Fleet List');
			$this->set('allaircraft', ICSFleetData::getAllFleet(1));
			$this->show('ICSFleet/fleetlist.php');
		}
		
		public function category() {
			$this->set('categories', ICSFleetData::getAllCategories());
			$this->set('title', 'Fleet Categories');
			$this->show('ICSFleet/header.php');
			$this->render('ICSFleet/category.php');
		}
		
		public function category_add() {
			$this->set('title', 'Add Fleet Category');
			$this->set('action', 'add');
			$this->show('ICSFleet/header.php');
			$this->show('ICSFleet/category_add.php');
		}
		
		public function category_edit($id) {
			if($id == '') {
				$this->set('message', 'Incorrect category ID');
				$this->show('core_error.php');
				$this->category();
				return;
			} else {
				$this->set('title', 'Update Fleet Category');
				$this->set('action', 'update');
				$this->set('category', ICSFleetData::getCategoryByID($id));
				$this->show('ICSFleet/category_edit.php');
			}
		}
		
		public function category_process() {
    	$post = $this->post;
    	$action = $post->action;
    	$id = $post->category_id;
    	$name = $post->name;
    	
    	switch($action) {
    		case "update":
    			ICSFleetData::updateCategory($post);
    			$message = "<strong>Success</strong> Updated $name";
    			$message_type = "success";
    		break;
    		
    		case "add":
    			ICSFleetData::addCategory($post);
    			$message = "<strong>Success</strong> Added $name as new category. Make sure to assign fleet to this category";
    			$message_type = "success";
    		break;
    		
    		case "delete":
    			ICSFleetData::deleteCategory($post);
    			$message = "<strong>Success</strong> Deleted $name from categories. Please update the fleet data.";
    			$message_type = "success";
    		break;
    		
    		
    		default: 
    			$message = "<strong>Oops</strong> Unable to process. Action not specified.";
    			$message_type = "danger";
    		break;
    	}
    	
    	
    	$this->set('message', $message);
    	$this->set('message_type', $message_type);
    	$this->category();
    }
    
    
	    public static function add_fleet() {
	    	$this->set('title', 'Add New Fleet');
	    	$this->show('ICSFleet/header.php');
	    	$this->show('ICSFleet/fleet_add.php');
    	}
	}