<?php
/*

	THIS MODULE IS TO BE USED ONLY WITH VIRTUAL AIRLINES USING ICREW. EDITING, REVERENGINEERING OF THIS MODULE 
	IS PROHIBITED. IF FOUND OTHER WISE, CAN BE FINED UPTO $1000 USD.
	
	@contact hello@icrewsystems.com
	
	@author icrewsystems.com 
	@build 02-06-2020
	@version 1.10
*/


class ICSTourAdmin extends CodonModule {
	
	public function HTMLHead() {
        $this->set('sidebar', 'ICSTourAdmin/sidebar.php');
    }

    public function NavBar() {
        echo '<li><a href="'.SITE_URL.'/admin/index.php/ICSTourAdmin">Tour Admin</a></li>';
    }

	public function index() {
		$this->set('title', 'Dashboard');
		$this->set('tours', ICSTourData::getAllTours(1));
		$this->render('ICSTourAdmin/index');
	}
	
	public function activeTours() {
		$this->set('title', 'Active Tours');
		$this->set('tours', ICSTourData::getActiveTours());
		$this->render('ICSTourAdmin/activeTours');
	}
	
	public function create() {
		$this->set('awards', AwardsData::getAllAwards());
		$this->set('airlines', OperationsData::getAllAirlines(true));
		$this->set('aircrafts', OperationsData::getAllAircraftSearchList(true));
		$this->set('ranks', RanksData::getAllRanks());
		$this->set('airports', OperationsData::getAllAirports());
		$this->set('action', 'Create');
		$this->set('title', 'Create a new tour');
		$this->render('ICSTourAdmin/create');
	}
	
	public function deleteTour() {
		ICSTourData::DeleteTour($_GET['id']);
		$this->set('title', 'Deleted Tour');
		$this->render('ICSTourAdmin/processed');
	}
	
	public function DeletePilot($tourid, $pilotid) {
		
	$sql="DELETE FROM icrewsystems_tour_participation WHERE pilotid = '$pilotid' AND tourid ='$tourid'";
	$this->set('title', 'Deleted Pilot');
		$this->render('ICSTourAdmin/processedpilot');
    return DB::query($sql);
	}
	
	
	public function manage($tourid = 0) {
		if($tourid == 0) {
			$this->set('message', 'Tour ID is missing on URL. Please check again');
			$this->set('message_type', 'danger');
			$this->index();
			return;
		}
		
		$tour = ICSTourData::getTour($tourid);
		$legs = ICSTourData::getTourLegs($tourid);
		
		if($tour == '') {
			$this->set('message', 'Something went wrong, tour not found..');
			$this->set('message_type', 'danger');
			$this->index();
			return;
		} else {
			$this->set('title', 'Manage Tour');
			$this->set('tour', $tour);
			$this->set('tourParticipants', ICSTourData::getTourParticipants($tourid));
			$this->set('legs', $legs);
			$this->show('ICSTourAdmin/manage');
		}
	}
	
	public function edit($tourid = 0) {
		if($tourid == 0) {
			$this->set('message', 'Tour ID is missing on URL. Please check again');
			$this->set('message_type', 'danger');
			$this->index();
			return;
		}
		
		$tour = ICSTourData::getTour($tourid);
		$legs = ICSTourData::getTourLegs($tourid);
		
		if($tour == '') {
			$this->set('message', 'Something went wrong, tour not found..');
			$this->set('message_type', 'danger');
			$this->index();
			return;
		} else {
			$this->set('awards', AwardsData::getAllAwards());
			$this->set('action', 'Save');
			$this->set('airlines', OperationsData::getAllAirlines(true));
			$this->set('aircrafts', OperationsData::getAllAircraftSearchList(true));
			$this->set('ranks', RanksData::getAllRanks());
			$this->set('airports', OperationsData::getAllAirports());
			$this->set('title', 'Edit Tour');
			$this->set('tour', $tour);
			$this->set('legs', $legs);
			$this->show('ICSTourAdmin/edit');
		}
	}
	public function edit_legs($tourid = 0) {
		if($tourid == 0) {
			$this->set('message', 'Oops, Tour ID is missing.');
			$this->set('message_type', 'warning');
			$this->index();
			return;
		}
		
		$tour = ICSTourData::getTour($tourid);
		$legs = ICSTourData::getTourLegs($tourid);
		
		if($tour == '') {
			$this->set('message', 'Something went wrong, tour not found..');
			$this->set('message_type', 'danger');
			$this->index();
			return;
		} else {
			$this->set('tour', $tour);
			$this->set('legs', $legs);
			$this->set('airports', OperationsData::getAllAirports());
			$this->set('title', 'Edit Tour Legs');
			$this->show('ICSTourAdmin/edit_legs');
		}
	}
	
	
	public function edit_leg_airports($id = 0){
		if($id == 0) {
			$this->set('message', 'Oops, Tour ID is missing.');
			$this->set('message_type', 'warning');
			$this->index();
			return;
		}
		
		$this->set('action', 'Update');
		$this->set('title', 'Editing Tour Leg Airports');
		$this->set('airports', OperationsData::getAllAirports());
		$this->set('leg', ICSTourData::getLeg($id));
		$this->show('ICSTourAdmin/edit_leg_airports');
	}
	
	public function edit_leg_airports_process() {
		$id = $this->post->id;
		$tourid = $this->post->tourid;
		$legid = $this->post->legid;
		$depicao = $this->post->depicao;
		$arricao = $this->post->arricao;
		
		
		ICSTourData::updateLeg($id, $tourid, $legid, $depicao, $arricao);
		$this->set('message', 'Leg # '.$legid.' was updated');
		$this->set('message_type', 'success');
		$this->edit_legs($tourid);
	}
	
	public function edit_process() {
		$post = $this->post;
		foreach ($post as $post => $key) {
			if(is_array($key)) {
				$count == 0;
            	$total = count($key);
             foreach ($key as $airframe) {
                if($count == ($total - 1)) {
                  // Last frame.
                 $temp_airframe_mask .= $airframe;
                } else {
                  $temp_airframe_mask .= $airframe.',';	
                }
            $count++;
            }
			}
		}
		
		$post = $this->post;
		$id = $post->id;
		$title = $post->title;
		$description = $post->description;
		$startdate = $post->startdate;
		$enddate = $post->enddate;
		$airline = $post->airline;
		$airframes = $temp_airframe_mask;
		$total_legs = $post->total_legs;
		$minrank = $post->minrank;
		$status = $post->active;
		$award_id = $post->award_id;
		
		if($_FILES['banner']['name'] != '') {
			$banner = $_FILES['banner']['name']; 
			// $ext = pathinfo($banner, PATHINFO_EXTENSION);
			// $allowed = array('jpg','png','gif');
			// if(!in_array( $ext, $allowed ) ) {echo 'error';}
			$expbanner = explode('.',$banner);
			$bannerexptype=$expbanner[1];
			$bannername = strtolower('tourposter_'.$post->title).'-'.rand(1,10342);
			$bannername = str_replace(' ', '_', $bannername);
			$bannername = $bannername.'.png';
			$bannerpath = "../tour_banners/".$bannername;
			move_uploaded_file($_FILES["banner"]["tmp_name"],$bannerpath);
        	$image = SITE_URL.'/tour_banners/'.$bannername;
        	$poster = $image;	
		} else {
			$poster = $post->poster;
		}
			
		$ret = ICSTourData::UpdateTour($id, $title, $poster, $description, $startdate, $enddate, $airline, $airframes, $total_legs, $minrank, $status, $award_id);
		$this->set('message', 'Tour has been updated');
		$this->set('message_type', 'success');
		$this->show('ICSTourAdmin/processed');	
	}
	
	
	public function process() {
		$post = $this->post;
		switch($post->action) {
			case "Process": 
			$title = $post->title;
			$total_legs = $post->total_legs;
        	
        	$this->set('title', $title);
        	$this->set('total_legs', $total_legs);
        	$this->set('action', 'Finish');
        	$this->set('message', 'Step 2 Completed. ');
        	$this->set('message_type', 'success');
			$this->render('ICSTourAdmin/process_legs');
			break;
			
			case "Finish": 
			
			$title = $post->title;
			$description = $post->description;
			$startdate = $post->startdate;
			$enddate = $post->enddate;
			$airline = $post->airline;
			$airframes = $post->airframes;
			$total_legs = $post->total_legs;
			$minrank = $post->minrank;
			$status = $post->active;
			$poster = $post->poster;
			$award_id = $post->award_id;
			$tourid = ICSTourData::CreateTour($title, $poster, $description, $startdate, $enddate, $airline, $airframes, $total_legs, $minrank, $status, $award_id);
			for($i = 1; $i <= $total_legs; $i++) {
				$departure_leg = '';
				$arrival_leg = '';
				$previous_arr = 'arr_'.($i - 1);
				$dep = 'dep_'.$i;
				$arr = 'arr_'.$i;               			
				if (array_key_exists($dep, $_POST) && array_key_exists($arr, $_POST)) {
					// echo $dep." & ".$arr." exists in post. Value is: ".$_POST[$dep]." & ".$_POST[$arr];
					// echo "<br>";
					$departure_leg = $_POST[$dep];
					$arrival_leg = $_POST[$arr];
					ICSTourData::addLeg($tourid, $i, $departure_leg, $arrival_leg);
				}
            }
            
            $this->set('message', 'Tour "'.$title.'" was added to the database, all legs were processed'.print_r($temp_airframe_mask));
            $this->set('message_type', 'success');
			$this->render('ICSTourAdmin/processed');
            
			break;
			
			
			
			case "Create": 
				
			$title = $post->title;
			$description = $post->description;
			$startdate = $post->startdate;
			$enddate = $post->enddate;
			$airline = $post->airline;
			$airframes = $post->airframes;
			$firstdep = $post->firstdep;
			$lastarr = $post->lastarr;
			$total_legs = $post->total_legs;
			$minrank = $post->minrank;
			$status = $post->active;
			
			$banner = $_FILES['banner']['name']; 
			// $ext = pathinfo($banner, PATHINFO_EXTENSION);
			// $allowed = array('jpg','png','gif');
			// if(!in_array( $ext, $allowed ) ) {echo 'error';}
			
			
			$expbanner = explode('.',$banner);
			$bannerexptype=$expbanner[1];
			$bannername = strtolower('tourposter_'.$post->title).'-'.rand(1,10342);
			$bannername = str_replace(' ', '_', $bannername);
			$bannername = $bannername.'.png';
			$bannerpath = "../tour_banners/".$bannername;
			move_uploaded_file($_FILES["banner"]["tmp_name"],$bannerpath);
        	$image = SITE_URL.'/tour_banners/'.$bannername;
        	$poster = $image;
        	
        	$this->set('title', $title);
        	$this->set('poster', $poster);
        	$this->set('total_legs', $total_legs);
        	$this->set('firstdep', $firstdep);
        	$this->set('lastarr', $lastarr);
        	$this->set('action', 'Process');
        	$this->set('airports', OperationsData::getAllAirports());
        	$this->set('message', 'Tour instance initialized, processing...');
        	$this->set('message_type', 'success');
			$this->show('ICSTourAdmin/legs');
			break;
		}
	}
	
	public function fleet() {
		$this->set('allaircraft', OperationsData::GetAllAircraft());
        $this->render('CharterAdmin/fleet.php');
	}
	
	public function fleet_hangar() {
		$this->set('allaircraft', CharterData::getCharterFleet());
		$this->render('CharterAdmin/fleet_hanger.php');
	}
	
	public function assign($acid) {
		$allac = CharterData::getCharterFleet();
		foreach ($allac as $ac) {
			if($aircraft_id == $acid) {
				$this->set('message', 'This aircraft was already added to Charter Operations');
				$this->show('core_success.php');
				$this->fleet_hangar();
				return;
			} 
		}
		
		CharterData::addAircraftToCharter($acid);
		$this->set('message', 'This aircraft was successfully added to Charter Operations');
		$this->show('core_success.php');
		$this->fleet_hangar();
		return;
	}
	
		public function removefleet($acid) {
		CharterData::removeAircraftFromCharter($acid);
		$this->set('message', 'This aircraft was successfully removed from Charter Operations');
		$this->show('core_error.php');
		$this->fleet_hangar();
		return;
	}
	
	
	public function update_settings() {
		$data = $this->post;
		
		$module_status = $data->module_status;
		$airline_code = $data->airline_code;
		$welcome_message = $data->welcome_message;
		$process_pay = $data->process_pay;
		$process_hours = $data->process_hours;
		$cost_per_mile = $data->cost_per_mile;
		$charge_for_charter = $data->charge_for_charter;
		
		
		if (!OperationsData::GetAirlineByCode($airline_code)) {
            $this->set('message', 'No Airline was found with the code '.$airline_code.'. Please add the Charter Airline first, then edit this setting');
            $this->render('core_error.php');
            $this->index();
            return;
        }
		
		$sql = "UPDATE `icrewsystems_charter_settings` SET 
		`airline_code` = '$airline_code',
		`charge_for_charter` = '$charge_for_charter',
		`cost_per_mile` = '$cost_per_mile',
		`process_hours` = '$process_hours', 
		`process_pay` = '$process_pay',
		`welcome_message` = '$welcome_message', 
		`module_status` = '$module_status' 
		
		WHERE `icrewsystems_charter_settings`.`id` = 1";
		DB::query($sql);
		
		$this->set('message', 'Settings have been updated.');
		$this->show('core_success.php');
		$this->index();
	}
	
	public function about() {
		$this->render('ICSTourAdmin/about');
	}
} 

?>