<?php
/**
 * phpVMS - Virtual Airline Administration Software
 * Copyright (c) 2008 Nabeel Shahzad
 * For more information, visit www.phpvms.net
 *	Forums: http://www.phpvms.net/forum
 *	Documentation: http://www.phpvms.net/docs
 *
 * phpVMS is licenced under the following license:
 *   Creative Commons Attribution Non-commercial Share Alike (by-nc-sa)
 *   View license.txt in the root, or visit http://creativecommons.org/licenses/by-nc-sa/3.0/
 *
 * @author Nabeel Shahzad
 * @copyright Copyright (c) 2008, Nabeel Shahzad
 * @link http://www.phpvms.net
 * @license http://creativecommons.org/licenses/by-nc-sa/3.0/
 *
 *This particular section was built by Cale Cunningham; basically a modified version
 *of the contact form found in the core.
 */

class MassMailer extends CodonModule {

	public function HTMLHead() {
		$this->set('sidebar', 'sidebar_mailer.php');
	}

	public function index() {
        $this->checkPermission(EMAIL_PILOTS);
		$this->set('allgroups', PilotGroups::getAllGroups());
		$this->render('mailer_form.php');
	}

	public function sendmail() {
        $this->checkPermission(EMAIL_PILOTS);
		echo '<h3>Sending email</h3>';
		if ($this->post->subject == '' || trim($this->post->message) == '') {
			$this->set('message', 'You must enter a subject and message!');
			$this->render('core_error.php');
			return;
		}

		if (count($this->post->groups) == 0) {
			$this->set('message', 'You must select groups to send to!');
			$this->render('core_error.php');
			return;
		}

		echo 'Sending email...<br />';

		$pilotarray = array();
		//Begin the nice long assembly of e-mail addresses
		foreach ($this->post->groups as $groupid) {
			if ($groupid == 'all') {
				$all_pilots = PilotData::findPilots(array());
				foreach ($all_pilots as $pilot) {
					$pilotarray[$pilot->pilotid] = $pilot;
				}

				break;
			} else {
				$tmp = PilotGroups::getUsersInGroup($groupid);
				if (count($tmp) == 0 || !is_array($tmp)) {
					continue;
				}

				foreach ($tmp as $pilot) {
					$pilotarray[$pilot->pilotid] = $pilot;
				}
			}
		}

		$subject = DB::escape($this->post->subject);
		$message = stripslashes($this->post->message) . PHP_EOL . PHP_EOL;

		# Do some quick fixing of obvious formatting errors
		$message = str_replace('<br>', '<br />', $message);
		
		$html_template = '<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
        <title>Welcome Email</title>
        <meta name="viewport" content="width=device-width" />
        <style type="text/css">
            @media only screen and (max-width: 550px), screen and (max-device-width: 550px) {
                body[yahoo] .buttonwrapper { background-color: transparent !important; }
                body[yahoo] .button { padding: 0 !important; }
                body[yahoo] .button a { background-color: #349ee5; padding: 15px 25px !important; }
            }

            @media only screen and (min-device-width: 601px) {
                .content { width: 600px !important; }
                .col387 { width: 387px !important; }
            }
        </style>
    </head>
    <body bgcolor="#252d2f" style="margin: 0; padding: 0;" yahoo="fix">
        <!--[if (gte mso 9)|(IE)]>
        <table width="600" align="center" cellpadding="0" cellspacing="0" border="0">
          <tr>
            <td>
        <![endif]-->
        <table align="center" border="0" cellpadding="0" cellspacing="0" style="border-collapse: collapse; width: 100%; max-width: 600px;" class="content">
            <tr>
                <td align="center" bgcolor="#4d4d4d" style="padding: 25px 20px 20px 20px; color: #ffffff; font-family: Arial, sans-serif; font-size: 26px;">
                    <img src="'.SITE_URL.'/iCrew/ics_logo.png" alt="<?php echo SITE_NAME; ?>" width="auto;" height="50" style="display:block;" />
                </td>
            </tr>
            <tr>
                <td align="left" bgcolor="#ffffff" style="padding: 0 20px 40px 20px; color: #777777; font-family: Arial, sans-serif; font-size: 14px;  border-bottom: 1px solid #f6f6f6;">
                  <br>{MAIL_CONTENT}
                </td>
            </tr>
            <tr>
                <td align="center" bgcolor="#e9e9e9" style="padding: 12px 10px 12px 10px; color: #888888; font-family: Arial, sans-serif; font-size: 12px; line-height: 18px;">
                    <b>'.SITE_NAME.' </b> <br>Powered by iCrew '.ICS_VERSION.' <i>'.e(ICS_LICENCE_TYPE).'</i> &bull; Crafted by icrewsystems

                </td>
            </tr>
            <tr>
                <td style="padding: 15px 10px 15px 10px;">
                    <table border="0" cellpadding="0" cellspacing="0" width="100%">
                        <tr>
                            <td align="center" width="100%" style="color: #999999; font-family: Arial, sans-serif; font-size: 12px;">
                                	'.$url = SITE_URL; 
                                	if(FORCE_SSL == 1) {
                                		$frontend = str_replace("https://icrew", "www", $url);	
                                	} else {
                                		$frontend = str_replace("http://icrew", "www", $url);
                                	}
                                	$frontend.'
                            </td>
                        </tr>
                    </table>
                </td>
            </tr>
        </table>
        <!--[if (gte mso 9)|(IE)]>
                </td>
            </tr>
        </table>
        <![endif]-->
    </body>
</html>';
		
		$message = str_replace('{MAIL_CONTENT}', $message, $html_template);
		
		foreach ($pilotarray as $pilot) {
			echo 'Sending for ' . $pilot->firstname . ' ' . $pilot->lastname . '<br />';

			# Variable replacements
			$send_message = str_replace('{PILOT_FNAME}', $pilot->firstname, $message);
			$send_message = str_replace('{PILOT_LNAME}', $pilot->lastname, $send_message);
			$send_message = str_replace('{PILOT_ID}', PilotData::GetPilotCode($pilot->code, $pilot->pilotid), $send_message);
			$send_message = utf8_encode($send_message);

			Util::SendEmail($pilot->email, $subject, $send_message);
		}

		echo 'Complete!';

		LogData::addLog(Auth::$userinfo->pilotid, 'Sent pass mail');
		return;
	}

}
