<?php

class NOTAMs extends CodonModule {

	public function HTMLHead() {
		$this->set('sidebar', 'ICSNotams/sidebar.php');
	}
	
	public function NavBar() {
		echo '<li><a href="'.SITE_URL.'/admin/index.php/notams">NOTAMs</a></li>';
    }
    
	public function index() {
		$notams = NotamsData::getAll();
		
		$this->set('title', 'NOTAMs Dashboard');
		$this->set('notams', $notams);
		$this->render('ICSNotams/index');
	}
	
	public function issue() {
		$this->set('title', 'Issue a new NOTAM');
		$this->set('action', 'Issue');
		$this->set('allseries', NotamsData::getAllSeries(1));
		$this->render('ICSNotams/issue');
	}
	
	
	public function manage($id = 0) {
		if($id == 0) {
			$this->set('message', 'Whoops, NOTAM ID is missing');
			$this->set('message_type', 'danger');
			$this->index();
			return;
		} 
		
		$notam = NotamsData::GetNotam($id);
		if($notam == '') {
			$this->set('message', 'Whoops, NOTAM ID is incorrect. No NOTAM found bearing this ID '.$id);
			$this->set('message_type', 'danger');
			$this->index();
			return;
		}
		$this->set('title', 'Manage NOTAM');
		$this->set('allseries', NotamsData::getAllSeries(1));
		$this->set('action', 'Update');
		$this->set('notam', NotamsData::GetNotam($id));
		$this->render('ICSNotams/manage');
	}
	
	
	public function revoke($id = 0) {
		if($id == 0) {
			$this->set('message', 'Whoops, NOTAM ID is missing');
			$this->set('message_type', 'danger');
			$this->index();
			return;
		} 
		
		$notam = NotamsData::GetNotam($id);
		if($notam == '') {
			$this->set('message', 'Whoops, NOTAM ID is incorrect. No NOTAM found bearing this ID '.$id);
			$this->set('message_type', 'danger');
			$this->index();
			return;
		}
		$this->set('title', 'Revoking an active NOTAM');
		$this->set('allseries', NotamsData::getAllSeries(1));
		$this->set('action', 'Revoke');
		$this->set('notam', NotamsData::GetNotam($id));
		$this->render('ICSNotams/revoke');
	}
	
	public function series() {
		// Display all available series on the DB
		$series = NotamsData::getAllSeries(1);
		$this->set('title', 'Available NOTAM Series');
		$this->set('series', $series);
		$this->render('ICSNotams/series');
	}
	
	
	public function process() {
		
		$post = $this->post;
		$action = $this->post->action;
		switch ($action) {
			case "Issue": 
				$title = $post->title;
				$code = $post->code;
				$valid_from = $post->valid_from;
				$valid_till = $post->valid_till;
				$body = $post->body;
				$series = $post->series;
				
				$ret = NotamsData::issueNewNotam($title, $code, $valid_from, $valid_till, $body, $series);
				if($ret == true) {
					$this->set('message', 'New NOTAM bearing code '.$code.' has been issued.');
					$this->set('message_type', 'success');	
				} else {
					$this->set('message', 'There was an error in adding NOTAM to database. Please try again');
					$this->set('message_type', 'danger');
					$this->issue();
					return;
				}
			break;
			
			case "Update":
				
				$id = $post->id;
				$title = $post->title;
				$code = $post->code;
				$valid_from = $post->valid_from;
				$valid_till = $post->valid_till;
				$body = $post->body;
				$series = $post->series;
				$active = $post->active;
				
				$ret = NotamsData::updateNotam($id, $title, $code, $valid_from, $valid_till, $body, $series, $active);
				if($ret == true) {
					$this->set('message', 'NOTAM bearing code '.$code.' has been updated.');
					$this->set('message_type', 'success');	
				} else {
					$this->set('message', 'There was an error in updating NOTAM in the database.');
					$this->set('message_type', 'danger');
					$this->manage($id);
					return;
				}
				
			break;
			
			case "Revoke":
				
				$id = $post->revoking_id;
				$ret = NotamsData::revokeNotam($id);
				
				// NOTAM is now revoked. Next stuff. 
				
				$title = $post->title;
				$code = $post->code;
				$valid_from = $post->valid_from;
				$valid_till = $post->valid_till;
				$body = $post->body;
				$series = $post->series;
				
				$ret = NotamsData::issueNewNotam($title, $code, $valid_from, $valid_till, $body, $series, 1);
				if($ret == true) {
					$this->set('message', 'Revoking NOTAM bearing code '.$code.' has been issued.');
					$this->set('message_type', 'success');	
				} else {
					$this->set('message', 'There was an error in updating NOTAM in the database.');
					$this->set('message_type', 'danger');
					$this->manage($id);
					return;
				}
				
			break;
			
			
			case "new_series":
				$name = $post->name;
				$active = $post->active;
				
				$ret = NotamsData::newSeries($name, $active);
				if($ret == true) {
					$this->set('message', 'New NOTAM Series "'.$name.'" has been added.');
					$this->set('message_type', 'success');	
					$this->series();
					return;
				} else {
					$this->set('message', 'There was an error trying to add series. Please try again');
					$this->set('message_type', 'danger');
					$this->issue();
					return;
				}
			break;
			
			case "update_series":
				$id = $post->id;
				$name = $post->name;
				$active = $post->active;
				
				$ret = NotamsData::updateSeries($id, $name, $active);
				if($ret == true) {
					$this->set('message', 'NOTAM Series "'.$name.'" has been updated.');
					$this->set('message_type', 'success');	
					$this->series();
					return;
				} else {
					$this->set('message', 'There was an error trying to update this series. Please try again');
					$this->set('message_type', 'danger');
					$this->issue();
					return;
				}
			break;
			
			
			case "delete_series":
				
			break;
		
			default: 
				
				
				if($this->get->action == 'delete') {
						
				$id = $this->get->id;
				$ret = NotamsData::deleteNotam($id);
				if($ret == true) {
					$this->set('message', 'NOTAM with ID #'.$id.' has been deleted.');
					$this->set('message_type', 'success');	
				} else {
					$this->set('message', 'There was an error in delete NOTAM from the database.');
					$this->set('message_type', 'danger');
					$this->manage($id);
					return;
				}
				} else if($this->get->action == 'delete_series') {
					$id = $this->get->id;
					$ret = NotamsData::deleteSeries($id);
					if($ret == true) {
						$this->set('message', 'NOTAM Series has been deleted.');
						$this->set('message_type', 'success');	
						$this->series();
						return;
					} else {
						$this->set('message', 'There was an error trying to update this series. Please try again');
						$this->set('message_type', 'danger');
						$this->issue();
					return;
					}
				}
				
				
			break;
		}
		
		$this->index();
	}
	
	public function settings() {
		$this->set('settings', NotamsData::getAllSettings());
		$this->set('title' ,'NOTAMs Module Settings');
		$this->render('ICSNotams/settings');
	}
	public function update_settings() {
		
		$post = $this->post;
		$active = $post->module_status;
		
		if($active == 1) {
			NotamsData::updateSettings($active);
		} else {
			NotamsData::updateSettings($active);
		}
		
		$this->set('message', 'Settings have been updated.');
		$this->set('message_type', 'success');
		$this->settings();
	}
}