<link rel="stylesheet" href="<?php echo SITE_URL?>/lib/js/leaflet/leaflet.css" />
    <script src="<?php echo SITE_URL?>/lib/js/leaflet/leaflet.js"></script>
    <script src="<?php echo SITE_URL?>/lib/js/leaflet/leaflet-providers.js"></script>
    <script src="<?php echo SITE_URL?>/lib/js/leaflet/Leaflet.Geodesic.js"></script>
    <script>
/**
 * Basemap for leaflet
 */

/**
 * Elements used across maps
 */
 
 var url = "<?php echo SITE_URL; ?>";
 
const MapFeatures = {
    icons: {
        departure: L.icon({ iconUrl: depicon, iconSize: [35, 35] }),
        arrival: L.icon({ iconUrl: arricon, iconSize: [35, 35] }),
        vor: L.icon({
            iconUrl: url + "/lib/images/icon_vor.png",
            iconSize: [19, 20],
        }),
        fix: L.icon({
            iconUrl: url + "/lib/images/icon_fix.png",
            iconSize: [12, 15],
        }),
    },
};

/**
 * Create a new map onto a given element. If you have or want to add
 * any Leaflet plugins, just apply them here above the return statement
 * They'll be applied to both the ACARS and PIREP maps
 * @param {} opts Options to override
 */
const createMap = (opts) => { 
    opts = Object.assign({
        render_elem: 'map',
        center: [29.98139, -95.33374],
        zoom: 5,
        maxZoom: 10,
        layers: [],
        set_marker: false,
        provider: 'OpenStreetMap.Mapnik',
    }, opts);


    let map = L.map(opts.render_elem, {
        center: opts.center,
        zoom: opts.zoom,
        scrollWheelZoom: true,
    });

    // Want to customizer the basemap? Look at the leaflet-providers page:
    //  http://leaflet-extras.github.io/leaflet-providers/preview/
    // Just set the provider name that you want below, or add additional
    //
    // Some providers require an API key, so just look out for that
    // If you want to use one of those, comment out the line below, and
    // put the "Plain JavaScript" code they specify, and then use your API key
    L.tileLayer.provider(opts.provider).addTo(map);
    return map;
};
         </script>
         <div id="ajax_map">
		<div class="mapcenter" align="center">
            <div id="fleet_map" style="width: 90%; height: 500px"></div>
         </div>
         <br><br><br>
         <script type="text/javascript">
            const map = createMap({
            	render_elem: 'fleet_map',
            	provider: '<?php echo Config::Get("MAP_TYPE"); ?>',
            });
			
			map.setView([0, 0], 1.5);
			
            <?php
               function in_array_r($item , $array){
					return preg_match('/"'.preg_quote($item, '/').'"/i' , json_encode($array));
				}
            $airports = array();
            	
            	$fleet = ICSFleetData::getAllFleet(1);
               foreach ($fleet as $fleetmap) {
            		$last_flight = ICSFleetData::get_last_flight($fleetmap->id);
               	if($last_flight == '') {
               		$current_location = 'KFDW';
               	} else {
               		
               		$current_location = $last_flight->arricao;
               	}
               	
               	$airportdata = OperationsData::getAirportInfo($current_location);
               	$coords = '['.$airportdata->lat.','.$airportdata->lng.']';
               	
               	
               	if(in_array_r($current_location , $airports)){
               		array_push($airports[$current_location], $fleetmap->registration);
               	} else {
               		$airports[$current_location] = array($fleetmap->registration);
            	}
            	
               }
               
               
               foreach ($airports as $airport => $plane) {
               			$message = '';
               		$airportdata = OperationsData::getAirportInfo($airport);
               		$coords = '['.$airportdata->lat.','.$airportdata->lng.']';
               			foreach ($plane as $p) {
							$message .= ' '.$p;
						}
					
					
               		?>
               		
               		L.marker(<?php echo $coords; ?>).bindTooltip("<?php echo $message; ?>").addTo(map);
               		
               		<?php
				}
               
               ?>
            	
            
            	var legend = L.control({position: 'bottomright'});
            
            	legend.onAdd = function (map) {
            
                var div = L.DomUtil.create('div', 'info legend');
                    div.innerHTML = '<img src="<?php echo SITE_URL; ?>/iCrew/favicon.png" style="width: 50px; height: auto;" /> <span class="text-primary">Fleet Map</span> ';
            	//<br><span class="label label-success">Direct Flights</span><br><span class="label label-warning">Connecting Flights</span>    
            
                return div;
            	};
            
            	legend.addTo(map);
            	
            map.fitBounds(selPointsLayer.getBounds());
         </script>
         
</div>