<?php 
   Template::show('ICSFleet/header.php');
   ?>
<div class="row">
   <div class="col-md-3">
      <div class="widget">
         <div class="widget-simple themed-background-dark">
            <h4 class="widget-content widget-content-light">
               Fleet <strong>Gallery</strong>
               <br>
               <small><?php echo SITE_NAME; ?></small>
            </h4>
         </div>
         <div class="widget-extra-full themed-background-modern">
            <div id="widget-carousel3" class="carousel slide remove-margin">
               <div class="carousel-inner">
               	<div class="item active">
               		<center>
               			<span class="label label-primary">
               				Boeing 747-400F
               			</span>
               			<br><br>
               		</center>
                     <img src="https://upsvac.com/lib/images/fleet/744UPS.jpg" alt="image">
                     <br>
                     <center>
                     	<span class="text-muted">
                     		<small>Image copyrights to their respective owners.</small>
                     	</span>
                     </center>
                  </div>
               	<?php 
					foreach ($fleet as $fl) {
               	?>
               	<div class="item">
               		<center>
               			<span class="label label-primary">
               				<?php echo $fl->fullname; ?> <?php echo $fl->registration; ?>
               			</span>
               			<br><br>
               		</center>
                     <img src="<?php echo $fl->imagelink; ?>" alt="<?php echo $fl->icao; ?>.png">
                     
                     <br>
                     <center>
                     	<span class="text-muted">
                     		<small>Image copyrights to their respective owners.</small>
                     	</span>
                     </center>
                  </div>
				<?php 
               }
               ?>
               </div>
               <a class="left carousel-control" href="#widget-carousel3" data-slide="prev">
               <span><i class="fa fa-chevron-left"></i></span>
               </a>
               <a class="right carousel-control" href="#widget-carousel3" data-slide="next">
               <span><i class="fa fa-chevron-right"></i></span>
               </a>
            </div>
         </div>
      </div>
      <div class="widget">
      <div class="widget-advanced">
         <div class="widget-header text-center themed-background-dark">
            <h3 class="widget-content-light">
               <span class="themed-color">
               	Recent Flights
               	<br>
               </span>
               <small><?php echo SITE_NAME; ?></small>
            </h3>
         </div>
         <div class="widget-main">
            <table class="table table-borderless table-striped table-condensed table-vcenter">
               <tbody>
               	<?php 
               		$count = 5;
					$pireps = PIREPData::getRecentReportsByCount($count);
					foreach ($pireps as $pirep) {
						?>
					<tr>
						<td style="width: 10px;"><?php echo $pirep->code.$pirep->flightnum; ?></td>
						<td>
							<a href="javascript:void(0)"><strong><?php echo $pirep->aircraft; ?> (<?php echo $pirep->registration; ?>)</strong></a>
						</td>
						<td class="text-right">
							<?php echo $pirep->arricao; ?>
						</td>
                	</tr>
						<?php 
					}
				?>
                  
               </tbody>
            </table>
         </div>
      </div>
   </div>
   </div>

   <div class="col-md-9">
      <div class="block">
         <h5 class="text-center">There are <strong><?php echo count($fleet); ?></strong> types of aircrafts in the <?php echo SITE_NAME; ?> fleet to choose from</h5>
         <h3 class="text-center">
            <span class="p">We have the </span>
            <span class="p">
            <?php 
               foreach ($header_fleet as $f) {
               	?>
            <strong><span class="word text-primary"><?php echo $f->icao; ?></span></strong>
            <?php 
               }
               ?>
            </span>
            <span class="p pull-right">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</span>
         </h3>
         <br><br>
         <div class="table-responsive">
            <table id="fleet-table" class="table datatable">
               <thead>
                  <th>Aircraft</th>
                  <th>ICAO</th>
                  <th>Strength</th>
                  <th>Category</th>
                  <th>Options</th>
               </thead>
               <tbody>
                  <?php 
                     foreach ($fleet as $fleet) {
                     	?>
                  <tr>
                     <td><?php echo $fleet->fullname; ?></td>
                     <td><?php echo $fleet->icao; ?></td>
                     <td><?php echo $fleet->registration; ?></td>
                     <td>
                     	<?php echo ICSFleetData::getCategoryNameByID($fleet->category_id); ?>
                     </td>
                     <td><a href="<?php echo url('/ICSFleet/view/'); ?><?php echo $fleet->icao; ?>" class="btn btn-sm btn-success">View all <?php echo $fleet->icao; ?>'s in fleet</a></td>
                  </tr>
                  <?php 
                     }
                     ?>
               </tbody>
            </table>
         </div>
      </div>
   </div>
</div>
<script>
	var TablesDatatables = function() {

    return {
        init: function() {
            /* Initialize Bootstrap Datatables Integration */
            App.datatables();

            /* Initialize Datatables */
            $('#fleet-table').dataTable({
                columnDefs: [ { orderable: true} ],
                 "order": [[ 3, "asc" ]],
                pageLength: 10,
                lengthMenu: [[10, 20, 30, -1], [10, 20, 30, 'All']]
            });

            /* Add placeholder attribute to the search input */
            $('.dataTables_filter input').attr('placeholder', 'Search');
        }
    };
}();
</script>
<script>
   $(function(){ TablesDatatables.init(); });
</script>
<script>
   var words = document.getElementsByClassName('word');
   var wordArray = [];
   var currentWord = 0;
   
   words[currentWord].style.opacity = 1;
   for (var i = 0; i < words.length; i++) {
    splitLetters(words[i]);
   }
   
   function changeWord() {
    var cw = wordArray[currentWord];
    var nw = currentWord == words.length-1 ? wordArray[0] : wordArray[currentWord+1];
    for (var i = 0; i < cw.length; i++) {
      animateLetterOut(cw, i);
    }
    
    for (var i = 0; i < nw.length; i++) {
      nw[i].className = 'letter behind';
      nw[0].parentElement.style.opacity = 1;
      animateLetterIn(nw, i);
    }
    
    currentWord = (currentWord == wordArray.length-1) ? 0 : currentWord+1;
   }
   
   function animateLetterOut(cw, i) {
    setTimeout(function() {
   	cw[i].className = 'letter out';
    }, i*80);
   }
   
   function animateLetterIn(nw, i) {
    setTimeout(function() {
   	nw[i].className = 'letter in';
    }, 340+(i*80));
   }
   
   function splitLetters(word) {
    var content = word.innerHTML;
    word.innerHTML = '';
    var letters = [];
    for (var i = 0; i < content.length; i++) {
      var letter = document.createElement('span');
      letter.className = 'letter';
      letter.innerHTML = content.charAt(i);
      word.appendChild(letter);
      letters.push(letter);
    }
    
    wordArray.push(letters);
   }
   
   changeWord();
   setInterval(changeWord, 4000);
   
   
</script>