<?php Template::Show('ICSFleet/header.php'); ?>
<?php
   $price = Auth::$userinfo->pilotid;
   $count = SchedulesData::countCharterSchedules($icao, $price);
   $random_number = rand(15, 1239);
   $flight_number = $icao.$random_number;
   
   print_r($_GET);
   ?>
<div class="row">
   <div class="col-md-12">
      <div class="block">
         <div class="block-title">
            <h2>Create <strong>Relief Flight</strong></h2>
         </div>
         <div class="alert alert-success">
            <strong>Attention</strong>
            <ol>
               <li>When an aircraft is STRANDED/ISOLATED, a relief crew is required to fly the aircraft back to one of the main hubs </li>
               <li>If the pilot choses to fly on an online network, the relief flights must be flown using <?php echo SITE_NAME; ?>'s official ICAO Callsign (UPS) ONLY</li>
               <li>After you submit the PIREP, your rewards will be automatically added.</li>
            </ol>
         </div>
         <form action="<?php echo url('/ICSFleet/process_relief_flight');?>" method="POST" class="form-horizontal form-bordered">
            <div class="form-group">
               <label class="col-md-3 control-label" for="code">Flight Type</label>
               <div class="col-md-6">
                  <select class="form-control" id="code" name="code">
                  <?php
                     foreach($allairlines as $airline)
                     {
                     if($airline->code == $icao)
                     {
                     echo '<option value="'.$airline->code.'">'.$airline->name.'</option>';				    
                     }
                     else
                     {
                     continue;
                     }
                     }
                     ?>
                  </select>
               </div>
            </div>
            <div class="form-group">
               <label class="col-md-3 control-label" for="name">Generated Flight Number</label>
               <div class="col-md-6">
                  <input type="hidden" name="flightnum" value="<?php echo $random_number; ?>">
                  <input type="text" class="form-control" value="<?php echo $flight_number; ?>" disabled>
               </div>
            </div>
            <div class="form-group">
               <label class="col-md-3 control-label" for="aircraft">Aircraft</label>
               <div class="col-md-6">
                  <select class="form-control" id="aircraft" name="aircraft">
                  <?php
                     echo '<option value="'.$aircraft->id.'" '.$sel.'>'.$aircraft->fullname.' ('.$aircraft->registration.')</option>';
                     ?>
                  </select>
               </div>
            </div>
            <div class="form-group">
               <label class="col-md-3 control-label" for="depicao">Departure ICAO</label>
               <div class="col-md-6">
               		<input type="hidden" name="depicao" value="<?php echo $last_flight->arricao; ?>">
                  <input id="depicao" disabled class="airport_select disabled form-control" value="<?php echo $last_flight->arricao;?>" />
               </div>
            </div>
            <div class="form-group">
               <label class="col-md-3 control-label" for="arricao">Arrival ICAO</label>
               <div class="col-md-6">
                  <select class="form-control" name="arricao">
                  <?php
                     foreach($hubs as $hub) {
                     	if($hub->icao == 'ADMI' || $hub->icao == 'ADML') {
                     		
                     	} else {
                     		echo '<option value="'.$hub->icao.'">'.$hub->icao.' '.$hub->name.'</option>';			
                     	}
                     }
                     ?>
                  </select>
               </div>
            </div>
            <div class="form-group">
               <label class="col-md-3 control-label" for="deptime">Departure Time</label>
               <div class="col-md-6">
                  <input id="deptime" name="deptime" class="form-control" value="<?php echo $schedule->deptime?>" />
                  <span class="help-block"><span class="text-danger">*</span> HH:MM format in UTC</span>
               </div>
            </div>
            <div class="form-group">
               <label class="col-md-3 control-label" for="arrtime">Arrival Time</label>
               <div class="col-md-6">
                  <input id="arrtime" name="arrtime" class="form-control" value="<?php echo $schedule->arrtime?>" />
                  <span class="help-block"><span class="text-danger">*</span> HH:MM format in UTC</span>
               </div>
            </div>
            <div class="form-group">
               <label class="col-md-3 control-label" for="flighttime">Flight Time</label>
               <div class="col-md-6">
                  <input id="flighttime" name="flighttime" class="form-control" value="<?php echo $schedule->flighttime?>" />
                  <span class="help-block"><span class="text-danger">*</span> HH:MM format</span>
               </div>
            </div>
            
            <div class="form-group">
               <label class="col-md-3 control-label" for="flightlevel">Cruise Alt (In Altitude AMSL)</label>
               <div class="col-md-6">
                  <input id="flightlevel" name="flightlevel" class="form-control" value="<?php echo $schedule->flightlevel?>" />
                  <span class="help-block">Enter full Altitude to be accurrate with the ACARS Tracking Software (Optional)</span>
               </div>
            </div>
            <div class="form-group">
               <label class="col-md-3 control-label" for="route">Route</label>
               <div class="col-md-6">
                  <textarea rows="3" class="form-control" placeholder="Route with DEPP/ARR " name="route" style="width: 100%; height: 75px; font-weight:700" id="route"><?php echo $schedule->route?></textarea>
                  <span class="help-block">Optional</span>
               </div>
            </div>
            <div class="form-group">
               <label class="col-md-3 control-label" for="notes">Notes</label>
               <div class="col-md-6">
                  <textarea rows="9" class="form-control" placeholder="Flight Notes" name="notes" style="width: 100%; height: 150px; font-weight:700">CreatedBy: <?php echo Auth::DisplayName(); ?> | CreatedDate: <?php echo date(DATE_FORMAT); ?></textarea>
               </div>
            </div>
            <center>
               <div class="form-group pull-center">
                  <input type="submit" value="Create Relief Flight" class="btn btn-sm btn-primary" />
               </div>
            </center>
         </form>
      </div>
   </div>
</div>
<div id="myModal" class="modal fade" role="dialog">
   <div class="modal-dialog">
      <!-- Modal content-->
      <div class="modal-content">
         <div class="modal-header">
            <button type="button" class="close" data-dismiss="modal">&times;</button>
            <h4 class="modal-title"><strong><?php echo SITE_NAME; ?></strong> | Charter Operations</h4>
         </div>
         <div class="modal-body">
            <p>1.0<br>You agree that you have supplied all the necessary information for creating a charter leg</p>
            <p>1.1<br>You acknowledge that only 30 Charter legs can be created and if you exhaust your limit, you may be charged credit for creating new set of Charters</p>
            <p>1.2<br><?php echo SITE_NAME; ?> Flight Operations department holds the rights to disable any leg if they find it to be inappropriate</p>
         </div>
         <div class="modal-footer">
            <button type="button" class="btn btn-info" data-dismiss="modal">Okay, i've read them</button>
         </div>
      </div>
   </div>
</div>