<?php
////////////////////////////////////////////////////////////////////////////
//Crazycreatives CharterOps module for phpVMS virtual airline system//
//@author Manuel Seiwald                                                  //
//@copyright Copyright (c) 2014, Manuel Seiwald, All Rights Reserved      //
////////////////////////////////////////////////////////////////////////////




class CharterOps extends CodonModule {
	
	  public function HTMLHead()
    {
        $this->set('sidebar', 'charterops/sidebar.php');
    }

    public function NavBar()
    {
        echo '<li><a href="'.SITE_URL.'/admin/index.php/CharterOps">Charter Ops</a></li>';
    }

    public function index() {
          CharterOpsData::deleteexpired();
			$fleet = CharterOpsData::getfleet();
			$target = CharteropsData::getsettings();
			if($target->autocreate == '1' && count($fleet) > '0') {
				$curcharters = CharterOpsData::countcharters();
				
				
				if($target->howmanyauto > $curcharters)
					{
						CharterOpsData::createroundtrip();
					return self::index();
					}
			}
		       $this->set('setting', CharterOpsData::getsettings());
          $this->set('flights', CharterOpsData::getallautoflights());
          $this->show('charterops/index.tpl');
    }

public function pilotflights() {
          $this->set('flights', CharterOpsData::getallpilotflights());
          $this->show('charterops/pilotflights.tpl');
    }


public function settings() {
		  $this->set('setting', CharterOpsData::getsettings());
$this->set('countries', CharterOpsData::getallcountries());
          $this->show('charterops/settings.tpl');
    }


public function savesettings($id) {

        $chartercode = trim(DB::escape($this->post->chartercode));
		$pilotcreate = trim(DB::escape($this->post->pilotcreate));
		$autocreate = trim(DB::escape($this->post->autocreate));
		$howmanyauto = trim(DB::escape($this->post->howmanyauto));
		$saisonalflights = trim(DB::escape($this->post->saisonalflights));
		$oneflightcharter = trim(DB::escape($this->post->oneflightcharter));
 $limittoregions = trim(DB::escape($this->post->limittoregions));
 $usechartairline = trim(DB::escape($this->post->usechartairline));
	 $startflnum = trim(DB::escape($this->post->startflnum));
	 $limitpermonth = trim(DB::escape($this->post->limitpermonth));
$regions = $this->post->regions;
if($regions){
$regions = DB::escape(implode(':', $regions));
}
if($this->post->prefdepapts){
$prefdepapts = explode(',', trim(DB::escape($this->post->prefdepapts)));
$prefdepapts = implode(':', $prefdepapts);
}
		
        CharterOpsData::SaveSettings($id, $chartercode, $pilotcreate, $autocreate, $howmanyauto, $saisonalflights, $oneflightcharter, $limittoregions, $usechartairline, $startflnum, $regions , $prefdepapts, $limitpermonth);
        
		$this->set('message', 'Settings Saved!');
	    $this->show('core_success.tpl');
        $this->index();
    }


	public function fleet() {
		  $this->set('aircraft', CharterOpsData::getfleet());
          $this->show('charterops/fleet.tpl');
    }

public function addaircraft() {
		   
		     $this->set('action', 'addaircraft');
       $this->set('allaircraft', OperationsData::getAllAircraft());
      $this->show('charterops/aircraftform.tpl');
    }
	
	
	public function editaircraft($id) {
		   
		  $this->set('action', 'editaircraft');
   $this->set('allaircraft', OperationsData::getAllAircraft());
   $this->set('caircraft', CharterOpsData::getaircraftdata($id));
          $this->show('charterops/aircraftform.tpl');
    }
	
	
	
	public function aircraftaction()
	{
		if(isset($this->post->action))
		{
			if($this->post->action == 'addaircraft')
			{
				$this->submitfleetaircraft();
			}
			elseif($this->post->action == 'editaircraft')
			{
				$this->editfleetaircraft();
			}
		}
	}
	
	
	protected function submitfleetaircraft() {

        $oid = trim(DB::escape($this->post->oid));
		$serviceceiling = trim(DB::escape($this->post->serviceceiling));
		$runway = trim(DB::escape($this->post->runway));
		$mindistance = trim(DB::escape($this->post->mindistance));
		$ticketprice = trim(DB::escape($this->post->ticketprice));
		$cruisespeed = trim(DB::escape($this->post->cruisespeed));
		
		
        CharterOpsData::savefleetaircraft($oid, $serviceceiling, $runway, $mindistance, $ticketprice, $cruisespeed);
        
		$this->set('message', 'Aircraft Added!');
	    $this->show('core_success.tpl');
        $this->fleet();
    }
	
	
	protected function editfleetaircraft() {

 $fid = DB::escape($this->post->fid);
 $oid = trim(DB::escape($this->post->oid));
		$serviceceiling = trim(DB::escape($this->post->serviceceiling));
		$runway = trim(DB::escape($this->post->runway));
		$mindistance = trim(DB::escape($this->post->mindistance));
		$ticketprice = trim(DB::escape($this->post->ticketprice));
		$cruisespeed = trim(DB::escape($this->post->cruisespeed));
		
		
		
        CharterOpsData::editfleetaircraft($fid, $oid, $serviceceiling, $runway, $mindistance, $ticketprice, $cruisespeed);
        
		$this->set('message', 'Aircraft Edited!');
	    $this->show('core_success.tpl');
        $this->fleet();
    }


public function deleteaircraft($id){
 CharterOpsData::deletechartaircr($id);
		$this->set('message', 'Aircraft Removed!');
	    $this->show('core_success.tpl');
 $this->fleet();
}


public function airports() {
		  $this->set('airports', CharterOpsData::getfleet());
          $this->show('charterops/airports.tpl');
    }

public function viewairport() {
$icao = DB::escape(trim($this->post->icao));
if(!$icao)
{
		$this->set('message', 'No ICAO Code was entered!');
	    $this->show('core_error.tpl');
 $this->airports();
return;
}
 $this->set('action', 'editairport');
  $this->set('countries', CharterOpsData::getallcountries());
   $this->set('airport', CharterOpsData::getairportinfo($icao));
          $this->show('charterops/airportform.tpl');
    }

public function addairport() {
		   
		     $this->set('action', 'addairport');
       $this->set('countries', CharterOpsData::getallcountries());
      $this->show('charterops/airportform');
    }
	
	
	public function editairport($icao) {
		   
		  $this->set('action', 'editairport');
  $this->set('countries', CharterOpsData::getallcountries());
   $this->set('airport', CharterOpsData::getairportinfo($icao));
          $this->show('charterops/airportform');
    }
	
	
	
	public function airportaction()
	{
		if(isset($this->post->action))
		{
			if($this->post->action == 'addairport')
			{
				$this->submitairport();
			}
			elseif($this->post->action == 'editairport')
			{
				$this->updateairport();
			}
		}
	}
	
	
	protected function submitairport() {

   $icao = trim(DB::escape($this->post->icao));
		$name = DB::escape($this->post->name);
		$latitude = trim(DB::escape($this->post->latitude));
		$longitude = trim(DB::escape($this->post->longitude));
		$elevation = trim(DB::escape($this->post->elevation));
   $city = DB::escape($this->post->city);
   $country = $this->post->country;
   $country = explode(':', $country);
   $countrycode = DB::escape($country[0]);
		$countryname = DB::escape($country[1]);
   $runwaylength = DB::escape($this->post->runwaylength);
		
        CharterOpsData::saveairport($icao, $name, $latitude, $longitude, $elevation, $countrycode, $city, $countryname, $runwaylength);
        
		$this->set('message', 'Airport Added!');
	    $this->show('core_success.tpl');
        $this->airports();
    }
	
	
	protected function updateairport() {

   $id = trim(DB::escape($this->post->id));
   $icao = trim(DB::escape($this->post->icao));
		$name = DB::escape($this->post->name);
		$latitude = trim(DB::escape($this->post->latitude));
		$longitude = trim(DB::escape($this->post->longitude));
		$elevation = trim(DB::escape($this->post->elevation));
   $city = DB::escape($this->post->city);
   $country = $this->post->country;
   $country = explode(':', $country);
   $countrycode = DB::escape($country[0]);
		$countryname = DB::escape($country[1]);
   $runwaylength = DB::escape($this->post->runwaylength);
		
		
		
        CharterOpsData::updateairport($id, $icao, $name, $latitude, $longitude, $elevation, $countrycode, $city, $countryname, $runwaylength);
        
		$this->set('message', 'Airport Edited!');
	    $this->show('core_success.tpl');
        $this->airports();
    }


public function deleteairport($id){
 CharterOpsData::deleteairport($id);
		$this->set('message', 'Airport Removed!');
	    $this->show('core_success.tpl');
 $this->airports();
}


public function tourops() {
		  $this->set('tourops', CharterOpsData::gettouroperators());
          $this->show('charterops/tourops.tpl');
    }

public function addtourop() {
		   
		     $this->set('action', 'addtourop');
        $this->set('countries', CharterOpsData::getallcountries());
      $this->show('charterops/touropform.tpl');
    }
	
	
	public function edittourop($id) {
		   
		  $this->set('action', 'edittourop');
    $this->set('countries', CharterOpsData::getallcountries());
   $this->set('tourop', CharterOpsData::gettouropinfo($id));
          $this->show('charterops/touropform.tpl');
    }
	
	
	
	public function touropaction()
	{
		if(isset($this->post->action))
		{
			if($this->post->action == 'addtourop')
			{
				$this->submittourop();
			}
			elseif($this->post->action == 'edittourop')
			{
				$this->updatetourop();
			}
		}
	}
	
	
	protected function submittourop() {

        $name = DB::escape($this->post->name);
		$logocode = trim(DB::escape($this->post->logocode));
	 $regions = $this->post->regions;
   if($regions){
$regions = DB::escape(implode(':', $regions));
}
		
		
        CharterOpsData::savetourop($name, $regions, $logocode);
        
		$this->set('message', 'Tour Operator Added!');
	    $this->show('core_success.tpl');
        $this->tourops();
    }
	
	
	protected function updatetourop() {

   $id = DB::escape($this->post->id);
   $name = DB::escape($this->post->name);
		$logocode = trim(DB::escape($this->post->logocode));
	 $regions = $this->post->regions;
   if($regions){
$regions = DB::escape(implode(':', $regions));
}

		
		
		
        CharterOpsData::edittourop($id, $name, $regions, $logocode);
        
		$this->set('message', 'Tour Operator Edited!');
	    $this->show('core_success.tpl');
        $this->tourops();
    }


public function deletetourop($id){
 CharterOpsData::deletetourop($id);
		$this->set('message', 'Tour Operator Removed!');
	    $this->show('core_success.tpl');
 $this->fleet();
}



public function resetcharters() {

CharterOpsData::deletecurrentcharters();
self::createnewautocharters();
		$this->set('message', 'New Charters Created!');
	    $this->show('core_success.tpl');
    }

public function createnewautocharters()
{
$target = CharteropsData::getsettings();
if($target->autocreate != '1') { exit; }
$curcharters = CharterOpsData::countcharters();
if($target->howmanyauto > $curcharters)
{
CharterOpsData::createroundtrip();
return self::createnewautocharters();
}
else
{
	return;
}
}

public function deleteallcharters() {

CharterOpsData::deleteallcharters();
		$this->set('message', 'All Charters Deleted!');
	    $this->show('core_success.tpl');
    }

public function deleteflight($id) {

CharterOpsData::deleteflight($id);
		$this->set('message', 'Charter Flight Deleted!');
	    $this->show('core_success.tpl');
    }
	

public function test()
{
$this->show('charterops/test.tpl');
}
}
	