<?php 
///////////////////////////////////////////////
///  PilotAwardsSystem v2.0 by php-mods.eu  ///
///            Author php-mods.eu           ///
///            Packed at 8/12/2019          ///
///     Copyright (c) 2019, php-mods.eu     ///
///////////////////////////////////////////////

class Awards extends CodonModule {
//Main Functions
    public function permission_check() {
        if(!PilotGroups::group_has_perm(Auth::$usergroups, EDIT_AWARDS)) {
            $this->set('message', 'You do not have the permission to access this page.');
            $this->show('core_error');
            return 0;
        }
        $licensekey = AwardData::getSetting(1)->setting_value;
        $localkey = AwardData::getSetting(4)->setting_value;
        $results = AwardData::check_license($licensekey, $localkey);
        switch ($results['status']) {
            case "Active":
                if(!empty($results['localkey'])) {
                    $localkeydata = $results['localkey'];
                    AwardData::updateSetting(4, $localkeydata);
                }
                $status = 1;
                break;
            case "Invalid":
                $this->set('message', 'Your License key is Invalid');
                $this->show('core_error');
                $status = 0;
                break;
            case "Expired":
                $this->set('message', 'Your License key is Expired');
                $this->show('core_error');
                $status = 0;
                break;
            case "Suspended":
                $this->set('message', 'Your License key is Suspended');
                $this->show('core_error');
                $status = 0;
                break;
            default:
                $this->set('message', 'Invalid Response');
                $this->show('core_error');
                $status = 0;
                break;
        }
        return $status;
    }
	public function HTMLHead() {
        $this->set('sidebar', 'awards/award_sidebar.php');
    }
	public function NavBar() {
		if(PilotGroups::group_has_perm(Auth::$usergroups, EDIT_AWARDS)) {
        	echo '<li><a href="'.SITE_URL.'/admin/index.php/awards">Awards System</a></li>';
		}
    }
	public function index() {
		if(!self::permission_check()) return;
		$this->show('awards/award_index');
	}
	public function last_issues() {
        if(!self::permission_check()) return;
		$this->set('issues', AwardData::last_issues(50));
		$this->show('awards/last_issues');
	}
//Award Categories
	public function awardadm() {
        if(!self::permission_check()) return;
		$this->set('awardadm', AwardData::categories());
		$this->show('awards/award_admin');
	}
	public function category_add() {
        if(!self::permission_check()) return;
	    $this->show('awards/category_add');
	}
	public function category_add_db() {
        if(!self::permission_check()) return;
		if($this->post->name == '')
		{
			$this->set('message', 'Some fields are missing! Fill them all please.');
			$this->show('core_error');
			self::category_add();
			return;
		}	
		$name = DB::escape($this->post->name);
		$ai = DB::escape($this->post->ai);
		AwardData::insert_category($name, $ai);
		$this->set('message', 'Award Category Added Successfully');
		$this->show('core_success');
		self::awardadm();
		LogData::addLog(Auth::$userinfo->pilotid, "[Pilot Awards] Added an award category titled \"{$name}\"");
	}
	public function category_edit($id) {
        if(!self::permission_check()) return;
		$this->set('form', AwardData::category_data($id));
		$this->show('awards/category_edit');
	}
	public function category_edit_db() {
        if(!self::permission_check()) return;
		if($this->post->name == ''){
			$this->set('message', 'Some fields are missing! Fill them all please.');
			$this->show('core_error');
			return;
		}
		$name = DB::escape($this->post->name);
		$ai = DB::escape($this->post->ai);
		$id = DB::escape($this->post->id);
		AwardData::edit_category($name, $ai, $id);
		$this->set('message', 'Award Category Updated');
		$this->show('core_success');
		self::awardadm();
		LogData::addLog(Auth::$userinfo->pilotid, "[Pilot Awards] Updated the award category $name.");
	}
	public function categorydelete($id) {
        if(!self::permission_check()) return;
		AwardData::deleteawardissues($id);
		AwardData::deleteautoawardsbycategory($id);
		AwardData::deleteawarda($id);
		AwardData::deletecategory($id);
	    $this->set('message', 'Award Category Deleted');
	    $this->show('core_success');
		self::awardadm();
	    LogData::addLog(Auth::$userinfo->pilotid, "[Pilot Awards] Deleted an award category from the database.");
	}
//Awards
	public function award_category($id) {
        if(!self::permission_check()) return;
		$this->set('awards', AwardData::category_awards($id));
		$this->set('data', AwardData::category_data($id));
		$this->show('awards/award_category');
	}
	public function awardelete($awardid, $category) {
        if(!self::permission_check()) return;
		AwardData::deleteautoawards($awardid);
		AwardData::deleteawardissue($awardid);
		AwardData::deleteaward($awardid);
	    $this->set('message', 'Award Deleted');
	    $this->show('core_success');
		self::award_category($category);
	    LogData::addLog(Auth::$userinfo->pilotid, "[Pilot Awards] Deleted an award from the database.");
	}
	public function award_edit($awardid) {
        if(!self::permission_check()) return;
		$this->set('form', AwardData::award_data($awardid));
		$this->set('categories', AwardData::categories());
		$this->show('awards/award_edit');
	}
	public function award_edit_db() {
        if(!self::permission_check()) return;
		if($this->post->name == '' or $this->post->image == '' or $this->post->descrip == '')
		{
			$this->set('message', 'Some fields are missing! Fill them all please.');
			$this->show('core_error');
            $this->set('name', $this->post->name);
            $this->set('descrip', $this->post->descrip);
            $this->set('image', $this->post->image);
            $this->set('category', $this->post->category);
            $this->set('error', 1);
            self::award_edit($this->post->awardid);
			return;
		}
		$name = DB::escape($this->post->name);
		$descrip = DB::escape($this->post->descrip);
		$image = DB::escape($this->post->image);
		$category = DB::escape($this->post->category);
		$awardid = DB::escape($this->post->awardid);
		AwardData::edit_award($name, $descrip, $image, $category, $awardid);
		AwardData::edit_award_issue_award($category, $awardid);
		$this->set('message', 'Award Updated');
		$this->show('core_success');
		self::award_category($category);
		LogData::addLog(Auth::$userinfo->pilotid, "[Pilot Awards] Updated the award $name");
	}
	public function award_add($id) {
        if(!self::permission_check()) return;
	    $this->set('id', $id);
	    $this->show('awards/award_add');
	}
	public function award_add_db() {
        if(!self::permission_check()) return;
		if($this->post->name == '' or $this->post->descrip == '' or $this->post->image == '')
		{
			$this->set('message', 'Some fields are missing! Fill them all please.');
			$this->show('core_error');
			$this->set('name', $this->post->name);
			$this->set('descrip', $this->post->descrip);
			$this->set('image', $this->post->image);
			$this->set('id', $this->post->category);
			$this->set('error', 1);
			self::award_add($this->post->category);
			return;
		}	
		$name = DB::escape($this->post->name);
		$descrip = DB::escape($this->post->descrip);
		$image = DB::escape($this->post->image);
		$category = DB::escape($this->post->category);
		AwardData::award_add($name, $descrip, $image, $category);
		$this->set('message', 'Award Added Successfully');
		$this->show('core_success');
		self::award_category($category);
		LogData::addLog(Auth::$userinfo->pilotid, "[Pilot Awards] Added an award titled \"{$name}\"");
	}
//Auto-Awards
    public function auto_reports() {
        if(!self::permission_check()) return;
	    $this->set('reports', AwardData::getAwardReports());
	    $this->show('awards/auto_reports');
    }
    public function report_details($id) {
        if(!self::permission_check()) return;
        $this->set('data', AwardData::getAwardReportData($id));
        $this->set('autoAwardsTypes', AwardData::$autoAwardsTypes);
        $this->show('awards/report_details');
    }
    public function report_remove_award($report, $issue_id) {
        if(!self::permission_check()) return;
        AwardData::removeaward($issue_id);
        $this->set('message', 'Award Removed');
        $this->show('core_success');
        self::report_details($report);
        LogData::addLog(Auth::$userinfo->pilotid, "[Pilot Awards] Removed an award from a pilot");
    }
    public function report_remove_all_awards($report) {
        if(!self::permission_check()) return;
        $data = AwardData::getAwardReportData($report);
        $issues = unserialize($data->report);

        if($issues) {
            foreach($issues as $issue) {
                $setting = AwardData::setting_info($issue['setting']);
                $check = AwardData::pilotAwardIssued($setting->awardid, $issue['pilot']);
                AwardData::removeaward($check->id);
            }
        }
        $this->set('message', 'Awards Removed');
        $this->show('core_success');
        self::report_details($report);
        LogData::addLog(Auth::$userinfo->pilotid, "[Pilot Awards] Removed all the awardings of an auto award report.");
    }
	public function auto_awards() {
        if(!self::permission_check()) return;
		$this->set('autoawards', AwardData::getAutoAwards());
		$this->set('autoAwardTypes', AwardData::getAutoAwardTypes());
		$this->set('awards', AwardData::getallawards());
		$this->set('airlines', OperationsData::getAllAirlines());
		$this->set('aircraft', AwardData::getAllAircraftTypes());
		$this->set('acars', AwardData::getAllACARS());
		$this->set('settings', AwardData::getSettings());
		$this->show('awards/auto_awards');
	}
	public function auto_award_edit($id) {
        if(!self::permission_check()) return;
		$this->set('set', AwardData::setting_info($id));
        $this->set('autoAwardTypes', AwardData::getAutoAwardTypes());
        $this->set('awards', AwardData::getallawards());
        $this->set('airlines', OperationsData::getAllAirlines());
        $this->set('aircraft', AwardData::getAllAircraftTypes());
        $this->set('acars', AwardData::getAllACARS());
        $this->set('tours', AwardData::getSimpilotTours());
        $this->set('settings', AwardData::getSettings());
		$this->show('awards/auto_award_edit');
	}
	public function autoaward_edit() {
        if(!self::permission_check()) return;

        $type = DB::escape($this->post->type);
        if(in_array($type, array(1,2,5,19,20,21,22,23,24,25,26))) {
            $achieve = DB::escape($this->post->{"achieve_".$this->post->type});
        } elseif(in_array($type, array(3,4,6,7,8,9,10,11,13,14,15,16,18))) {
            $achieve = DB::escape($this->post->{"achieve_".$this->post->type});
            $achieve_a = DB::escape($this->post->{"achieve_".$this->post->type."a"});
            $achieve = $achieve.'|'.$achieve_a;
        } elseif(in_array($type, array(12,17))) {
            $achieve = DB::escape($this->post->{"achieve_".$this->post->type});
            $achieve_a = DB::escape($this->post->{"achieve_".$this->post->type."a"});
            $achieve_b = DB::escape($this->post->{"achieve_".$this->post->type."b"});
            $achieve = $achieve.'|'.$achieve_a.'|'.$achieve_b;
        }
        if($achieve == '' || $this->post->awardid == '') {
            $this->set('message', 'Some fields are missing! Fill them all please.');
            $this->show('core_error');
            self::auto_award_edit($this->post->auto);
            return;
        }
        $awardid = DB::escape($this->post->awardid);
        $type = DB::escape($this->post->type);
        $comment = DB::escape($this->post->comment);
        $auto = DB::escape($this->post->auto);
        $id = DB::escape($this->post->id);
        AwardData::edit_autoaward($achieve, $awardid, $type, $comment, $auto, $id);
        $this->set('message', 'Auto Award Setting Updated Successfully');
        $this->show('core_success');
        self::auto_awards();
        LogData::addLog(Auth::$userinfo->pilotid, "[Pilot Awards] Updated an auto award setting.");
	}
	public function delete_autoaward($id) {
        if(!self::permission_check()) return;
		AwardData::delete_autoaward($id);
		$this->set('message', 'Auto Award Setting Deleted');
		$this->show('core_success');
		self::auto_awards();
		LogData::addLog(Auth::$userinfo->pilotid, "[Pilot Awards] Removed an auto award setting.");
	}
	public function autoaward_add() {
        if(!self::permission_check()) return;
        $type = DB::escape($this->post->type);
		if(in_array($type, array(1,2,5,19,20,21,22,23,24,25,26))) {
		    $achieve = DB::escape($this->post->{"achieve_".$this->post->type});
        } elseif(in_array($type, array(3,4,6,7,8,9,10,11,13,14,15,16,18))) {
            $achieve = DB::escape($this->post->{"achieve_".$this->post->type});
            $achieve_a = DB::escape($this->post->{"achieve_".$this->post->type."a"});
            $achieve = $achieve.'|'.$achieve_a;
        } elseif(in_array($type, array(12,17))) {
            $achieve = DB::escape($this->post->{"achieve_".$this->post->type});
            $achieve_a = DB::escape($this->post->{"achieve_".$this->post->type."a"});
            $achieve_b = DB::escape($this->post->{"achieve_".$this->post->type."b"});
            $achieve = $achieve.'|'.$achieve_a.'|'.$achieve_b;
        }
        if($achieve == '' || $this->post->awardid == '') {
            $this->set('message', 'Some fields are missing! Fill them all please.');
            $this->show('core_error');
            self::auto_awards();
            return;
        }
		$awardid = DB::escape($this->post->awardid);

		$auto = DB::escape($this->post->auto);
		$comment = DB::escape($this->post->comment);
		AwardData::autoaward_add($achieve, $awardid, $type, $comment, $auto);
		$this->set('message', 'Auto Award Setting Added Successfully');
		$this->show('core_success');
		self::auto_awards();
		LogData::addLog(Auth::$userinfo->pilotid, "[Pilot Awards] Added a new auto award setting.");
	}
	public function run_setting($settingid) {
        if(!self::permission_check()) return;
	    $awards_issued = array();
        $syssettings = AwardData::getSettings();
        $pilotdata = AwardData::pilots();
		$setting = AwardData::setting_info($settingid);
        $subject = "Auto Awarded by the SYSTEM";
        $message = Template::Get('awards/emails/awarded.php', true, true, true);
        echo "<h3>Issuing Awards to Pilots</h3>";
        echo '<p>Award to Issue: '.$setting->name.'</p>';
        if($setting->type == 1) {
            foreach($pilotdata as $pilot) {
                $check = AwardData::check_if_issued($setting->awardid, $pilot->pilotid);
                if(!$check) {
                    if($pilot->totalhours >= $setting->achieve) {
                        $comment = AwardData::setUpAwardIssueComment($setting->comment, $pilot, $setting->achieve);
                        AwardData::award_issue($setting->awardid, $pilot->pilotid, $comment);
                        if($syssettings[3]->setting_value == 1) {
                            Util::SendEmail($pilot->email, $subject, $message);
                        }
                        $awards_issued[] = array('pilot' => $pilot->pilotid, 'setting' => $setting->id, 'achievement' => $setting->achieve, 'pilot_achievement' => $pilot->totalhours);
                        echo "Issued Award to $pilot->firstname $pilot->lastname<br />";
                    }
                }
            }
        } elseif($setting->type == 2) {
            foreach($pilotdata as $pilot) {
                $check = AwardData::check_if_issued($setting->awardid, $pilot->pilotid);
                if(!$check) {
                    if($pilot->totalflights >= $setting->achieve) {
                        $comment = AwardData::setUpAwardIssueComment($setting->comment, $pilot, $setting->achieve);
                        AwardData::award_issue($setting->awardid, $pilot->pilotid, $comment);
                        if($syssettings[3]->setting_value == 1) {
                            Util::SendEmail($pilot->email, $subject, $message);
                        }
                        $awards_issued[] = array('pilot' => $pilot->pilotid, 'setting' => $setting->id, 'achievement' => $setting->achieve, 'pilot_achievement' => $pilot->totalflights);
                        echo "Issued Award to $pilot->firstname $pilot->lastname<br />";
                    }
                }
            }
        } elseif($setting->type == 3) {
            $achieve = explode('|', $setting->achieve);
            $min_landing = $achieve[0];
            $max_landing = $achieve[1];
            if($max_landing > $min_landing) {
                $temp = $max_landing;
                $max_landing = $min_landing;
                $min_landing = $temp;
            }
            foreach($pilotdata as $pilot) {
                $check = AwardData::check_if_issued($setting->awardid, $pilot->pilotid);
                if(!$check) {
                    $landing = AwardData::getPilotLanding($pilot->pilotid, $min_landing, $max_landing);
                    if($landing) {
                        $comment = AwardData::setUpAwardIssueComment($setting->comment, $pilot, $setting->achieve);
                        AwardData::award_issue($setting->awardid, $pilot->pilotid, $comment);
                        if($syssettings[3]->setting_value == 1) {
                            Util::SendEmail($pilot->email, $subject, $message);
                        }
                        $awards_issued[] = array('pilot' => $pilot->pilotid, 'setting' => $setting->id, 'achievement' => $setting->achieve, 'pilot_achievement' => $landing->pirepid);
                        echo "Issued Award to $pilot->firstname $pilot->lastname<br />";
                    }
                }
            }
        } elseif($setting->type == 4) {
            $achieve = explode('|', $setting->achieve);
            $achieve_days = $achieve[0];
            $achieve_weekdays = $achieve[1];
            foreach($pilotdata as $pilot) {
                $check = AwardData::check_if_issued($setting->awardid, $pilot->pilotid);
                if(!$check) {
                    $joined = new DateTime($pilot->joindate);
                    $current = new DateTime();
                    $interval = $current->diff($joined);
                    $days = $interval->days;
                    if($achieve_weekdays == 1) {
                        $period = new DatePeriod($joined, new DateInterval('P1D'), $current);

                        foreach($period as $dt) {
                            $curr = $dt->format('D');
                            // substract if Saturday or Sunday
                            if ($curr == 'Sat' || $curr == 'Sun') {
                                $days--;
                            }
                        }
                    }
                    if($days >= $achieve_days) {
                        $comment = AwardData::setUpAwardIssueComment($setting->comment, $pilot, $setting->achieve);
                        AwardData::award_issue($setting->awardid, $pilot->pilotid, $comment);
                        if($syssettings[3]->setting_value == 1) {
                            Util::SendEmail($pilot->email, $subject, $message);
                        }
                        $awards_issued[] = array('pilot' => $pilot->pilotid, 'setting' => $setting->id, 'achievement' => $setting->achieve, 'pilot_achievement' => $days);
                        echo "Issued Award to $pilot->firstname $pilot->lastname<br />";

                    }
                }
            }
        } elseif($setting->type == 5) {
            foreach($pilotdata as $pilot) {
                $check = AwardData::check_if_issued($setting->awardid, $pilot->pilotid);
                if(!$check) {
                    $distance = AwardData::sumPilotDistance($pilot->pilotid);
                    if($distance >= $setting->achieve) {
                        $comment = AwardData::setUpAwardIssueComment($setting->comment, $pilot, $setting->achieve);
                        AwardData::award_issue($setting->awardid, $pilot->pilotid, $comment);
                        if($syssettings[3]->setting_value == 1) {
                            Util::SendEmail($pilot->email, $subject, $message);
                        }
                        $awards_issued[] = array('pilot' => $pilot->pilotid, 'setting' => $setting->id, 'achievement' => $setting->achieve, 'pilot_achievement' => $distance);
                        echo "Issued Award to $pilot->firstname $pilot->lastname<br />";
                    }
                }
            }
        } elseif($setting->type == 6) {
            $achieve = explode('|',$setting->achieve);
            $totalhours = $achieve[0];
            $airline = $achieve[1];
            foreach($pilotdata as $pilot) {
                $check = AwardData::check_if_issued($setting->awardid, $pilot->pilotid);
                if(!$check) {
                    $pilothours = AwardData::sumPilotHoursByAirline($pilot->pilotid, $airline);
                    if($pilothours >= $totalhours) {
                        $comment = AwardData::setUpAwardIssueComment($setting->comment, $pilot, $setting->achieve);
                        AwardData::award_issue($setting->awardid, $pilot->pilotid, $comment);
                        if($syssettings[3]->setting_value == 1) {
                            Util::SendEmail($pilot->email, $subject, $message);
                        }
                        $awards_issued[] = array('pilot' => $pilot->pilotid, 'setting' => $setting->id, 'achievement' => $setting->achieve, 'pilot_achievement' => $pilothours);
                        echo "Issued Award to $pilot->firstname $pilot->lastname<br />";
                    }
                }
            }
        } elseif($setting->type == 7) {
            $achieve = explode('|',$setting->achieve);
            $totalhours = $achieve[0];
            $aircraft = $achieve[1];
            foreach($pilotdata as $pilot) {
                $check = AwardData::check_if_issued($setting->awardid, $pilot->pilotid);
                if(!$check) {
                $pilothours = AwardData::sumPilotHoursByAircraft($pilot->pilotid, $aircraft);
                if($pilothours >= $totalhours) {
                        $comment = AwardData::setUpAwardIssueComment($setting->comment, $pilot, $setting->achieve);
                        AwardData::award_issue($setting->awardid, $pilot->pilotid, $comment);
                        if($syssettings[3]->setting_value == 1) {
                            Util::SendEmail($pilot->email, $subject, $message);
                        }
                        $awards_issued[] = array('pilot' => $pilot->pilotid, 'setting' => $setting->id, 'achievement' => $setting->achieve, 'pilot_achievement' => $pilothours);
                        echo "Issued Award to $pilot->firstname $pilot->lastname<br />";
                    }
                }
            }
        } elseif($setting->type == 8) {
            $achieve = explode('|',$setting->achieve);
            $totalflights = $achieve[0];
            $airline = $achieve[1];
            foreach($pilotdata as $pilot) {
                $check = AwardData::check_if_issued($setting->awardid, $pilot->pilotid);
                if(!$check) {
                    $pilotflights = AwardData::sumPilotFlightsByAirline($pilot->pilotid, $airline);
                    if($pilotflights >= $totalflights) {
                        $comment = AwardData::setUpAwardIssueComment($setting->comment, $pilot, $setting->achieve);
                        AwardData::award_issue($setting->awardid, $pilot->pilotid, $comment);
                        if($syssettings[3]->setting_value == 1) {
                            Util::SendEmail($pilot->email, $subject, $message);
                        }
                        $awards_issued[] = array('pilot' => $pilot->pilotid, 'setting' => $setting->id, 'achievement' => $setting->achieve, 'pilot_achievement' => $pilotflights);
                        echo "Issued Award to $pilot->firstname $pilot->lastname<br />";
                    }
                }
            }
        } elseif($setting->type == 9) {
            $achieve = explode('|',$setting->achieve);
            $totalflights = $achieve[0];
            $aircraft = $achieve[1];
            foreach($pilotdata as $pilot) {
                $check = AwardData::check_if_issued($setting->awardid, $pilot->pilotid);
                if(!$check) {
                    $pilotflights = AwardData::sumPilotFlightsByAircraft($pilot->pilotid, $aircraft);
                    if($pilotflights >= $totalflights) {
                        $comment = AwardData::setUpAwardIssueComment($setting->comment, $pilot, $setting->achieve);
                        AwardData::award_issue($setting->awardid, $pilot->pilotid, $comment);
                        if($syssettings[3]->setting_value == 1) {
                            Util::SendEmail($pilot->email, $subject, $message);
                        }
                        $awards_issued[] = array('pilot' => $pilot->pilotid, 'setting' => $setting->id, 'achievement' => $setting->achieve, 'pilot_achievement' => $pilotflights);
                        echo "Issued Award to $pilot->firstname $pilot->lastname<br />";
                    }
                }
            }
        } elseif($setting->type == 10) {
            $achieve = explode('|',$setting->achieve);
            $totaldistance = $achieve[0];
            $airline = $achieve[1];
            foreach($pilotdata as $pilot) {
                $check = AwardData::check_if_issued($setting->awardid, $pilot->pilotid);
                if(!$check) {
                    $pilotdistance = AwardData::sumPilotDistanceByAirline($pilot->pilotid, $airline);
                    if($pilotdistance >= $totaldistance) {
                        $comment = AwardData::setUpAwardIssueComment($setting->comment, $pilot, $setting->achieve);
                        AwardData::award_issue($setting->awardid, $pilot->pilotid, $comment);
                        if($syssettings[3]->setting_value == 1) {
                            Util::SendEmail($pilot->email, $subject, $message);
                        }
                        $awards_issued[] = array('pilot' => $pilot->pilotid, 'setting' => $setting->id, 'achievement' => $setting->achieve, 'pilot_achievement' => $pilotdistance);
                        echo "Issued Award to $pilot->firstname $pilot->lastname<br />";
                    }
                }
            }
        } elseif($setting->type == 11) {
            $achieve = explode('|',$setting->achieve);
            $totaldistance = $achieve[0];
            $aircraft = $achieve[1];
            foreach($pilotdata as $pilot) {
                $check = AwardData::check_if_issued($setting->awardid, $pilot->pilotid);
                if(!$check) {
                    $pilotdistance = AwardData::sumPilotDistanceByAircraft($pilot->pilotid, $aircraft);
                    if($pilotdistance >= $totaldistance) {
                        $comment = AwardData::setUpAwardIssueComment($setting->comment, $pilot, $setting->achieve);
                        AwardData::award_issue($setting->awardid, $pilot->pilotid, $comment);
                        if($syssettings[3]->setting_value == 1) {
                            Util::SendEmail($pilot->email, $subject, $message);
                        }
                        $awards_issued[] = array('pilot' => $pilot->pilotid, 'setting' => $setting->id, 'achievement' => $setting->achieve, 'pilot_achievement' => $pilotdistance);
                        echo "Issued Award to $pilot->firstname $pilot->lastname<br />";
                    }
                }
            }
        } elseif($setting->type == 12) {
            $achieve = explode('|', $setting->achieve);
            $min_landing = $achieve[0];
            $max_landing = $achieve[1];
            if($max_landing > $min_landing) {
                $temp = $max_landing;
                $max_landing = $min_landing;
                $min_landing = $temp;
            }
            $aircraft = $achieve[2];
            foreach($pilotdata as $pilot) {
                $check = AwardData::check_if_issued($setting->awardid, $pilot->pilotid);
                if(!$check) {
                    $landing = AwardData::getPilotLandingByAircraft($pilot->pilotid, $min_landing, $max_landing, $aircraft);
                    if($landing) {
                        $comment = AwardData::setUpAwardIssueComment($setting->comment, $pilot, $setting->achieve);
                        AwardData::award_issue($setting->awardid, $pilot->pilotid, $comment);
                        if($syssettings[3]->setting_value == 1) {
                            Util::SendEmail($pilot->email, $subject, $message);
                        }
                        $awards_issued[] = array('pilot' => $pilot->pilotid, 'setting' => $setting->id, 'achievement' => $setting->achieve, 'pilot_achievement' => $landing->pirepid);
                        echo "Issued Award to $pilot->firstname $pilot->lastname<br />";
                    }
                }
            }
        } elseif($setting->type == 13) {
            $achieve = explode('|',$setting->achieve);
            $totalflights = $achieve[0];
            $airport = $achieve[1];
            foreach($pilotdata as $pilot) {
                $check = AwardData::check_if_issued($setting->awardid, $pilot->pilotid);
                if(!$check) {
                    $pilotflights = AwardData::getPilotFlightsByAirport($pilot->pilotid, 'depicao', $airport);
                    if($pilotflights >= $totalflights) {
                        $comment = AwardData::setUpAwardIssueComment($setting->comment, $pilot, $setting->achieve);
                        AwardData::award_issue($setting->awardid, $pilot->pilotid, $comment);
                        if($syssettings[3]->setting_value == 1) {
                            Util::SendEmail($pilot->email, $subject, $message);
                        }
                        $awards_issued[] = array('pilot' => $pilot->pilotid, 'setting' => $setting->id, 'achievement' => $setting->achieve, 'pilot_achievement' => $pilotflights);
                        echo "Issued Award to $pilot->firstname $pilot->lastname<br />";
                    }
                }
            }
        } elseif($setting->type == 14) {
            $achieve = explode('|',$setting->achieve);
            $totalflights = $achieve[0];
            $airport = $achieve[1];
            foreach($pilotdata as $pilot) {
                $check = AwardData::check_if_issued($setting->awardid, $pilot->pilotid);
                if(!$check) {
                    $pilotflights = AwardData::getPilotFlightsByAirport($pilot->pilotid, 'arricao', $airport);
                    if($pilotflights >= $totalflights) {
                        $comment = AwardData::setUpAwardIssueComment($setting->comment, $pilot, $setting->achieve);
                        AwardData::award_issue($setting->awardid, $pilot->pilotid, $comment);
                        if($syssettings[3]->setting_value == 1) {
                            Util::SendEmail($pilot->email, $subject, $message);
                        }
                        $awards_issued[] = array('pilot' => $pilot->pilotid, 'setting' => $setting->id, 'achievement' => $setting->achieve, 'pilot_achievement' => $pilotflights);
                        echo "Issued Award to $pilot->firstname $pilot->lastname<br />";
                    }
                }
            }
        } elseif($setting->type == 15) {
            $achieve = explode('|',$setting->achieve);
            $totalhours = $achieve[0];
            $airport = $achieve[1];
            foreach($pilotdata as $pilot) {
                $check = AwardData::check_if_issued($setting->awardid, $pilot->pilotid);
                if(!$check) {
                    $pilothours = AwardData::sumPilotHoursByAirport($pilot->pilotid, 'depicao', $airport);
                    if($pilothours >= $totalhours) {
                        $comment = AwardData::setUpAwardIssueComment($setting->comment, $pilot, $setting->achieve);
                        AwardData::award_issue($setting->awardid, $pilot->pilotid, $comment);
                        if($syssettings[3]->setting_value == 1) {
                            Util::SendEmail($pilot->email, $subject, $message);
                        }
                        $awards_issued[] = array('pilot' => $pilot->pilotid, 'setting' => $setting->id, 'achievement' => $setting->achieve, 'pilot_achievement' => $pilothours);
                        echo "Issued Award to $pilot->firstname $pilot->lastname<br />";
                    }
                }
            }
        } elseif($setting->type == 16) {
            $achieve = explode('|',$setting->achieve);
            $totalhours = $achieve[0];
            $airport = $achieve[1];
            foreach($pilotdata as $pilot) {
                $check = AwardData::check_if_issued($setting->awardid, $pilot->pilotid);
                if(!$check) {
                    $pilothours = AwardData::sumPilotHoursByAirport($pilot->pilotid, 'arricao', $airport);
                    if($pilothours >= $totalhours) {
                        $comment = AwardData::setUpAwardIssueComment($setting->comment, $pilot, $setting->achieve);
                        AwardData::award_issue($setting->awardid, $pilot->pilotid, $comment);
                        if($syssettings[3]->setting_value == 1) {
                            Util::SendEmail($pilot->email, $subject, $message);
                        }
                        $awards_issued[] = array('pilot' => $pilot->pilotid, 'setting' => $setting->id, 'achievement' => $setting->achieve, 'pilot_achievement' => $pilothours);
                        echo "Issued Award to $pilot->firstname $pilot->lastname<br />";
                    }
                }
            }
        } elseif($setting->type == 17) {
            $achieve = explode('|',$setting->achieve);
            $totalflights = $achieve[0];
            $code = $achieve[1];
            $flightnum = $achieve[2];
            foreach($pilotdata as $pilot) {
                $check = AwardData::check_if_issued($setting->awardid, $pilot->pilotid);
                if(!$check) {
                    $pilotflights = AwardData::getPilotFlightsBySchedule($pilot->pilotid, $code, $flightnum);
                    if($pilotflights >= $totalflights) {
                        $comment = AwardData::setUpAwardIssueComment($setting->comment, $pilot, $setting->achieve);
                        AwardData::award_issue($setting->awardid, $pilot->pilotid, $comment);
                        if($syssettings[3]->setting_value == 1) {
                            Util::SendEmail($pilot->email, $subject, $message);
                        }
                        $awards_issued[] = array('pilot' => $pilot->pilotid, 'setting' => $setting->id, 'achievement' => $setting->achieve, 'pilot_achievement' => $pilotflights);
                        echo "Issued Award to $pilot->firstname $pilot->lastname<br />";
                    }
                }
            }
        } elseif($setting->type == 18) {
            $achieve = explode('|',$setting->achieve);
            $totalflights = $achieve[0];
            $acars = $achieve[1];
            foreach($pilotdata as $pilot) {
                $check = AwardData::check_if_issued($setting->awardid, $pilot->pilotid);
                if(!$check) {
                    $pilotflights = AwardData::getPilotFlightsByACARS($pilot->pilotid, $acars);
                    if($pilotflights >= $totalflights) {
                        $comment = AwardData::setUpAwardIssueComment($setting->comment, $pilot, $setting->achieve);
                        AwardData::award_issue($setting->awardid, $pilot->pilotid, $comment);
                        if($syssettings[3]->setting_value == 1) {
                            Util::SendEmail($pilot->email, $subject, $message);
                        }
                        $awards_issued[] = array('pilot' => $pilot->pilotid, 'setting' => $setting->id, 'achievement' => $setting->achieve, 'pilot_achievement' => $pilotflights);
                        echo "Issued Award to $pilot->firstname $pilot->lastname<br />";
                    }
                }
            }
        } elseif($setting->type == 19) {
            foreach($pilotdata as $pilot) {
                $check = AwardData::check_if_issued($setting->awardid, $pilot->pilotid);
                if(!$check) {
                    if($pilot->totalpay >= $setting->achieve) {
                        $comment = AwardData::setUpAwardIssueComment($setting->comment, $pilot, $setting->achieve);
                        AwardData::award_issue($setting->awardid, $pilot->pilotid, $comment);
                        if($syssettings[3]->setting_value == 1) {
                            Util::SendEmail($pilot->email, $subject, $message);
                        }
                        $awards_issued[] = array('pilot' => $pilot->pilotid, 'setting' => $setting->id, 'achievement' => $setting->achieve, 'pilot_achievement' => $pilot->totalpay);
                        echo "Issued Award to $pilot->firstname $pilot->lastname<br />";
                    }
                }
            }
        } elseif($setting->type == 20) {
            $totalfuel = $setting->achieve;
            foreach($pilotdata as $pilot) {
                $check = AwardData::check_if_issued($setting->awardid, $pilot->pilotid);
                if(!$check) {
                    $pilotfuel = AwardData::sumPilotFuelBurned($pilot->pilotid);
                    if($pilotfuel >= $totalfuel) {
                        $comment = AwardData::setUpAwardIssueComment($setting->comment, $pilot, $setting->achieve);
                        AwardData::award_issue($setting->awardid, $pilot->pilotid, $comment);
                        if($syssettings[3]->setting_value == 1) {
                            Util::SendEmail($pilot->email, $subject, $message);
                        }
                        $awards_issued[] = array('pilot' => $pilot->pilotid, 'setting' => $setting->id, 'achievement' => $setting->achieve, 'pilot_achievement' => $pilotfuel);
                        echo "Issued Award to $pilot->firstname $pilot->lastname<br />";
                    }
                }
            }
        } elseif($setting->type == 21) {
            $totaltime = $setting->achieve;
            foreach($pilotdata as $pilot) {
                $check = AwardData::check_if_issued($setting->awardid, $pilot->pilotid);
                if(!$check) {
                    $data = AwardData::getPilotLongFlightByTime($pilot->pilotid, $totaltime);
                    if($data) {
                        $comment = AwardData::setUpAwardIssueComment($setting->comment, $pilot, $setting->achieve);
                        AwardData::award_issue($setting->awardid, $pilot->pilotid, $comment);
                        if($syssettings[3]->setting_value == 1) {
                            Util::SendEmail($pilot->email, $subject, $message);
                        }
                        $awards_issued[] = array('pilot' => $pilot->pilotid, 'setting' => $setting->id, 'achievement' => $setting->achieve, 'pilot_achievement' => $data->pirepid);
                        echo "Issued Award to $pilot->firstname $pilot->lastname<br />";
                    }
                }
            }
        } elseif($setting->type == 22) {
            $totaldistance = $setting->achieve;
            foreach($pilotdata as $pilot) {
                $check = AwardData::check_if_issued($setting->awardid, $pilot->pilotid);
                if(!$check) {
                    $data = AwardData::getPilotLongFlightByDistance($pilot->pilotid, $totaldistance);
                    if($data) {
                        $comment = AwardData::setUpAwardIssueComment($setting->comment, $pilot, $setting->achieve);
                        AwardData::award_issue($setting->awardid, $pilot->pilotid, $comment);
                        if($syssettings[3]->setting_value == 1) {
                            Util::SendEmail($pilot->email, $subject, $message);
                        }
                        $awards_issued[] = array('pilot' => $pilot->pilotid, 'setting' => $setting->id, 'achievement' => $setting->achieve, 'pilot_achievement' => $data->pirepid);
                        echo "Issued Award to $pilot->firstname $pilot->lastname<br />";
                    }
                }
            }
        } elseif($setting->type == 23) {
            $forum_setting = AwardData::getSetting(5);
            if($forum_setting->setting_value == 1) {
                $totalposts = $setting->achieve;
                foreach($pilotdata as $pilot) {
                    $check = AwardData::check_if_issued($setting->awardid, $pilot->pilotid);
                    if(!$check) {
                        $pilotposts = ForumData::pilot_total_posts($pilot->pilotid);
                        if($pilotposts >= $totalposts) {
                            $comment = AwardData::setUpAwardIssueComment($setting->comment, $pilot, $setting->achieve);
                            AwardData::award_issue($setting->awardid, $pilot->pilotid, $comment);
                            if($syssettings[3]->setting_value == 1) {
                                Util::SendEmail($pilot->email, $subject, $message);
                            }
                            $awards_issued[] = array('pilot' => $pilot->pilotid, 'setting' => $setting->id, 'achievement' => $setting->achieve, 'pilot_achievement' => $pilotposts);
                            echo "Issued Award to $pilot->firstname $pilot->lastname<br />";
                        }
                    }
                }
            } else {
                echo '<font color="green"><b>PHP-Mods Forum System is Not Installed</b></font>';
            }
        } elseif($setting->type == 24) {
            $screenshot_setting = AwardData::getSetting(6);
            $totalscreenshots = $setting->achieve;
            if($screenshot_setting->setting_value != 0) {
                foreach($pilotdata as $pilot) {
                    $check = AwardData::check_if_issued($setting->awardid, $pilot->pilotid);
                    if(!$check) {
                        if($screenshot_setting->setting_value == 1) {
                            $pilotscreenshots = AwardData::countPilotSimpilotScreenshot($pilot->pilotid);
                        } else {
                            //screenshots by crazycreatives
                        }
                            if($pilotscreenshots >= $totalscreenshots) {
                            $comment = AwardData::setUpAwardIssueComment($setting->comment, $pilot, $setting->achieve);
                            AwardData::award_issue($setting->awardid, $pilot->pilotid, $comment);
                            if($syssettings[3]->setting_value == 1) {
                                Util::SendEmail($pilot->email, $subject, $message);
                            }
                            $awards_issued[] = array('pilot' => $pilot->pilotid, 'setting' => $setting->id, 'achievement' => $setting->achieve, 'pilot_achievement' => $pilotscreenshots);
                            echo "Issued Award to $pilot->firstname $pilot->lastname<br />";
                        }
                    }
                }
            } else {
                echo 'There is not any Installed Tour System in your phpVMS website.';
            }
        } elseif($setting->type == 25) {
            $tour_setting = AwardData::getSetting(7);
            $desiredtour = $setting->achieve;
            if($tour_setting->setting_value != 0) {
                foreach($pilotdata as $pilot) {
                    $check = AwardData::check_if_issued($setting->awardid, $pilot->pilotid);
                    if(!$check) {
                        if($tour_setting->setting_value == 1) {
                            $tour_completed = AwardData::checkSimpilotTourCompleted($pilot->pilotid, $desiredtour);
                        } else {
                            $tour_completed = AwardData::checkCCTourCompleted($pilot->pilotid, $desiredtour);
                        }
                        if(is_array($tour_completed) && $tour_completed['completed'] == true) {
                            $comment = AwardData::setUpAwardIssueComment($setting->comment, $pilot, $setting->achieve);
                            AwardData::award_issue($setting->awardid, $pilot->pilotid, $comment);
                            if($syssettings[3]->setting_value == 1) {
                                Util::SendEmail($pilot->email, $subject, $message);
                            }
                            $awards_issued[] = array('pilot' => $pilot->pilotid, 'setting' => $setting->id, 'achievement' => $setting->achieve, 'pilot_achievement' => $tour_completed['id']);
                            echo "Issued Award to $pilot->firstname $pilot->lastname<br />";
                        }
                    }
                }
            }
        }elseif($setting->type == 26) {
            $tour_setting = AwardData::getSetting(7);
            $totaltours = $setting->achieve;
            if($tour_setting->setting_value != 0) {
                foreach($pilotdata as $pilot) {
                    $check = AwardData::check_if_issued($setting->awardid, $pilot->pilotid);
                    if(!$check) {
                        if($tour_setting->setting_value == 1) {
                            $pilottours = AwardData::countPilotSimpilotTours($pilot->pilotid);
                        } else {
                            $pilottours = AwardData::countPilotCCTours($pilot->pilotid);
                        }
                        if($pilottours >= $totaltours) {
                            $comment = AwardData::setUpAwardIssueComment($setting->comment, $pilot, $setting->achieve);
                            AwardData::award_issue($setting->awardid, $pilot->pilotid, $comment);
                            if($syssettings[3]->setting_value == 1) {
                                Util::SendEmail($pilot->email, $subject, $message);
                            }
                            $awards_issued[] = array('pilot' => $pilot->pilotid, 'setting' => $setting->id, 'achievement' => $setting->achieve, 'pilot_achievement' => $totaltours);
                            echo "Issued Award to $pilot->firstname $pilot->lastname<br />";
                        }
                    }
                }
            }
        }
        $run_by = Auth::$userinfo->pilotid ? Auth::$userinfo->pilotid : "SYSTEM";
        if($syssettings[2]->setting_value == 1) {
            $message = "Pilot Awards - Auto Award Issue Report<br /><br />Type: CRONJOB RUN<br />";
            if(count($awards_issued) == 0) $message .= "<p>No Awards were Issued</p>";
            else {
                foreach($awards_issued as $issued) {
                    $pilot = AwardData::pilot_info($issued['pilot']);
                    $setting = AwardData::setting_info($issued['setting']);
                    $message .= "Pilot: ".PilotData::getPilotCode($pilot->code, $pilot->pilotid).' - '.$pilot->firstname.' '.$pilot->lastname.' received '.$setting->name.' Award.<br />';
                }
            }
            Util::SendEmail(ADMIN_EMAIL, "Pilot Awards Cron Job Report", $message);
        }
        $count_awards_issued = count($awards_issued);
        $data = serialize(array('type' => 'SETTING_RUN', 'run_by' => $run_by, 'total_awards_issued' => $count_awards_issued));
        $awards_issued = serialize($awards_issued);
        AwardData::pushReport($data, $awards_issued);
        echo '<br /><b>Completed!<br /><br />Award Issued to '.$count_awards_issued.' pilots.</b>';
        echo '<p><a href="'.SITE_URL.'/admin/index.php/Awards/auto_awards" class="button">Back to Auto Awards</a></p>';
	}
//Pilot Data
	public function pilot_data() {
        if(!self::permission_check()) return;
		$this->set('pilotdata', AwardData::pilots());
		$this->show('awards/pilot_data');
	}
	public function get_pilot_data() {
        if(!self::permission_check()) return;
		$pid = $this->post->pilot;
		$this->set('pilotdata', AwardData::pilots());
		$this->set('info', AwardData::pilot_info($pid));
		$this->set('categories', AwardData::awardcategories());
		$this->set('assign', AwardData::getallawards());
		$this->show('awards/pilot_data');
		$this->show('awards/pilot_info');
	}
	public function award_info($awardid, $pilotid) {
        if(!self::permission_check()) return;
		$this->set('award', AwardData::award_data($awardid));
		$this->set('details', AwardData::assign_details($awardid, $pilotid));
		$this->set('pilot', AwardData::pilot_info($pilotid));
		$this->show('awards/assigned_awards');
	}
	public function remove_assigned_award($id, $pid) {
        if(!self::permission_check()) return;
		AwardData::removeaward($id);
		$this->set('message', 'Award Removed');
	    $this->show('core_success');
		$this->set('pilotdata', AwardData::pilots());
		$this->set('info', AwardData::pilot_info($pid));
		$this->set('categories', AwardData::awardcategories());
		$this->set('assign', AwardData::getallawards());
		$this->show('awards/pilot_data');
		$this->show('awards/pilot_info');
	    LogData::addLog(Auth::$userinfo->pilotid, "[Pilot Awards] Removed an award from a pilot");
	}
	public function award_issue_db() {
        if(!self::permission_check()) return;
		if($this->post->comment == '' or $this->post->dateissued == '')
		{
			$this->set('message', 'Some fields are missing! Fill them all please.');
			$this->show('core_error');
			return;
		}	
		if($this->post->awardid == 0)
		{
			$this->set('message', 'You have to select an award.');
			$this->show('core_error');
			return;
		}
		$awardid = DB::escape($this->post->awardid);
		$pilotid = DB::escape($this->post->pilotid);
		$comment = DB::escape($this->post->comment);
		$dateissued = DB::escape($this->post->dateissued);
		AwardData::award_issue($awardid, $pilotid, $comment, $dateissued);
		$this->set('message', 'Award Issued Successfully');
		$this->show('core_success');
		$this->set('pilotdata', AwardData::pilots());
		$this->set('info', AwardData::pilot_info($pilotid));
		$this->set('categories', AwardData::awardcategories());
		$this->set('assign', AwardData::getallawards());
		$this->show('awards/pilot_data');
		$this->show('awards/pilot_info');
		$subject = "An Award has been assigned to you";
		$message = Template::Get('awards/emails/awarded.php', true, true, true);
		$data = AwardData::pilot_data($pilotid);
		Util::SendEmail($data->email, $subject, $message);
		LogData::addLog(Auth::$userinfo->pilotid, '[Pilot Awards] Issued an award to '.PilotData::getPilotCode($data->code, $data->pilotid).' - ' .$data->firstname.' ' .$data->lastname);
	}
	public function issue_edit($id) {
        if(!self::permission_check()) return;
		$this->set('form', AwardData::issue_details($id));
		$this->show('awards/issue_edit');
	}
	public function issue_edit_db() {
        if(!self::permission_check()) return;
		if($this->post->comment == '')
		{
			$this->set('message', 'Some fields are missing! Fill them all please.');
			$this->show('core_error');
			return;
		}
		$comment = DB::escape($this->post->comment);
		$pilotid = DB::escape($this->post->pilotid);
		$id = DB::escape($this->post->id);
		AwardData::edit_award_issue($comment, $id);
		$this->set('message', 'Award Issue Updated');
		$this->show('core_success');
		$this->set('pilotdata', AwardData::pilots());
		$this->set('info', AwardData::pilot_info($pilotid));
		$this->set('categories', AwardData::awardcategories());
		$this->set('assign', AwardData::getallawards());
		$this->show('awards/pilot_data');
		$this->show('awards/pilot_info');
		LogData::addLog(Auth::$userinfo->pilotid, "[Pilot Awards] Updated an award issue.");
	}
	//settings
    public function settings() {
	    $settings = AwardData::getSettings();
	    $this->set('settings', $settings);
	    $this->show('awards/settings');
    }
    public function updateSettings() {
        $licensekey = DB::escape($this->post->licensekey);
        $email_admin = DB::escape($this->post->email_admin);
        $email_pilot = DB::escape($this->post->email_pilot);
        AwardData::updateSettings($licensekey, $email_admin, $email_pilot);
        $this->set('message', 'Settings Updated Successfully');
        $this->show('core_success');
        self::settings();
    }
//Update
    public function update() {
        $licensekey = AwardData::getSetting(1)->setting_value;
        $localkey = AwardData::getSetting(4)->setting_value;
        $results = AwardData::check_license($licensekey, $localkey);
        $latest = $results['latest_version'];
        $support_expiration = $results['support_expiration'];
        $installed = explode('-', trim(file_get_contents(SITE_ROOT.'/admin/modules/Awards/version')));

        $this->set('installed', floatval($installed[0]));
        $this->set('latest', floatval($latest));
        $this->set('support_expiration', $support_expiration);
        $this->show('awards/update');
    }
}