<?php class FlightSearch extends CodonModule
{
	 
	public function HTMLHead() {
     
	    $this->set('sidebar', 'flightsearch/sidebar.php');
    
	}
	
	    public function NavBar()
    {
        echo '<li><a href="'.SITE_URL.'/admin/index.php/FlightSearch">Flight Search</a></li>';
    }


	 
	 
	public function index()
	{
		$this->set('setting', FlightSearchData::getsettings());
		$this->set('airlines', OperationsData::getAllAirlines(true));
		$this->show('flightsearch/settings.tpl');
	}
	
	
	public function savesettings()
	{
	$searchmode = DB::escape($this->post->searchmode);
	$bidtime = DB::escape($this->post->bidtime);	
	$bidtimelimit = DB::escape($this->post->bidtimelimit);	
	$allowjumpseat = DB::escape($this->post->allowjumpseat);	
	$jumpseatwait = DB::escape($this->post->jumpseatwait);	
	$jumpseatwaittime = DB::escape($this->post->jumpseatwaittime);	
	$jumpseatprice = DB::escape($this->post->jumpseatprice);	
	$nolimit = DB::escape($this->post->nolimit);
	$ranklimit = DB::escape($this->post->ranklimit);
	$daylimit = DB::escape($this->post->daylimit);
	$pilotlocation = DB::escape($this->post->pilotlocation);
	$aircraftlocation = DB::escape($this->post->aircraftlocation);
	$schedbidlimit = DB::escape($this->post->schedbidlimit);
	$bidbidlimit = DB::escape($this->post->bidbidlimit);
	$flighttypelimit = $this->post->flighttypelimit;
	$airlinelimit = $this->post->airlinelimit;
	$alreadylanded = $this->post->alreadylanded;
	$hublimit = $this->post->hublimit;
		
		if($flighttypelimit){
$flighttypelimit = DB::escape(implode(':', $flighttypelimit));
}
		if($airlinelimit){
$airlinelimit = DB::escape(implode(':', $airlinelimit));
}
		
		FlightSearchData::updatesettings($searchmode, $bidtime, $bidtimelimit, $allowjumpseat, $jumpseatwait, $jumpseatwaittime, $jumpseatprice, $nolimit, $ranklimit, $daylimit, $pilotlocation, $aircraftlocation, $schedbidlimit, $bidbidlimit, $flighttypelimit, $airlinelimit, $alreadylanded, $hublimit);
		
		$this->set('message', "Settings Saved");
		$this->show('core_success.tpl');
		$this->index();
	}
	
	
	public function recalculatejumpseat()
	{
	 $pilots = FlightSearchData::getpilotstotaljssum();
	 if($pilots)
	 foreach($pilots as $pil)
	 {
		 $pilotid = $pil->pilotid;
		 $price = $pil->totalprice;
		 
		  $sql = "UPDATE ".TABLE_PREFIX."pilots SET totalpay = totalpay - $price WHERE pilotid = '$pilotid'";
      DB::query($sql);
	 }
	 
	    $this->set('message', "All Jumpseat Ticket Prices Recalculated!");
		$this->show('core_success.tpl');
		$this->index();
	 	
	}
	
	
	public function pilotlocations()
	{
		$this->set('pilots', FlightSearchData::getpilots());
		$this->set('airports', FlightSearchData::getdepapts(0));
		$this->show('flightsearch/pilots.tpl');
	}
	
	public function aircraftlocations()
	{
		$this->set('aircrafts', FlightSearchData::getaircrafts());
		$this->set('airports', FlightSearchData::getdepapts(0));
		$this->show('flightsearch/aircraft.tpl');
	}
	
	public function transferpilot()
	{
		$pilotid = DB::escape($this->post->pilotid);
	    $newlocation = DB::escape($this->post->newlocation);

		$sql = "INSERT INTO flightsearch_pilotlocation (pilotid, location) VALUES ('$pilotid', '$newlocation')";
        DB::query($sql);  


		$this->set('message', "The pilot was successfully transfered!");
		$this->show('core_success.tpl');
		$this->pilotlocations();
	}
	
	
		public function transferaircraft()
	{
		$aircraftid = DB::escape($this->post->aircraftid);
	    $newlocation = DB::escape($this->post->newlocation);

		$sql = "INSERT INTO flightsearch_aircraftlocation (aircraft, location) VALUES ('$aircraftid', '$newlocation')";
        DB::query($sql);  


		$this->set('message', "The aircraft was successfully transfered!");
		$this->show('core_success.tpl');
		$this->aircraftlocations();
	}
}
?>