<?php

/**
 * TicketSystem - Complete Ticket/Support System for phpVMS
 * Copyright (c) 2016 Sava Markovic
 * For more information, visit www.savamarkovic.com
 *
 * @author Sava Markovic
 * @copyright Copyright (c) 2016, Sava Markovic
 * @link http://www.savamarkovic.com
 */

class Ticketsystem extends CodonModule {

	public $title = "Ticket System Administration";

	public static $version = '1.0';

	public function HTMLHead() {
       $this->set('sidebar', 'ticket/sidebar.php');
    }

    public function NavBar () {
        echo '<li><a href="'.SITE_URL.'/admin/index.php/TicketSystem">Ticket System</a></li>';
    }

	public function index() {
		$tickets  = TicketSystemData::getAllTickets();
		$this->set('tickets', $tickets);
		$this->render('ticket/index');
	}

	public function open() {
		$tickets  = TicketSystemData::getAllOpenTickets();
		$this->set('tickets', $tickets);
		$this->render('ticket/index');
	}

	public function assigned() {
		$tickets  = TicketSystemData::getAllOpenTicketsForMember(Auth::$userinfo->pilotid);
		$this->set('tickets', $tickets);
		$this->render('ticket/index');
	}

	public function about() {
		$this->render('ticket/about_popup');
	}

	public function settings() {
		$this->render('ticket/settings_popup');
	}

	public function comment($id) {
		$this->set('id', $id);
		$this->set('comments', TicketSystemData::findCommentsForTicket($id));
		$this->render('ticket/comments_popup');
	}
	public function comment_post() {
		$id = $this->post->id;
		$ticket = TicketSystemData::findTicket($id);
		TicketSystemData::addLogEntry($id, 'COMMENTED_TICKET');
		if(TicketSystemData::checkSpecificSetting('COMMENTED_TICKET', $ticket->creator))
			self::dispatchEmail('COMMENTED_TICKET', $ticket);
		TicketSystemData::addComment($id, $this->post);
		$this->set('message', 'You have successfully added a comment.');
		$this->render('core_success');
		$this->index();
	}

	public function settings_post() {
		if(strlen($this->post->MODULE_LANGUAGE) != 2) {
			$this->set('message', 'Please fill in the settings correctly. Otherwhise, the module can\'t work.');
			$this->render('core_error');
			$this->index();
			return;
		}
		TicketSystemData::applySetting('MODULE_LANGUAGE', $this->post->MODULE_LANGUAGE);
		TicketSystemData::applySetting('SYSTEM_STAFF_GROUP', $this->post->SYSTEM_STAFF_GROUP);
		if($this->post->ALLOW_USER_SETTINGS)
			TicketSystemData::applySetting("ALLOW_USER_SETTINGS", 1);
		else
			TicketSystemData::applySetting("ALLOW_USER_SETTINGS", 0);
		$this->set('message', 'Settings applied! Woooooooho!');
		$this->render('core_success');
		$this->index();
	}

	public function close($id) {
		$ticket = TicketSystemData::findTicket($id);
		if(!$ticket) {
			$this->set('message', 'There is no ticket with this ID.');
			$this->render('core_error');
			return;
		}
		TicketSystemData::close($id);
		TicketSystemData::addLogEntry($id, 'CLOSED_TICKET');
		if(TicketSystemData::checkSpecificSetting('EDITED_TICKET', $ticket->creator))
			self::dispatchEmail('EDITED_TICKET', $ticket);
		$this->set('message', 'You have successfully closed a ticket.');
		$this->render('core_success');
		$this->index();
	}

	public function reopen($id) {
		$ticket = TicketSystemData::findTicket($id);
		if(!$ticket) {
			$this->set('message', 'There is no ticket with this ID.');
			$this->render('core_error');
			return;
		}
		TicketSystemData::reopen($id);
		TicketSystemData::addLogEntry($id, 'REOPENED_TICKET');
		if(TicketSystemData::checkSpecificSetting('EDITED_TICKET', $ticket->creator))
			self::dispatchEmail('EDITED_TICKET', $ticket);
		$this->set('message', 'You have successfully reopened a ticket.');
		$this->render('core_success');
		$this->index();
	}

	public function edit($id) {
		$ticket = TicketSystemData::findTicket($id);
		if(!$ticket) {
			$this->set('message', 'There is no ticket with this ID.');
			$this->render('core_error');
			return;
		}
		$staff = TicketSystemData::findAllStaff(1); // Admin user group == ID 1
		$this->set('staff', $staff);
		$this->set('ticket', $ticket);
		$this->set('title', 'Edit A Ticket');
		$this->render('ticket/edit_popup');
	}

	public function edit_post() {
		if((strlen($this->post->title) < 3) || (strlen($this->post->content) < 3)) {
			$this->set('message', 'You need to supply both the subject and content to edit a ticket.');
			$this->render('core_error');
			$this->set('ticket', TicketSystemData::findTicket($id));
			$this->index();
			return;
		} else {
			TicketSystemData::update($this->post);
			TicketSystemData::addLogEntry($this->post->id, 'EDITED_TICKET');
			$ticket = TicketSystemData::findTicket($id);
			if(TicketSystemData::checkSpecificSetting('EDITED_TICKET', $ticket->creator))
				self::dispatchEmail('EDITED_TICKET', $ticket);
			$this->set('message', 'You have successfully edited a ticket.');
			$this->render('core_success');
			$this->index();
		}
	}

	public function assign($id) {
		$ticket = TicketSystemData::findTicket($id);
		if(!$ticket) {
			$this->set('message', 'There is no ticket with this ID.');
			$this->render('core_error');
			return;
		}
		$staff = TicketSystemData::findAllStaff(1); // Admin user group == ID 1
		$this->set('staff', $staff);
		$this->set('ticket', $ticket);
		$this->set('title', 'Assign A Ticket to Staff Member');
		$this->render('ticket/assign_popup');
	}


	public function assign_post() {
		$ticket = TicketSystemData::findTicket($this->post->id);
		if(!$ticket) {
			$this->set('message', 'There is no ticket with this ID.');
			$this->render('core_error');
			return;
		}
		TicketSystemData::assignTicketToAdmin($this->post->id, $this->post->assigned_to);
		TicketSystemData::addLogEntry($this->post->id, 'ASSIGNED_TICKET', $this->post->assigned_to);
		if(TicketSystemData::checkSpecificSetting('ASSIGNED_TICKET', $ticket->creator)) {
				self::dispatchEmail('ASSIGNED_TICKET', $ticket);
		}
		$this->set('message', 'You have successfully assigned a ticket.');
		$this->render('core_success');
		$this->index();
	}

	public function dispatchEmail($change, $ticket) {
		$string = TicketSystemData::getmsg($change, TicketSystemData::getSetting('MODULE_LANGUAGE'));
		$u = Auth::$userinfo->firstname.' '.Auth::$userinfo->lastname;
		if($change != "ASSIGNED_TICKET") {
			$string = str_replace('%user%', $u, $string);
		}
		else {
			$string = str_replace('%user%', $u, $string);
			$string = str_replace('%assigned%', TicketSystemData::getmsg('A_STAFF_MEMBER', TicketSystemData::getSetting('MODULE_LANGUAGE')), $string);
		}
		$cu = PilotData::getPilotData($ticket->creator);
		$this->set('ticketid', $ticket->id);
		$this->set('changeString', $string);
		$this->set('user', $cu);
		$message = Template::Get('ticket/email', true);
		Util::SendEmail($cu->email, 'Ticket Information at '.SITE_NAME, $message);
	}

}
