<?php
////////////////////////////////////////////////////////////////////////////
//Crazycreatives TourCenter module for phpVMS virtual airline system.     //
//@author Manuel Seiwald                                                  //
//@copyright Copyright (c) 2014, Manuel Seiwald, All Rights Reserved      //
////////////////////////////////////////////////////////////////////////////
class TourCenter extends CodonModule
{

 public function HTMLHead()
    {
        $this->set('sidebar', 'tourcenter/sidebar.php');
    }

    public function NavBar()
    {
        echo '<li><a href="'.SITE_URL.'/admin/index.php/TourCenter">Tour Center</a></li>';
    }

public function index()
{
$this->set('tours', TourCenterData::getalltours());
$this->render('tourcenter/index.tpl');
}

public function newtour()
{
$this->set('airports', TourCenterData::getallairports());
$this->set('aircraft', TourCenterData::getallaircraft());
$this->set('airlines', TourCenterData::getallairlines());
$this->set('action', 'Create');
$this->set('ranks', RanksData::getAllRanks());
$this->set('tours', TourCenterData::getalltours());

$this->render('tourcenter/tourform.tpl');
}

public function newstep1()
{
if(!$this->post->tourtitle)
{
$message = 'No Tour Title was entered!<br />';
}
if(!$this->post->startdate)
{
$message = 'No Start Date was selected!<br />';
}
if(!$this->post->airline)
{
$message = 'No Airline Code was selected!<br />';
}
if(!$this->post->allowedaircraft)
{
$message = 'No Aircraft Types were selected!<br />';
}
if(!$this->post->firstdep)
{
$message = 'No Departure Airport was selected!<br />';
}
if(!$this->post->lastarr)
{
$message = 'No Arrival Airport was selected!<br />';
}
if(!$this->post->legnumber)
{
$message = 'No leg number was entered!<br />';
}

if($message)
{
$this->set('message', $message);
$this->show('core_error.tpl');
$this->newtour();
return;
}

$autoaward = $this->post->autoaward;
$awardimage = $this->post->awardimage;

if($autoaward == '1')
{
if(!$awardimage)
{
$this->set('message', 'No Award Image Added!');
$this->show('core_error.tpl');
return;
}
}

if($this->post->allowedaircraft){
$allowedaircraft = implode(':', $this->post->allowedaircraft);
}
if($this->post->requiredtours){
$requiredtours = implode(':', $this->post->requiredtours);
}

$this->set('action', DB::escape($this->post->action));
$this->set('tourtitle', DB::escape($this->post->tourtitle));
$this->set('tourimage', DB::escape($this->post->tourimage));
$this->set('tourdescription', DB::escape($this->post->tourdescription));
$this->set('startdate', DB::escape($this->post->startdate));
$this->set('enddate', DB::escape($this->post->enddate));
$this->set('airline', DB::escape($this->post->airline));
$this->set('allowedaircraft', $allowedaircraft);
$this->set('firstdep', DB::escape($this->post->firstdep));
$this->set('lastarr', DB::escape($this->post->lastarr));
$this->set('legnumber', DB::escape($this->post->legnumber));
$this->set('minrank', DB::escape($this->post->minrank));
$this->set('maxdays', DB::escape($this->post->maxdays));
$this->set('requiredtours', $requiredtours);
$this->set('maxsignups', DB::escape($this->post->maxsignups));
$this->set('status', DB::escape($this->post->status));
$this->set('airports', TourCenterData::getallairports());
$this->set('depinfo', TourCenterData::getairportinfo($this->post->firstdep));
$this->set('arrinfo', TourCenterData::getairportinfo($this->post->lastarr));
$this->set('autoaward', DB::escape($this->post->autoaward));
$this->set('awardimage', DB::escape($this->post->awardimage));


$this->show('tourcenter/step2form.tpl');

}


public function createtour()

{
$tourtitle = DB::escape($this->post->tourtitle);
$tourimage = DB::escape($this->post->tourimage);
$tourdescription = DB::escape($this->post->tourdescription);
$startdate = DB::escape($this->post->startdate);
$enddate = DB::escape($this->post->enddate);
$airline = DB::escape($this->post->airline);
$allowedaircraft = $this->post->allowedaircraft;
$firstdep = DB::escape($this->post->firstdep);
$lastarr = DB::escape($this->post->lastarr);
$legnumber = DB::escape($this->post->legnumber);
$minrank = DB::escape($this->post->minrank);
$maxdays = DB::escape($this->post->maxdays);
$requiredtours = $this->post->requiredtours;
$maxsignups = $this->post->maxsignups;
$status = $this->post->status;
$depicao = $this->post->depicao;
$deptime = $this->post->deptime;
$arricao = $this->post->arricao;
$arrtime = $this->post->arrtime;
$flighttime = $this->post->flighttime;
$flightlevel = $this->post->flightlevel;
$requiredtours = $this->post->requiredtours;
$distance = $this->post->distance;
$route = $this->post->route;
$legdescription = $this->post->legdescription;
$legid = $this->post->legid;
$price = $this->post->price;
$autoaward = $this->post->autoaward;
$awardimage = $this->post->awardimage;
$awardid = '0';
if($autoaward == '1')
{
if(!$awardimage)
{
$this->set('message', 'No Award Image Added!');
$this->show('core_error.tpl');
return;
}

$awardtitle = $tourtitle;
$awarddescription = "For completing the Tour: ".$tourtitle.".";
$awardid = TourCenterData::createaward($awardimage, $awardtitle, $awarddescription);
}


$tourid = TourCenterData::savetour($tourtitle, $tourimage, $tourdescription, $startdate, $enddate, $airline, $allowedaircraft, $firstdep, $lastarr, $legnumber, $minrank, $maxdays, $requiredtours, $maxsignups, $status, $awardid);

$i = 0; 	while($i < $legnumber) 	{ 


TourCenterData::savelegs($tourid, $legid[$i], $depicao[$i], $arricao[$i], $deptime[$i], $arrtime[$i], $flighttime[$i], $flightlevel[$i], $distance[$i], $route[$i], $legdescription[$i], $price[$i]);

$i++;
}
		$name = 'New Tour "'.$tourtitle.'" was added by '.Auth::$userinfo->firstname.', check it out <a href="'.SITE_URL.'/index.php/tourcenter" class="text-muted">here</a>';
		$posted_by = 'Admin Bot';
		$privacy = '0';
		ICSActs::new_ics_activity($name, $posted_by, $privacy);
$this->set('message', 'Tour Added!');
$this->show('core_success.tpl');
$this->tourdetails($tourid);
}


public function tourdetails($tourid)
{
$this->set('tour', TourCenterData::gettourdetails($tourid));
$this->set('legs', TourCenterData::gettourlegs($tourid));
$this->set('signups', TourCenterData::gettoursignups($tourid));
$this->show('tourcenter/tourdetails.tpl');
}

public function edittour($tourid)
{
$this->set('airports', TourCenterData::getallairports());
$this->set('aircraft', TourCenterData::getallaircraft());
$this->set('airlines', TourCenterData::getallairlines());
$this->set('action', 'Edit');
$this->set('ranks', RanksData::getAllRanks());
$this->set('tours', TourCenterData::getalltours());
$this->set('tour', TourCenterData::gettourdetails($tourid));

$this->render('tourcenter/toureditform.tpl');
}

public function editleg($id)
{
$this->set('leg', TourCenterData::gettourlegbyid($id));
$this->set('airports', TourCenterData::getallairports());
$this->render('tourcenter/editlegform');
}

public function deletetour($id)
{
TourCenterData::deletetour($id);
$this->index();
}

public function saveedittour()
{
if(!$this->post->tourid)
{
$message = "No Tour ID passed!<br />";
}
if(!$this->post->tourtitle)
{
$message = 'No Tour Title was entered!<br />';
}
if(!$this->post->startdate)
{
$message = 'No Start Date was selected!<br />';
}
if(!$this->post->allowedaircraft)
{
$message = 'No Aircraft Types were selected!<br />';
}



if($message)
{
$this->set('message', $message);
$this->show('core_error.tpl');
$this->edittour($this->post->tourid);
return;
}


if($this->post->allowedaircraft){
$allowedaircraft = implode(':', $this->post->allowedaircraft);
}
if($this->post->requiredtours){
$requiredtours = implode(':', $this->post->requiredtours);
}
$tourid = DB::escape($this->post->tourid);
$tourtitle = DB::escape($this->post->tourtitle);
$tourimage = DB::escape($this->post->tourimage);
$tourdescription = DB::escape($this->post->tourdescription);
$startdate = DB::escape($this->post->startdate);
$enddate = DB::escape($this->post->enddate);
$allowedaircraft = $allowedaircraft;
$minrank = DB::escape($this->post->minrank);
$maxdays = DB::escape($this->post->maxdays);
$requiredtours = $requiredtours;
$maxsignups = DB::escape($this->post->maxsignups);
$status = DB::escape($this->post->status);

TourCenterData::saveedittour($tourid, $tourtitle, $tourimage, $tourdescription, $startdate, $enddate, $allowedaircraft, $minrank, $maxdays, $requiredtours, $maxsignups, $status);

$this->set('message', 'Tour Edited!');
$this->show('core_success.tpl');
$this->tourdetails($tourid);
}

public function saveeditleg()
{
if(!$this->post->id)
{
$message = "No Leg ID passed!<br />";
}
if(!$this->post->depicao)
{
$message = 'No Depicao was selected!<br />';
}
if(!$this->post->arricao)
{
$message = 'No Arricao was selected!<br />';
}


if($message)
{
$this->set('message', $message);
$this->show('core_error.tpl');
$this->editleg($this->post->id);
return;
}

$tourid = DB::escape($this->post->tourid);
$depicao = DB::escape($this->post->depicao);
$deptime = DB::escape($this->post->deptime);
$arricao = DB::escape($this->post->arricao);
$arrtime = DB::escape($this->post->arrtime);
$flighttime = DB::escape($this->post->flighttime);
$flightlevel = DB::escape($this->post->flightlevel);
$distance = DB::escape($this->post->distance);
$route = strtoupper(DB::escape($this->post->route));
$legdescription = DB::escape($this->post->legdescription);
$id = DB::escape($this->post->id);
$price = DB::escape($this->post->price);



TourCenterData::saveeditleg($id, $depicao, $arricao, $deptime, $arrtime, $flighttime, $flightlevel, $distance, $route, $legdescription, $price);

$this->set('message', 'Leg Edited!');
$this->show('core_success.tpl');
$this->tourdetails($tourid);
}

public function removepilot($tourid)
{
$pilotid = DB::escape($this->get->pilot);
TourCenterData::removepilot($tourid, $pilotid);

$this->set('message', 'Pilot Removed!');
$this->show('core_success.tpl');
$this->tourdetails($tourid);
}

}
?>