<?php
	//=======================================================================
// Create new webhook in your Discord channel settings and copy&paste URL
//=======================================================================
$webhookurl = DISCORD_WEBHOOK_URL;

if(DISCORD_ENABLE_WEBHOOKS == 0) {
	die("Webhook notifications are currently disabled!");
}
//=======================================================================
// Compose message. You can use Markdown
//=======================================================================
$hookObject = json_encode([
    /*
     * The general "message" shown above your embeds
     */
    // "content" => $_POST['message'],
    /*
     * The username shown in the message
     */
    // "username" => SITE_NAME." Notifications",
    /*
     * The image location for the senders image
     */
    // "avatar_url" => SITE_URL."/iCrew/favicon.png",
    /*
     * Whether or not to read the message in Text-to-speech
     */
    "tts" => false,
    /*
     * File contents to send to upload a file
     */
    // "file" => "",
    /*
     * An array of Embeds
     */
    "embeds" => [
        /*
         * Our first embed
         */
        [
            // Set the title for your embed
            // "title" => "Google.com",

            // The type of your embed, will ALWAYS be "rich"
            "type" => "rich",

            // A description for your embed
            "description" => $_POST['message'],

            // The URL of where your title will be a link to
            "url" => SITE_URL,

            /* A timestamp to be displayed below the embed, IE for when an an article was posted
             * This must be formatted as ISO8601
             */
	            // "timestamp" => "2018-03-10T19:15:45-05:00",

            // The integer color to be used on the left side of the embed
            "color" => hexdec( "fafafa" ),

            // Footer object
            "footer" => [
                "text" => SITE_NAME. " | Powered by iCrew™",
	                "icon_url" => SITE_URL."/iCrew/favicon.png",
            ],

            // Image object
            // "image" => [
            //     "url" => "https://www.google.com/images/branding/googlelogo/1x/googlelogo_color_272x92dp.png"
            // ],
						//
            // // Thumbnail object
            // "thumbnail" => [
            //     "url" => "https://pbs.twimg.com/profile_images/972154872261853184/RnOg6UyU_400x400.jpg"
            // ],
						//
            // // Author object
            "author" => [
                "name" => "iCrew Notification System | PR Department"
            ]
        ]
    ]

], JSON_UNESCAPED_SLASHES | JSON_UNESCAPED_UNICODE );

$ch = curl_init();

curl_setopt_array( $ch, [
    CURLOPT_URL => $webhookurl,
    CURLOPT_POST => true,
    CURLOPT_POSTFIELDS => $hookObject,
    CURLOPT_HTTPHEADER => [
        "Content-Type: application/json"
    ]
]);


$response = curl_exec( $ch );


if (curl_errno($ch)) {
    // this would be your first hint that something went wrong
    die('Couldn\'t send request: ' . curl_error($ch));
} else {
    // check the HTTP status code of the request
    $resultStatus = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    if ($resultStatus == 200 || $resultStatus == 204) {
        // everything went better than expected
        $clr = "success";
        $status = 'Payload delivered successfully to the server! Check notifications, status code : ' . $resultStatus.'';

    } else if ($resultStatus == 404) {
        // everything went better than expected
        $clr = "danger";
        $status = 'Webhook URL is invalid, get a new URL from Discord > Server Settings > Webhooks and configure at local.config.php, status code : ' . $resultStatus.'';

    } else {
        // the request did not complete as expected. common errors are 4xx
        // (not found, bad request, etc.) and 5xx (usually concerning
        // errors/exceptions in the remote script execution)
				$clr = "danger";
        $status = 'Request failed: HTTP status code: ' . $resultStatus.'';
    }
}

curl_close( $ch );

?>

<h3>
	Discord Notification Bot
	<br>
	<span class="text-muted">
		<small>
			developed by icrewsystems | Version 1.05 &copy;  <?php echo date("Y"); ?>
		</small>
	</span>
</h3>

<h2>
	Deliver Notification
</h2>

<p>
	<div class="alert alert-<?php echo $clr; ?>">
		<strong>
			Status
		</strong> : <?php echo $status; ?>
	</div>

	<br>

	<strong>
		Message :
	</strong> <?php echo $msg; ?>

	<?php echo $msg; ?>
</p>

<div class="row">
	<div class="col-md-6">
		<form action="<?php echo SITE_URL; ?>/admin/index.php/Discord" method="POST">
			<input type="submit" name="action" value="Home" class="btn btn-block btn-success" />
		</form>
	</div>
	<div class="col-md-6">
		<form action="<?php echo SITE_URL; ?>/admin/index.php/Discord/single" method="POST">
			<input type="submit" name="action" value="Send Another Notification" class="btn btn-block btn-info" />
		</form>
	</div>
</div>
