<?php 
   Template::Show('ICSNotams/header'); 
   ?>
<div class="row">
   <div class="col-md-12">
      <div class="card">
         <div class="card-body mx-4">
            <?php
               if(!$notams) {
               	echo '<p>No NOTAMs found.</p>';
               	return;
               }
               ?>
            <table class="table" id="notamstable">
               <thead>
                  <tr>
                     <th>Code</th>
                     <th>Series</th>
                     <th>Title</th>
                     <th>Validity</th>
                     <th>Status</th>
                     <th>Authorization</th>
                     <th>Manage</th>
                     <th>Revoke</th>
                     <th>Delete</th>
                  </tr>
               </thead>
               <tbody>
                  <?php
                     foreach($notams as $notam) {
                     	
                     	
                     ?>
                  <tr>
                     <td><code></code><?php echo $notam->code; ?></code></td>
                     <td><?php echo NotamsData::getSeries($notam->series); ?></td>
                     <td><?php echo $notam->title; ?></td>
                     <td><?php echo date(DATE_FORMAT, strtotime($notam->valid_from)); ?> - <?php echo date(DATE_FORMAT, strtotime($notam->valid_till)); ?></td>
                     <td><?php echo NotamsData::getStatus($notam->valid_from, $notam->valid_till); ?></td>
                     <td><?php echo NotamsData::getIssuedStatus($notam->active); ?></td>
                     <td>
                        <a href="<?php echo adminurl('NOTAMS/manage/').$notam->id; ?>" style="text-decoration: none;" class="btn btn-primary btn-sm">Manage</a>
                     </td>
                     <td>
                        <a href="<?php echo adminurl('NOTAMS/revoke/').$notam->id; ?>" style="text-decoration: none;" class="btn btn-warning btn-sm">Revoke</a>
                     </td>
                     <td>
                        <a data-toggle="modal" data-target="#delete<?php echo $notam->id; ?>" class="btn btn-danger btn-sm btn-rounded z-depth-1a" style="text-decoration: none;">
                        Delete
                        </a>
                        <div class="modal fade" id="delete<?php echo $notam->id; ?>" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
                           <div class="modal-dialog" role="document">
                              <div class="modal-content">
                                 <div class="modal-header">
                                    <h4>Are you sure?</h4>
                                 </div>
                                 <div class="modal-body">
                                    This action cannot be undone. Are you sure you've posted adequate NOTAMs to cover the changes that this NOTAM might have brought?
                                 </div>
                                 <div class="modal-footer">
                                    <button type="button" class="btn btn-secondary" data-dismiss="modal">No</button>
                                    <a type="button" href="<?php echo adminurl("NOTAMs/process?action=delete&id=").$notam->id; ?>" class="btn btn-success" style="text-decoration: none;">Yes, Delete NOTAM</a>
                                 </div>
                              </div>
                           </div>
                        </div>
                     </td>
                  </tr>
                  <?php
                     }
                     ?>
               </tbody>
            </table>
         </div>
      </div>
   </div>
</div>
<script>
   $(document).ready(function() {
      $('#notamstable').DataTable({
      });
      
   } );
</script>