<?php 
   Template::show('ICSNotams/header'); 
   ?>
<div class="row">
<div class="col-md-12">
   <div class="alert alert-success">
      <strong>Attention</strong>
      It is required that you fully understand what is a NOTAM and how it works before using this module. Please proceed to 
      this <a href="https://en.wikipedia.org/wiki/NOTAM" target="_blank">link</a> to know more.
   </div>
   <div class="card">
      <div class="card-body mx-4">
         <!--Header-->
         <form class="form" action="<?php echo adminurl('NOTAMs/process'); ?>" method="POST">
            <div class="md-form">
               <input type="text" required name="title" style="text-transform: uppercase" class="form-control" placeholder="Keep it to 10 words max. ONLY UPPER CASE ALLOWED">
               <label for="Form-email1">NOTAM Title</label>
            </div>
             <div class="md-form">
               <input type="text" required name="code" id="code" maxlength="5" class="form-control" placeholder="Random Code">
               <label for="Form-email1">NOTAM Code</label>
               <br>
               <button href="javascript::void(0);" class="btn btn-sm btn-primary" onclick="randomize();">
               	 Generate Random Code
               </button>
               <script>
               	function randomize() {
               		var rnd = (""+Math.random()).substring(2,7);
        			document.getElementById('code').value  = rnd;
               	}
               </script>
            </div>
            
            <div class="md-form">
               <input type="date" required name="valid_from" class="form-control">
               <label for="Form-email1">NOTAM valid from</label>
            </div>
            <div class="md-form">
               <input type="date" required name="valid_till" class="form-control">
               <label for="Form-email1">NOTAM valid till</label>
            </div>
            <div class="md-form">
               <label for="Form-email1">NOTAM Content</label>
               <textarea rows="1" required name="body" class="md-textarea form-control"></textarea>
            </div>
            <label for="Form-email1">NOTAM Series?</label>
            <br>
            <div class="md-form">
               <select name="series" class="browser-default custom-select">
               	<?php	
               		foreach ($allseries as $series) {
               			?>
               			<option value="<?php echo $series->id; ?>"><?php echo $series->name; ?></option>		
               			<?php
               		}
               	?>
               </select>
            </div>
            <label for="Form-email1">NOTAM Status?</label>
            <br>
            <div class="md-form">
               <select name="active" class="browser-default custom-select">
                  <option value="0">Revoked (will not be available)</option>
                  <option value="1" selected>Effective (will be available)</option>
               </select>
            </div>
            <div class="text-center mb-3">
               <input type="hidden" name="action" value="<?php echo $action; ?>" />
               <input type="submit" name="submit" value="<?php echo $action; ?>" class="btn blue-gradient btn-block btn-rounded z-depth-1a" />
            </div>
      </div>
      </form>
   </div>
</div>