<?php 
   Template::show('ICSNotams/header'); 
   ?>
<div class="row">
<div class="col-md-12">
   <div class="card">
      <div class="card-body mx-4">
         <!--Header-->
         <div class="alert alert-warning">
         	<strong>Attention</strong>
         	You are issuing a revoking NOTAM, for NOTAM bearing <strong>ID #<?php echo $notam->id; ?>, Code: <?php echo $notam->code; ?> and Title: <?php echo $notam->title;?></strong>.
         	When you hit process, the system will revoke the above mentioned NOTAM and issue this new NOTAM with a code RE/<?php echo $notam->code; ?>.
         </div>
         <form class="form" action="<?php echo adminurl('NOTAMs/process'); ?>" method="POST">
            <div class="md-form">
               <input type="text" required name="title" value="Revoking NOTAM for <?php echo $notam->title; ?>" style="text-transform: uppercase" class="form-control" placeholder="Keep it to 10 words max. ONLY UPPER CASE ALLOWED">
               <label for="Form-email1">NOTAM Title</label>
            </div>
             <div class="md-form">
               <input type="text" required name="code" id="code" value="RE/<?php echo $notam->code; ?>" maxlength="5" class="form-control disabled" placeholder="Random Code">
               <label for="Form-email1">NOTAM Code <span class="text-danger">(to signify that you're issing a revoking NOTAM for the previous NOTAM bearing the same Code)</span></label>
               <br>
           <!--    <a href="javascript::void(0);" style="text-decoration: none;" class="btn btn-sm btn-primary" onclick="randomize();">-->
           <!--    	 Generate Random Code-->
           <!--    </a>-->
           <!--    <script>-->
           <!--    	function randomize() {-->
           <!--    		var rnd = (""+Math.random()).substring(2,7);-->
        			<!--document.getElementById('code').value  = rnd;-->
           <!--    	}-->
           <!--    </script>-->
            </div>
            
            
            <div class="md-form">
               <input type="date" required name="valid_from" value="<?php echo $notam->valid_from; ?>" class="form-control">
               <label for="Form-email1">NOTAM valid from</label>
            </div>
            <div class="md-form">
               <input type="date" required name="valid_till" value="<?php echo $notam->valid_till; ?>" class="form-control">
               <label for="Form-email1">NOTAM valid till</label>
            </div>
            <div class="md-form">
               <label for="Form-email1">NOTAM Content</label>
               <textarea rows="1" required name="body" class="md-textarea form-control"></textarea>
            </div>
            <label for="Form-email1">NOTAM Series? <span class="text-danger">(You must use the same series as the previous NOTAM)</span></label>
            <br>
            <div class="md-form">
               <select name="series" class="browser-default custom-select">
               	<?php	
               		// foreach ($allseries as $series) {
               		// 	$selected = "";
               		// 	if($series->id == $notam->series) {
               		// 		$selected = "selected";
               		// 	} else {
               		// 		$selected = "";
               		// 	}
               			?>
               			<option value="<?php echo $notam->id; ?>"><?php echo NotamsData::getSeries($notam->series); ?></option>
               			<!--<option value="<?php echo $series->id; ?>" <?php echo $selected; ?>><?php echo $series->name; ?></option>		-->
               			<?php
               		// }
               	?>
               </select>
            </div>
            <label for="Form-email1">NOTAM Status?</label>
            <br>
            <div class="md-form">
               <select name="active" class="browser-default custom-select">
               	<?php 
               			if($notam->active == 1) {
               				$authorized = "selected";
               				$unauthorized = "";
               			} else {
               				$authorized = "";
               				$unauthorized = "selected";
               			}
               	?>
                  <option value="0" <?php echo $unauthorized; ?>>Revoked (will not be available)</option>
                  <option value="1" <?php echo $authorized; ?>>Effective (will be available)</option>
               </select>
            </div>
            <div class="text-center mb-3">
               <input type="hidden" name="action" value="<?php echo $action; ?>" />
               <input type="hidden" name="revoking_id" value="<?php echo $notam->id; ?>" />
               <input type="submit" name="submit" value="Process" class="btn btn-primary btn-rounded z-depth-1a" />
               <a href="<?php echo adminurl("NOTAMs"); ?>" class="btn btn-danger btn-rounded z-depth-1a" style="text-decoration: none;">Back</a>
            </div>
      </div>
      </form>
   </div>
</div>