<?php 
   Template::Show('ICSNotams/header'); 
   ?>
<div class="row">
   <div class="col-md-12">
      <div class="card">
         <div class="card-body mx-4">
            <?php
               if(!$series) {
               	echo '<p>No NOTAM series found.</p>';
               }
               ?>
            <table class="table" id="notamstable">
               <thead>
                  <tr>
                     <th>ID</th>
                     <th>Name</th>
                     <th>Status</th>
                     <th>Manage</th>
                     <th>Delete</th>
                  </tr>
               </thead>
               <tbody>
                  <?php
                     foreach($series as $series) {
                     	
                     	
                     ?>
                  <tr>
                     <td><?php echo $series->id; ?></td>
                     <td><?php echo $series->name; ?></td>
                     <td><?php echo NotamsData::getSeriesStatus($series->active); ?></td>
                     <td>
                        <a data-toggle="modal" data-target="#manage<?php echo $series->id; ?>" class="btn btn-primary btn-sm btn-rounded z-depth-1a" style="text-decoration: none;">
                        Manage
                        </a>
                        <div class="modal fade" id="manage<?php echo $series->id; ?>" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
                           <div class="modal-dialog" role="document">
                              <div class="modal-content">
                                 <div class="modal-header">
                                    <h4>Managing <?php echo $series->name; ?> Series</h4>
                                 </div>
                                 <div class="modal-body">
                                 	
                                 	 <form class="form" action="<?php echo adminurl('NOTAMs/process'); ?>" method="POST">
                           <div class="md-form">
                              <input type="text" required name="name" value="<?php echo $series->name; ?>" class="form-control" placeholder="Fligh Operations, Airspace Restrictions...">
                              <label for="Form-email1">Series Name</label>
                           </div>
                           <div class="md-form">
            				<select name="active" class="browser-default custom-select">
            					<?php 
               			if($series->active == 1) {
               				$authorized = "selected";
               				$unauthorized = "";
               			} else {
               				$authorized = "";
               				$unauthorized = "selected";
               			}
               	?>
                				<option value="0" <?php echo $unauthorized; ?>>Inactive</option>
                				<option value="1" <?php echo $authorized; ?>>Active</option>
            				</select>
            				</div>
                           <div class="text-center mb-3">
                              <input type="hidden" name="action" value="update_series" />
                              <input type="hidden" name="id" value="<?php echo $series->id; ?>" />
                              
                           </div>
                            <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
                     <input type="submit" name="submit" value="Update Series" class="btn blue-gradient btn-block btn-rounded z-depth-1a" />
                     </form>
                                 	
                                 </div>
                              </div>
                           </div>
                        </div>
                     </td>
                     <td>
                        <a data-toggle="modal" data-target="#delete<?php echo $series->id; ?>" class="btn btn-danger btn-sm btn-rounded z-depth-1a" style="text-decoration: none;">
                        Delete
                        </a>
                        <div class="modal fade" id="delete<?php echo $series->id; ?>" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
                           <div class="modal-dialog" role="document">
                              <div class="modal-content">
                                 <div class="modal-header">
                                    <h4>Are you sure?</h4>
                                 </div>
                                 <div class="modal-body">
                                    This action cannot be undone. Are you sure you've posted adequate NOTAMs to cover the changes that this NOTAM might have brought?
                                 </div>
                                 <div class="modal-footer">
                                    <button type="button" class="btn btn-secondary" data-dismiss="modal">No</button>
                                    <a type="button" href="<?php echo adminurl("NOTAMs/process?action=delete_series&id=").$series->id; ?>" class="btn btn-success" style="text-decoration: none;">Yes, Delete NOTAM</a>
                                 </div>
                              </div>
                           </div>
                        </div>
                     </td>
                  </tr>
                  <?php
                     }
                     ?>
               </tbody>
            </table>
            <a data-toggle="modal" data-target="#addNewSeries"style="text-decoration: none;" class="btn btn-block btn-primary" target="_blank">Add New Series</a>
            <div class="modal fade" id="addNewSeries" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
               <div class="modal-dialog" role="document">
                  <div class="modal-content">
                     <div class="modal-header">
                        <h5>Adding new NOTAM Series</h5>
                     </div>
                     <div class="modal-body">
                        <form class="form" action="<?php echo adminurl('NOTAMs/process'); ?>" method="POST">
                           <div class="md-form">
                              <input type="text" required name="name" class="form-control" placeholder="Fligh Operations, Airspace Restrictions...">
                              <label for="Form-email1">Series Name</label>
                           </div>
                           <div class="md-form">
            				<select name="active" class="browser-default custom-select">
                				<option value="0">Inactive</option>
                				<option value="1" selected>Active</option>
            				</select>
            				</div>
                           <div class="text-center mb-3">
                              <input type="hidden" name="action" value="new_series" />
                           </div>
                            <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
                     <input type="submit" name="submit" value="Add" class="btn blue-gradient btn-block btn-rounded z-depth-1a" />
                     </form>
                     </div>
                  </div>
                  <div class="modal-footer">
                    
                  </div>
               </div>
            </div>
         </div>
      </div>
   </div>
</div>
</div>
<script>
   $(document).ready(function() {
      $('#notamstable').DataTable({
      });
      
   } );
</script>