<?php 
   Template::Show('ICSNotams/header'); 
   ?>
  <div class="container my-5 py-5 z-depth-1">
 
    <!--Section: Content-->
    <section class="px-md-5 mx-md-5 dark-grey-text">
			
			<form class="form" method="POST" action="<?php echo adminurl("notams/update_settings"); ?>">
				
				<div class="alert alert-success">
					You are running NOTAMs Module Version <?php echo NotamsData::version(); ?>
				</div>
				<div class="form-group">
						<?php 
							$module_status = NotamsData::getSettingValue('module_status');
							$enabled = '';
							$disabled = '';
							if($module_status == 1) {
								$enabled = "selected";
								$label = "success";
							} else {
								$disabled = "selected";
								$label = "danger";
							}
						?>
					<label>
						Module Status 
					</label>
					<select name="module_status" class="form-control">
					
						<option value="1" <?php echo $enabled; ?>>Enabled</option>
						<option value="0" <?php echo $disabled; ?>>Disabled</option>
					</select>
				</div>
				
				
				
				<div class="form-group">
					
					<input type="submit" value="Save" class="btn btn-info btn-md" />
				</div>
				
				
				
			</form>
			
			<br>
			
			<h2>How to use this module?</h2>
			<p>
				This module was created by icrewsystems for Virtual Airlines inspired by DGCA UAS NOTAM Portal by Govt. Of India. 
				With this module, you can issue, publish and revoke NOTAMs pertaining to different areas of operations for your Virtual Airline. 
				How is this different from the News Module? Well, NOTAMs by nature are related to "Operations" where as News covers bigger ground.
				
				<br><br>
				<strong>Things to keep in mind.</strong>
				<ol>
					<li>The pilot side module will show you the data only if the NOTAM is marked as "effective"</li>
					<li>Effective & Active are two different things. The "Effective/Revoked" status is controlled by you, wheras the 
						"Active/inactive" status is controlled by the system.
					</li>
					<li>
						If the NOTAM is not marked as "revoked" by administrator, and the validity is due, the module will show it as "Inactive", 
						and restrain from showing it to the pilots as it may bring confusion to them.
					</li>
					<li>When you revoke an active NOTAM, you will automatically withdraw the existing NOTAM and create a new NOTAM bearing a same 
					code with the prefix "RE" meaning "Revoked". 
					</li>
				</ol>
				
				
				<br><br>
				For any further doubts and queries, please contact hello@icrewsystems.com or visit <a href="https://icrewsystems.com/en?_ref=NOTAMS_Module_<?php echo SITE_NAME; ?>" target="_blank">
					https://icrewsystems.com/en
				</a>
			</p>
		</section>
	</div>