<?php 
	Template::show('ICSTourAdmin/header');
?>

<div class="row">
   <div class="col-md-12">
      <div class="card">
         <div class="card-body mx-4">
            <table class="table" id="tourstable">
               <thead>
                  <tr>
                     <th>ID</th>
                     <th>Tour Name</th>
                     <th>Total Legs</th>
                     <th>Between</th>
                     <th>Dates</th>
                     <th>Min. Rank</th>
                     <th>Status</th>
                     <th>Sign-ups</th>
                     <th>Manage</th>
                  </tr>
               </thead>
               <tbody>
                  <?php
                     foreach($tours as $tour) {
                     ?>
                  <tr>
                     <td><code></code><?php echo $tour->id; ?></code></td>
                     <td><?php echo $tour->title; ?></td>
                     <td><?php echo $tour->total_legs; ?></td>
                     <td><?php echo ICSTourData::TourisBetween($tour->id, $tour->total_legs); ?></td>
                     <td><?php echo date(DATE_FORMAT, strtotime($tour->startdate)); ?> to <?php echo date(DATE_FORMAT, strtotime($tour->enddate)); ?></td>
                     <td><?php 
                     	if($tour->minrank == 0) {
                     		?>
                     		<span class="badge badge-success">No Restrictions</span>
                     		<?php
                     	} else {
                     		?>
                     			<span class=><?php echo RanksData::getRankInfo($tour->minrank)->rank; ?></span>
                     		<?php
                     	}
                     	?></td>
                     <td><?php echo ICSTourData::getTourStatus($tour->status); ?></td>
                     <td class="text-center"><?php 
                    	$signups = count(ICSTourData::getTourParticipants($tour->id));
                    	if($signups == 0) {
                    		echo "<span class='badge badge-danger'>No participants</span>";
                    	} else {
                    		echo $signups;
                    	}
                     ?></td>
                     <td>
                        <a href="<?php echo adminurl('ICSTourAdmin/manage/').$tour->id; ?>" style="text-decoration: none;" class="btn btn-primary btn-sm">Manage</a>
                     </td>
                  </tr>
                  <?php
                     }
                     ?>
               </tbody>
            </table>
         </div>
      </div>
   </div>
</div>
<script>
   $(document).ready(function() {
      $('#tourstable').DataTable({
      });
      
   } );
</script>