<?php 
   Template::show('ICSTourAdmin/header');
   //CodonEvent::Dispatch('pirep_filed', 'PIREPS');
   ?>
<div class="row">
   <div class="col-md-12">
      <div class="card">
         <div class="card-body mx-4">
         	<h3>Step 1</h3>
            <!--Header-->
            <form class="form" action="<?php echo adminurl('ICSTourAdmin/edit_process'); ?>" method="POST" enctype="multipart/form-data">
               <div class="md-form">
                  <label for="title">Tour Title</label>
                  <input type="text" required name="title" value="<?php echo $tour->title; ?>" class="form-control" placeholder="Title of your tour">
               </div>
               <div class="md-form">
                  <label for="title">Tour Description</label>
                  <textarea class="md-textarea form-control" name="description" placeholder="Describe the tour to your pilots"><?php echo $tour->description; ?></textarea>
               </div>
               <div class="md-form">
                  <!--<label for="title">Tour Total Legs</label>-->
                  <input type="hidden" required name="total_legs" value="<?php echo $tour->total_legs; ?>"  class="form-control" placeholder="Total Legs for your tour">
               </div>
               <center>
         		<span class="text-muted">
         			(Tour Poster) <br>
         		</span>
         		<img class="img-responsive" src="<?php echo $tour->poster; ?>" style="width: 250px; height: auto;" />
         		</center>
         	
               <div class="input-group">
                  <div class="input-group-prepend">
                     <span class="input-group-text" id="inputGroupFileAddon01">Tour Banner</span>
                  </div>
                  <div class="custom-file">
                     <input type="file" name="banner" class="custom-file-input" id="inputGroupFile01" aria-describedby="inputGroupFileAddon01">
                     <label class="custom-file-label" for="inputGroupFile01">Choose file</label>
                  </div>
               </div>
               <div class="md-form">
                  <input type="hidden" name="airline" value="<?php echo $tour->airline; ?>">
               </div>
               <div class="md-form">
                  <span class="input-text">Airframes allowed on this tour
                  <br><small><span class="text-muted">To choose multiple airframes, use <code>CTRL</code> + <code>Left Click</code></span></small>
                  </span>
                  <br><br>
                  <?php 
                  $touraircrafts = explode(",", $tour->airframes);
                  //print_r($touraircrafts);
                  ?>
                  <select name="airframes[]" required class="browser-default custom-select" multiple>
                     <?php 
                     
                    	foreach ($aircrafts as $aircraft) {
                    		$selected = "";
                    		foreach ($touraircrafts as $tac) {
                    			if($aircraft->icao == $tac) {
                    				$selected = "selected";
                    			} 
                        	 }
                        	?>
                     <option value="<?php echo $aircraft->icao; ?>" <?php echo $selected; ?>><?php echo $aircraft->icao.' '.$aircraft->fullname; ?></option>
                     <?php
                        }
                        ?>
                  </select>
               </div>
               <div class="md-form">
                  <span class="input-text">Minimum Rank to fly this tour</span>
                  <select name="minrank" required class="browser-default custom-select">
                     <option value="0" selected>Allow all ranks</option>
                     <?php 
                        foreach ($ranks as $rank) {
                        	if($rank->rankid == $tour->minrank){
                        		$selected = "selected";
                        	} else {
                        		$selected = "";
                        	}
                        	?>
                     <option value="<?php echo $rank->rankid; ?>" <?php echo $selected; ?>><?php echo $rank->rank; ?></option>
                     <?php
                        }
                        ?>
                  </select>
               </div>
                <div class="md-form">
                  <span class="input-text">Tour completion award <?php echo $tour->award_id; ?></span>
                  <select name="award_id" required class="browser-default custom-select">
                     <?php 
                    	if($tour->award_id != null) {
		                    foreach ($awards as $award) {
		                    	if($award->awardid == $tour->award_id) {
		                    		$selected = 'selected';
		                    	} else {
		                    		$selected = '';
		                    	}
		                    	?>
		                			<option value="<?php echo $award->awardid; ?>" <?php echo $selected; ?>><?php echo $award->name; ?></option>
								<?php
		                    }
                    	} else {
                    		?>
                    			<option value="0" selected>No Award Selected</option>
                    		<?php
                    	}
                       ?>
                  </select>
               </div>
               <div class="md-form">
                  <input type="date" required name="startdate" value="<?php echo $tour->startdate; ?>" class="form-control">
                  <label for="Form-email1">Tour Starting on</label>
               </div>
               <div class="md-form">
                  <input type="date" required name="enddate" value="<?php echo $tour->enddate; ?>" class="form-control">
                  <label for="Form-email1">Tour ends on</label>
               </div>
               <label for="Form-email1">Tour Status?</label>
               <br>
               <div class="md-form">
                  <select name="active" class="browser-default custom-select">
                  	<?php 
                  		if($tour->status == 1) {
                  			$active = "selected";
                  			$inactive = "";
                  		} else {
                  			$active = "";
                  			$inactive = "selected";
                  		}
                  	?>
                     <option value="0" <?php echo $inactive; ?>>Inactive (will not be shown to pilots)</option>
                     <option value="1" <?php echo $active; ?>>Active (will be shown to pilots)</option>
                  </select>
               </div>
               <div class="text-center mb-3">
                  <input type="hidden" name="id" value="<?php echo $tour->id; ?>" />
                  <input type="hidden" name="poster" value="<?php echo $tour->poster; ?>" />
                  <input type="hidden" name="action" value="<?php echo $action; ?>" />
                  <input type="submit" name="submit" value="<?php echo $action; ?>" class="btn btn-success btn-md" />
                </form>
                    <a class="btn btn-danger btn-md" style="text-decoration: none;" href="<?php echo adminurl("ICSTourAdmin/manage/").$tour->id; ?>">Go back</a>
                <script>
                    function goBack() {
                    	window.history.back();
                    }
				</script>
               </div>
         </div>
      </div>
   </div>
</div>