<?php 
   Template::show('ICSTourAdmin/header');
   //CodonEvent::Dispatch('pirep_filed', 'PIREPS');
   ?>
<div class="row">
	<div class="col-md-12">
      <div class="card">
         <div class="card-body mx-4">
         	<h1><?php echo $tour->title; ?> <?php echo ICSTourData::getTourStatus($tour->status);?></h1>
         	<center>
         		<span class="text-muted">
         			(Tour Poster) <br>
         		</span>
         		<img class="img-responsive" src="<?php echo $tour->poster;?>" style="width: 250px; height: auto;" />
         	</center>
         	<br>
         	<p>
         		<strong>Description:</strong> <?php echo $tour->description; ?>
         		<br><strong>Total Legs in this tour: </strong><?php echo $tour->total_legs; ?> legs
         		<br><strong>Tour Participants: </strong> <?php $signups = count(ICSTourData::getTourParticipants($tour->id));
                    	if($signups == 0) {
                    		echo "<span class='label label-primary'>No participants, be the first!</span>";
                    	} else {
                    		echo $signups;
                    	}
                    ?>
                <br><strong>Tour completion award:</strong> <?php
                $award = AwardsData::GetAwardDetail($tour->award_id);
                echo $award->name; ?>
                <br>
                <center>
                	<img src="<?php echo $award->image; ?>" style="width: 250px; height: auto;">
                </center>
         	</p>
         </div>
       </div>
       <br><br>
    </div>
</div>

<div class="row">
   <div class="col-md-12">
		<div class="card">
			<div class="card-body mx-4">
         	<h3><?php echo $tour->title; ?> Legs</h3>
            
            <table class="table">
					<thead>
						<tr>
							<th>Leg #</th>
							<th>Leg ID#</th>
							<th>Departure</th>
							<th>Destination</th>
							<th>Distance</th>
						</tr>
					</thead>
					<tbody>
				<?php 
				
				
					$i = 1;
					foreach($legs as $leg) {
						 
						?>
						<tr>
							<td><?php echo $i; ?></td>
							<td>Leg #<?php echo $leg->id; ?></td>
							<td>
								<?php echo $leg->depicao; ?>
							</td>
							<td>
								<?php echo $leg->arricao; ?>
							</td>
							<td>
								<?php 
									echo round(OperationsData::getAirportDistance($leg->depicao, $leg->arricao)); 
								?> NM
							</td>
						</tr>
						<?php
						$i++;
					}
				?>
					</tbody>
				</table>
			<br>
			<a href="<?php echo adminurl("ICSTourAdmin/edit/").$tour->id; ?>" style="text-decoration: none;" class="btn btn-info btn-sm">Edit Tour</a>
			<a href="<?php echo adminurl("ICSTourAdmin/edit_legs/").$tour->id; ?>" style="text-decoration: none;" class="btn btn-success btn-sm">Edit Tour Legs</a>
			<button type="button" class="btn btn-danger btn-sm" data-toggle="modal" data-target="#myModal">Delete</button>

<!-- Modal -->
<div id="myModal" class="modal fade" role="dialog">
  <div class="modal-dialog">

    <!-- Modal content-->
    <div class="modal-content">
      <div class="modal-header">
        <h4 class="modal-title">Tour Manager</h4>
      </div>
      <div class="modal-body">
        <p>Are you sure you wish to delete <?php echo $tour->title; ?> ? This cannot be undone.</p>
      </div>
      <div class="modal-footer">
      	<a href="<?php echo adminurl('ICSTourAdmin/deleteTour?id=').$tour->id; ?>" class="btn btn-success btn-sm" style="text-decoration: none;">Yes, Delete tour</a>
        <button type="button" class="btn btn-default btn-sm" data-dismiss="modal">Close</button>
      </div>
    </div>

  </div>
</div>
			</div>
		</div>
   </div>
   <div class="col-md-12">
   	<br><br>
   </div>
   <div class="col-md-12">
      <div class="card">
         <div class="card-body mx-4">
            <h3>Tour <strong>Participants</strong></h3>
         
         <?php 
            if(count($tourParticipants) == 0) {
            	?>
         <div class="alert alert-success">
            <h3>Are you ready to lead the way, <?php echo Auth::$userinfo->firstname; ?>?</h3>
            <p>There are no participants for this tour yet, be the first to fly this tour</p>
         </div>
         <?php
            } else {
            	?>
         <table class="table">
            <thead>
               <th>Pilot</th>
               <th>Current Leg</th>
               <th>Current Location</th>
               <th>Status</th>
               <th>Started On</th>
               <th>Ended On</th>
               <th>Delete Pilot</th>
            </thead>
            <tbody>
               <?php
                  foreach ($tourParticipants as $tp) {
                  	
                  	
                  	$current = $tp->current_leg;
                  	$total = $tour->total_legs;
                  	
                  	if($current > $total) {
                  		//Display as Final Tour leg.
                  		$current = $total;
                  		$sql = "UPDATE `icrewsystems_tour_participation` SET `status` = '2' WHERE `id` = '$tp->id'";
						$ret = DB::query($sql);
                  		//Update to final tour leg. 
                  	}
                  	
                  	?>
               <tr>
                  <td><?php $pilot = PilotData::getPilotData($tp->pilotid); echo PilotData::getPilotCode($pilot->code, $pilot->pilotid).' '.$pilot->firstname.' '.$pilot->lastname; ?></td>
                  <td><?php echo $tp->current_leg; ?> / <?php echo $tour->total_legs; ?></td>
                  <td><?php echo $tp->current_location; ?></td>
                  <td><?php echo ICSTourData::getTourProgress_status($tp->status); ?></td>
                  <td><?php echo date(DATE_FORMAT, strtotime($tp->started_on)); ?></td>
                  <td><?php 
                     if($tp->ended_on != null) {
                     	echo date(DATE_FORMAT, strtotime($tp->ended_on));
                     } else {
                     	echo "<span class='badge badge-danger'>Not completed tour</span>";
                     }
                     
                     ?></td>
                   <td>
                   		<button type="button" class="btn btn-danger btn-sm" data-toggle="modal" data-target="#myModals">Delete</button>
                   </td>
               </tr>
               <?php
                  }
                  ?>
            </tbody>
         </table>
         <?php } ?>
         <!-- Modal -->
<div id="myModals" class="modal fade" role="dialog">
  <div class="modal-dialog">

    <!-- Modal content-->
    <div class="modal-content">
      <div class="modal-header">
        <h4 class="modal-title">Tour Pilot Manager</h4>
      </div>
      <div class="modal-body">
        <p>Are you sure you wish to delete <?php $pilot = PilotData::getPilotData($tp->pilotid); echo PilotData::getPilotCode($pilot->code, $pilot->pilotid).' '.$pilot->firstname.' '.$pilot->lastname; ?> ? This cannot be undone.</p>
      </div>
      <div class="modal-footer">
      	<a href="<?php echo SITE_URL ?>/admin/index.php/ICSTourAdmin/deletePilot/<?php echo $tour->id; ?>/<?php echo $pilot->pilotid; ?>" class="btn btn-success btn-sm" style="text-decoration: none;">Yes, Delete Pilot</a>
        <button type="button" class="btn btn-default btn-sm" data-dismiss="modal">Close</button>
      </div>
    </div>

  </div>
</div>
         
         
      </div>
   </div>
   </div>
</div>