<?php
///////////////////////////////////////////////
///  PilotAwardsSystem v2.0 by php-mods.eu  ///
///            Author php-mods.eu           ///
///            Packed at 8/12/2019          ///
///     Copyright (c) 2019, php-mods.eu     ///
///////////////////////////////////////////////

?>
<h3>Auto Awards Settings</h3>
<p align="center">This part of Pilot Award Syetm has to do with the auto award assign build in system. Via this page,
    you can create, edit or remove the auto award actions. If you select the auto update function, you have to be able
    to create cron jobs. </p>
<p align="center">If you want to set up a cron job in order to auto award your pilots based on the following settings,
    you will have to use this command:<br/>
    <b>php -f <?php echo SITE_ROOT ?>auto_awards_cron.php</b><br/><br/>
    <font color="green"><b>Please note that only the settings, whose auto update has been set to active, will run. You
            can alternatively run each one setting via pressing the Run button.</b></font></p>
<h3>Auto Awards Set Up</h3>
<table id="tabledlist" class="tablesorter">
    <thead>
        <tr>
            <th align="center" width="15%">Type Of Achievement</th>
            <th align="center" width="20%">Achivement</th>
            <th align="center" width="10%">Award to Issue</th>
            <th align="center" width="20%">Comment to User</th>
            <th align="center" width="10%">Auto Update</th>
            <th align="center" width="10%">Function</th>
            <th align="center" width="10%"></th>
        </tr>
    </thead>
    <tbody>
        <?php $i = 0;
        if($autoawards) {
            foreach($autoawards as $auto) {
                if($auto->type == 23 && $settings[5]->setting_value == 0) continue;
                if($auto->type == 24 && $settings[6]->setting_value == 0) continue;
                if(($auto->type == 25 || $auto->type == 26) && $settings[7]->setting_value == 0) continue;
                $i++; ?>
                <tr>
                    <td align="center"><?php echo $autoAwardTypes[$auto->type]; ?></td>
                    <td align="center"><?php if($auto->type == 1) { ?>
                            <?php echo $auto->achieve; ?> Hours
                        <?php } elseif($auto->type == 2) { ?>
                            <?php echo $auto->achieve; ?> Flights
                        <?php } elseif($auto->type == 3) {
                            $achieve = explode('|', $auto->achieve); ?>
                            Minimum Landing: <?php echo $achieve[0]; ?><br />
                            Maximum Landing: <?php echo $achieve[1]; ?><br />
                        <?php } elseif($auto->type == 4) {
                            $achieve = explode('|',$auto->achieve); ?>
                            Days Of Membership: <?php echo $achieve[0]; ?><br />
                            <?php if($achieve[1] == 1) echo '<font color="green"><b>Weekdays Only</b></font>'; else echo '<font color="red"><b>Including Weekends</b></font>'; ?>
                        <?php } elseif($auto->type == 5
                                || $auto->type == 22) { ?>
                            <?php echo $auto->achieve; ?> nm
                        <?php } elseif($auto->type == 6) {
                            $achieve = explode('|',$auto->achieve);
                            $airline = OperationsData::getAirlineByCode($achieve[1]); ?>
                            Hours: <?php echo $achieve[0]; ?><br />
                            Airline: <?php echo $airline->code.' - '.$airline->name; ?>
                        <?php } elseif($auto->type == 7) {
                            $achieve = explode('|',$auto->achieve); ?>
                            Hours: <?php echo $achieve[0]; ?><br />
                            Aircraft ICAO: <?php echo $achieve[1]; ?>
                        <?php } elseif($auto->type == 8) {
                            $achieve = explode('|',$auto->achieve);
                            $airline = OperationsData::getAirlineByCode($achieve[1]); ?>
                            Flights: <?php echo $achieve[0]; ?><br />
                            Airline: <?php echo $airline->code.' - '.$airline->name; ?>
                        <?php } elseif($auto->type == 9) {
                            $achieve = explode('|',$auto->achieve); ?>
                            Flights: <?php echo $achieve[0]; ?><br />
                            Aircraft ICAO: <?php echo $achieve[1]; ?>
                        <?php } elseif($auto->type == 10) {
                            $achieve = explode('|',$auto->achieve);
                            $airline = OperationsData::getAirlineByCode($achieve[1]); ?>
                            Distance: <?php echo $achieve[0]; ?> nm<br />
                            Airline: <?php echo $airline->code.' - '.$airline->name; ?>
                        <?php } elseif($auto->type == 11) {
                            $achieve = explode('|',$auto->achieve); ?>
                            Distance: <?php echo $achieve[0]; ?> nm<br />
                            Aircraft ICAO: <?php echo $achieve[1]; ?>
                        <?php } elseif($auto->type == 12) {
                            $achieve = explode('|',$auto->achieve); ?>
                            Mininum Landing: <?php echo $achieve[0]; ?><br />
                            Maximum Landing: <?php echo $achieve[1]; ?><br />
                            Aircraft ICAO: <?php echo $achieve[2]; ?>
                        <?php } elseif($auto->type == 13) {
                            $achieve = explode('|',$auto->achieve); ?>
                            Flights: <?php echo $achieve[0]; ?><br />
                            Airport: <?php echo $achieve[1]; ?>
                        <?php } elseif($auto->type == 14) {
                            $achieve = explode('|',$auto->achieve); ?>
                            Flights: <?php echo $achieve[0]; ?><br />
                            Airport: <?php echo $achieve[1]; ?>
                        <?php } elseif($auto->type == 15) {
                            $achieve = explode('|',$auto->achieve); ?>
                            Hours: <?php echo $achieve[0]; ?><br />
                            Airport: <?php echo $achieve[1]; ?>
                        <?php } elseif($auto->type == 16) {
                            $achieve = explode('|',$auto->achieve); ?>
                            Hours: <?php echo $achieve[0]; ?><br />
                            Airport: <?php echo $achieve[1]; ?>
                        <?php } elseif($auto->type == 17) {
                            $achieve = explode('|',$auto->achieve); ?>
                            Times Flown: <?php echo $achieve[0]; ?><br />
                            Schedule: <?php echo $achieve[1].$achieve[2]; ?>
                        <?php } elseif($auto->type == 18) {
                            $achieve = explode('|',$auto->achieve); ?>
                            Times Flown: <?php echo $achieve[0]; ?><br />
                            ACARS: <?php echo $achieve[1]; ?>
                        <?php } elseif($auto->type == 19) {
                            echo FinanceData::formatMoney($auto->achieve); ?>
                        <?php } elseif($auto->type == 20) {
                            echo $auto->achieve; ?> <?php echo Config::Get('LIQUID_UNIT_NAMES', Config::Get('LiquidUnit'))?>
                        <?php } elseif($auto->type == 25) {
                            $tour_setting = AwardData::getSetting(7);
                            if($tour_setting->setting_value == 1) {
                                $tour = AwardData::getSimpilotTourData($auto->achieve);
                                echo $tour->title;
                            } else {
                                $tour = AwardData::getCCTourData($auto->achieve);
                                echo $tour->tourtitle;
                            } ?>
                        <?php } else {
                            echo $auto->achieve; ?>
                        <?php } ?></td>
                    <td align="center"><img src="<?php echo $auto->image; ?>" style="max-height: 100px;" alt="<?php echo $auto->name; ?>"/></td>
                    <td align="center"><?php echo $auto->comment; ?></td>
                    <td align="center"><?php if ($auto->auto) {
                            echo '<b><font color="green">Active</font></b>';
                        } else {
                            echo '<b><font color="red">Inactive</font></b>';
                        } ?></td>
                    <td align="center"><a
                                href="<?php echo SITE_URL ?>/admin/index.php/awards/run_setting/<?php echo $auto->id; ?>"
                                class="button">Run</a></td>
                    <td align="center"><a
                                href="<?php echo SITE_URL; ?>/admin/index.php/awards/auto_award_edit/<?php echo $auto->id; ?>"
                                class="button">Edit</a> <a
                                href="<?php echo SITE_URL; ?>/admin/index.php/awards/delete_autoaward/<?php echo $auto->id; ?>"
                                class="button" onclick="return confirm('Are you sure you want to remove this setting?');">Remove</a>
                    </td>
                </tr>
    <?php }
        }
        if($i == 0) {echo '<tr><td align="center" colspan="7">There are not any auto awards set up.</td></tr>';}?>
    </tbody>
</table>
<h3>Add an Auto Award Setting</h3>
<form id="form" action="<?php echo adminaction('awards/autoaward_add'); ?>" method="post">
    <table width="100%" border="0">
        <tr>
            <td width="60%">
                <table width="100%" border="0" id="mainTable">
                    <tr>
                        <td width="30%"><b>Type:</b></td>
                        <td width="70%"><select name="type" id="selectSetting">
                                <option value="0">
                                <?php foreach($autoAwardTypes as $type => $value) {
                                    if($type == 23 && $settings[5]->setting_value == 0) continue;
                                    if($type == 24 && $settings[6]->setting_value == 0) continue;
                                    if($type == 25 && $settings[7]->setting_value == 0) continue;
                                    if($type == 26 && $settings[7]->setting_value == 0) continue; ?>
                                    <option value="<?php echo $type; ?>"><?php echo $value; ?></option>
                                <?php } ?>
                            </select>
                        </td>
                    </tr>
                    <tr class="1 achievement" style="display: none">
                        <td><b>Achievement:</b><br/><i>Select the amount of hours required to issue this award.</i></td>
                        <td><input type="text" name="achieve_1" /></td>
                    </tr>
                    <tr class="2 achievement" style="display: none">
                        <td><b>Achievement:</b><br/><i>Select the amount of flights required to issue this award.</i></td>
                        <td><input type="text" name="achieve_2" /></td>
                    </tr>
                    <tr class="3 achievement" style="display: none">
                        <td><b>Achievement:</b><br/><i>Select the minimum and maximum landing required to issue this award. Values
                                should be set including minus.</i></td>
                        <td>Min: <input type="text" name="achieve_3" style="width: 10%;"/> |
                            Max: <input type="text" name="achieve_3a" style="width: 10%;"/>
                        </td>
                    </tr>
                    <tr class="4 achievement" style="display: none">
                        <td><b>Achievement:</b><br/><i>Select the amount of days of membership required to issue this award.</i>
                        </td>
                        <td><input type="text" name="achieve_4" /> <input type="checkbox" name="achieve_4a" value="1"/> Weekdays Only
                        </td>
                    </tr>
                    <tr class="5 achievement" style="display: none">
                        <td><b>Achievement:</b><br/><i>Select the total distance flown required to issue this award.</i></td>
                        <td><input type="text" name="achieve_5" /> nm
                        </td>
                    </tr>
                    <tr class="6 achievement" style="display: none">
                        <td><b>Achievement:</b><br/><i>Select the total hours by airline flown required to issue this award.</i></td>
                        <td><input type="text" name="achieve_6" /><br />
                            Airline: <select name="achieve_6a">
                                        <?php if($airlines) {
                                            foreach($airlines as $airline) { ?>
                                                <option value="<?php echo $airline->code; ?>"><?php echo $airline->code.' - '.$airline->name; ?></option>
                                        <?php }
                                        } ?>
                                    </select>
                        </td>
                    </tr>
                    <tr class="7 achievement" style="display: none">
                        <td><b>Achievement:</b><br/><i>Select the total hours by aircraft type flown required to issue this award.</i></td>
                        <td><input type="text" name="achieve_7" /><br />
                            Aircraft Type: <select name="achieve_7a">
                                <?php if($aircraft) {
                                    foreach($aircraft as $airc) { ?>
                                        <option value="<?php echo $airc->icao; ?>"><?php echo $airc->icao; ?></option>
                                    <?php }
                                } ?>
                                </select>
                        </td>
                    </tr>
                    <tr class="8 achievement" style="display: none">
                        <td><b>Achievement:</b><br/><i>Select the total flights by airline flown required to issue this award.</i></td>
                        <td><input type="text" name="achieve_8" /><br />
                            Airline: <select name="achieve_8a">
                                <?php if($airlines) {
                                    foreach($airlines as $airline) { ?>
                                        <option value="<?php echo $airline->code; ?>"><?php echo $airline->code.' - '.$airline->name; ?></option>
                                    <?php }
                                } ?>
                                </select>
                        </td>
                    </tr>
                    <tr class="9 achievement" style="display: none">
                        <td><b>Achievement:</b><br/><i>Select the total flights by aircraft type flown required to issue this award.</i></td>
                        <td><input type="text" name="achieve_9" /><br />
                            Aircraft Type: <select name="achieve_9a">
                                <?php if($aircraft) {
                                    foreach($aircraft as $airc) { ?>
                                        <option value="<?php echo $airc->icao; ?>"><?php echo $airc->icao; ?></option>
                                    <?php }
                                } ?>
                                </select>
                        </td>
                    </tr>
                    <tr class="10 achievement" style="display: none">
                        <td><b>Achievement:</b><br/><i>Select the total distance by airline flown required to issue this award.</i></td>
                        <td><input type="text" name="achieve_10" /> nm<br />
                            Airline: <select name="achieve_10a">
                                <?php if($airlines) {
                                    foreach($airlines as $airline) { ?>
                                        <option value="<?php echo $airline->code; ?>"><?php echo $airline->code.' - '.$airline->name; ?></option>
                                    <?php }
                                } ?>
                                </select>
                        </td>
                    </tr>
                    <tr class="11 achievement" style="display: none">
                        <td><b>Achievement:</b><br/><i>Select the total distance by aircraft type flown required to issue this award.</i></td>
                        <td><input type="text" name="achieve_11" /> nm<br />
                            Aircraft Type: <select name="achieve_11a">
                                <?php if($aircraft) {
                                    foreach($aircraft as $airc) { ?>
                                        <option value="<?php echo $airc->icao; ?>"><?php echo $airc->icao; ?></option>
                                    <?php }
                                } ?>
                                </select>
                        </td>
                    </tr>
                    <tr class="12 achievement" style="display: none">
                        <td><b>Achievement:</b><br/><i>Select the minimum and maximum landing rate (by aircraft type) required to issue this award. Values
                                should be set including minus.</i></td>
                        <td>Min: <input type="text" name="achieve_12" style="width: 10%;"/> |
                            Max: <input type="text" name="achieve_12a" style="width: 10%;"/><br />
                            Aircraft Type: <select name="achieve_12b">
                                <?php if($aircraft) {
                                    foreach($aircraft as $airc) { ?>
                                        <option value="<?php echo $airc->icao; ?>"><?php echo $airc->icao; ?></option>
                                    <?php }
                                } ?>
                                </select>
                        </td>
                    </tr>
                    <tr class="13 achievement" style="display: none">
                        <td><b>Achievement:</b><br/><i>Select the flights (by airport departed) required to issue this award.</i></td>
                        <td><input type="text" name="achieve_13" /><br />
                            Airport ICAO: <input type="text" name="achieve_13a" placeholder="Enter Airport ICAO" />
                        </td>
                    </tr>
                    <tr class="14 achievement" style="display: none">
                        <td><b>Achievement:</b><br/><i>Select the flights (by airport arrived) required to issue this award.</i></td>
                        <td><input type="text" name="achieve_14" /><br />
                            Airport ICAO: <input type="text" name="achieve_14a" placeholder="Enter Airport ICAO" />
                        </td>
                    </tr>
                    <tr class="15 achievement" style="display: none">
                        <td><b>Achievement:</b><br/><i>Select the hours (by airport departed) required to issue this award.</i></td>
                        <td><input type="text" name="achieve_15" /><br />
                            Airport ICAO: <input type="text" name="achieve_15a" placeholder="Enter Airport ICAO" />
                        </td>
                    </tr>
                    <tr class="16 achievement" style="display: none">
                        <td><b>Achievement:</b><br/><i>Select the hours (by airport arrived) required to issue this award.</i></td>
                        <td><input type="text" name="achieve_16" /><br />
                            Airport ICAO: <input type="text" name="achieve_16a" placeholder="Enter Airport ICAO" />
                        </td>
                    </tr>
                    <tr class="17 achievement" style="display: none">
                        <td><b>Achievement:</b><br/><i>Select the times flown a schedule required to issue this award.</i></td>
                        <td><input type="text" name="achieve_17" /><br />
                            Schedule: <input type="text" name="achieve_17a" placeholder="CODE" style="width: 15%" /> <input type="text" name="achieve_17b" placeholder="FLIGHT NUMBER" style="width:15%" />
                        </td>
                    </tr>
                    <tr class="18 achievement" style="display: none">
                        <td><b>Achievement:</b><br/><i>Select the times flown (by acars) required to issue this award.</i></td>
                        <td><input type="text" name="achieve_18" /><br />
                            ACARS: <select name="achieve_18a">
                                <?php if($acars) {
                                    foreach($acars as $acars) { ?>
                                        <option value="<?php echo $acars->source; ?>"><?php echo $acars->source; ?></option>
                                    <?php }
                                } ?>
                            </select>
                        </td>
                    </tr>
                    <tr class="19 achievement" style="display: none">
                        <td><b>Achievement:</b><br/><i>Select the total money required to issue this award.</i></td>
                        <td><input type="text" name="achieve_19" /> <?php echo Config::Get('MONEY_UNIT'); ?></td>
                    </tr>
                    <tr class="20 achievement" style="display: none">
                        <td><b>Achievement:</b><br/><i>Select the total fuel burned required to issue this award.</i></td>
                        <td><input type="text" name="achieve_20" /> <?php echo Config::Get('LIQUID_UNIT_NAMES', Config::Get('LiquidUnit'))?></td>
                    </tr>
                    <tr class="21 achievement" style="display: none">
                        <td><b>Achievement:</b><br/><i>Select the flight long (by hours) required to issue this award.</i></td>
                        <td><input type="text" name="achieve_21" /></td>
                    </tr>
                    <tr class="22 achievement" style="display: none">
                        <td><b>Achievement:</b><br/><i>Select the flight long (by distance) required to issue this award.</i></td>
                        <td><input type="text" name="achieve_22" /> nm</td>
                    </tr>
                    <?php if($settings[5]->setting_value != 0) { ?>
                        <tr class="23 achievement" style="display: none">
                            <td><b>Achievement:</b><br/><i>Select the forum posts required to issue this award.</i></td>
                            <td><input type="text" name="achieve_23" /></td>
                        </tr>
                    <?php } ?>
                    <?php if($settings[6]->setting_value != 0) { ?>
                        <tr class="24 achievement" style="display: none">
                            <td><b>Achievement:</b><br/><i>Select the total screenshots submitted required to issue this award.</i></td>
                            <td><input type="text" name="achieve_24" />
                            </td>
                        </tr>
                    <?php } ?>
                    <?php if($settings[7]->setting_value != 0) { ?>
                        <tr class="25 achievement" style="display: none">
                            <td><b>Achievement:</b><br/><i>Select the completed tour to issue this award.</i></td>
                            <td><?php if($settings[7]->setting_value == 1) {
                                    $tours =  AwardData::getSimpilotTours();
                                } else {
                                    $tours = AwardData::getCCTours();
                                } ?>
                                <select name="achieve_25">
                                    <?php if($tours) {
                                    foreach($tours as $tour) { ?>
                                        <option value="<?php echo $tour->id; ?>"><?php echo $tour->title; ?></option>
                                    <?php } } ?>
                                </select>
                            </td>
                        </tr>
                        <tr class="26 achievement" style="display: none">
                            <td><b>Achievement:</b><br/><i>Select the total tours completed required to issued this award</i></td>
                            <td><input type="text" name="achieve_26" /></td>
                        </tr>
                    <?php } ?>

                    <tr>
                        <td><b>Award to Issue:</b></td>
                        <td><select name="awardid">
                                <?php foreach ($awards as $award) { ?>
                                    <option value="<?php echo $award->awardid; ?>"><?php echo $award->name; ?></option>
                                <?php } ?>
                            </select></td>
                    </tr>
                    <tr>
                        <td><b>Comment:</b></td>
                        <td><textarea cols="50" id="comment" name="comment" rows="5"></textarea></td>
                    </tr>
                    <tr>
                        <td><b>Auto Update:</b></td>
                        <td><input type="checkbox" name="auto" value="1"></td>
                    </tr>
                    <tr>
                        <td align="center"><input type="hidden" name="id" value="<?php echo $set->id; ?>"/><br/><input type="submit"
                                                                                                                       name="submit"
                                                                                                                       value="Add Setting"/>
                        </td>
                    </tr>
                </table>
            </td>
            <td width="40%" style="vertical-align: top;">
                <h3>Comment Variables</h3>
                <ul>
                    <li><b>{PILOT_FNAME}</b> - Pilot's first name</li>
                    <li><b>{PILOT_LNAME}</b> - Pilot's last name</li>
                    <li><b>{PILOT_ID}</b> - Insert the pilot's pilot id (VMA001)</li>
                    <li><b>{ACHIEVEMENT_1}</b> - Pilot's achievement <br />(ex Total Flights, Total Distance, Total Hours, Min Landing etc)</li>
                    <li><b>{ACHIEVEMENT_2}</b> - Pilot's achievement 2<br /> (ex Airline, Aircraft, ACARS System, Max Landing, Schedule Code)</li>
                    <li><b>{ACHIEVEMENT_3}</b> - Pilot's achievement 3<br /> (ex Max Landing, Schedule Flight Number, Aircraft for Landing Limits)</li>
                </ul>
            </td>
        </tr>
    </table>
</form><br/>
<script>
    $('#selectSetting').change(function () {
        $('#mainTable .achievement').hide();
        $('#mainTable .' + $(this).val()).fadeIn(1000);
    })
</script>