<?php
///////////////////////////////////////////////
///  PilotAwardsSystem v2.0 by php-mods.eu  ///
///            Author php-mods.eu           ///
///            Packed at 8/12/2019          ///
///     Copyright (c) 2019, php-mods.eu     ///
///////////////////////////////////////////////

?>
<?php
$details = unserialize($data->data);
if($details['run_by'] != 0) $run_by = AwardData::pilot_info($details['run_by']);
?>
<h3>Auto Award Report Details (ID: #<?php echo $data->id; ?>)</h3>
<table id="tabledlist" class="tablesorter">
    <tr>
        <td width="15%"><b>Type:</b></td>
        <td width="85%"><?php echo $details['type']; ?></td>
    </tr>
    <tr>
        <td><b>Run By:</b></td>
        <td><?php if($details['run_by'] != 0) {echo PilotData::getPilotCode($run_by->code, $run_by->pilotid).' - '.$run_by->firstname.' '.$run_by->lastname;} else {echo 'SYSTEM';} ?></td>
    </tr>
    <tr>
        <td><b>Date:</b></td>
        <td><?php echo $data->datetime_run; ?></td>
    </tr>
    <tr>
        <td><b>Total Awards Issued:</b></td>
        <td><?php echo $details['total_awards_issued']; ?></td>
    </tr>
</table>
<h3>Award Issues</h3>
<?php
$issues = unserialize($data->report);
?>
<?php if($issues) { ?>
    <p align="center"><a href="<?php echo SITE_URL; ?>/admin/index.php/Awards/report_remove_all_awards/<?php echo $data->id; ?>"
                         class="button"
                         onclick="return confirm('Are you sure you want to delete all the awardings of this report?">
            Remove ALL Awards</a></p>
<?php } ?>
<table id="tabledlist" class="tablesorter">
    <thead>
        <tr>
            <th width="5%">N/I</th>
            <th width="30%">Pilot</th>
            <th width="20%" align="center">Setting</th>
            <th width="15%" align="center">Setting Achievement</th>
            <th width="15%" align="center">Pilot Achievement</th>
            <th width="15%"></th>
        </tr>
    </thead>
    <tbody>
        <?php if(!$issues) {echo '<tr><td align="center" colspan="6">There are not any award issues.</td></tr>';} else {
            $i = 0;
            foreach($issues as $issue) {
                $pilot = AwardData::pilot_info($issue['pilot']);
                $setting = AwardData::setting_info($issue['setting']);
                $i++; ?>
                <tr>
                    <td><?php echo $i; ?></td>
                    <td><?php echo PilotData::getPilotCode($pilot->code, $pilot->pilotid).' - '.$pilot->firstname.' '.$pilot->lastname; ?></td>
                    <td align="center"><?php echo $autoAwardsTypes[$setting->type] ?></td>
                    <td align="center"><?php echo $issue['achievement']; ?></td>
                    <td align="center"><?php echo $issue['pilot_achievement']; ?></td>
                    <td><?php $check = AwardData::pilotAwardIssued($setting->awardid, $pilot->pilotid);
                    if($check) { ?>
                        <a href="<?php echo SITE_URL; ?>/admin/index.php/Awards/report_remove_award/<?php echo $data->id; ?>/<?php echo $check->id; ?>" class="button">Remove Award</a>
                    <?php } else {
                        echo '<i>N/A</i>';
                    } ?></td>
                </tr>
    <?php } } ?>
    </tbody>
</table>
