<?php

	/*
		HOTFIX: March 2022 - "Mobile screen"
		
		Due to failing WX APIs, many services within iCrew had failed. To rectify, 
		the iCrew team has published this hotfix. Please place this in order to fix 
		the "screen size" issues.
		
		FILE LOCATION: icrew/core/common/AirportData.class.php 
		
	*/

	/**
	* iCrew v4 Premium - Virtual Airline Crew Center
	* Copyright (c) 2017 iCrewSystems
	*
	* This CrewCenter & and it's Modules (which are distinguished, and limited to unless specified)
	* are protected by copyright under Indian Copyright Act, 1957, with the 2012 amendments
	* No part of the website design or layout may be reproduced or transmitted in any form or by any other
	* means electronic or mechanical to include photocopying, recording, reproducing, or electronic storage.
	* Any such act represents a copyright violation and theft of intellectual property owned by iCrewSystems.
	*
	* @copyright: Copyright (c) 2017, iCrewSystems
	* @link http://www.icrewsystems.com
	* @service name: iCrewSystems Virtual Airline Premium Services (with additions)
	* Caution : NO SUPPORT WILL BE PROVIDED IF ANY MODULE / TEMPLATE IS FOUND TO BE TAMPERED WITH.
	*
	*/

class AirportData extends CodonData {
	
   public static function  getdeptflights($icao)  {
        $sql = 'SELECT pirepid FROM '.TABLE_PREFIX.'pireps
                                WHERE depicao="'.$icao.'"';
        $result = DB::get_results($sql);        
        return count($result);
    }
    public static  function  getarrflights($icao)  {
        $sql = 'SELECT pirepid FROM '.TABLE_PREFIX.'pireps
                                WHERE arricao="'.$icao.'"';
        $result = DB::get_results($sql);        
        return count($result);
    }
	  public static function getrunwaysforairport($icao)
	{
		$sql = "SELECT * FROM runways WHERE icao = '$icao'";
		return DB::get_results($sql);
	}
	
	public static function getAirportCountry($home_country) {
		$sql = "SELECT * FROM `phpvms_airports` WHERE `country` LIKE '$home_country'";
		return DB::get_results($sql);
	}
	
	
	
	
	/*
		buildAPIRequest 
		
		Based on https://www.checkwxapi.com/documentation/code/samples API. 
		API key required, default key provided for all iCrew users.
		
		@var $station: ICAO code of the airport, 
		@var $type: Type of request that we need. METAR or TAF. 
		
		@response API url
	*/
	
	protected static function buildAPIRequest($station, $type = 'metar') {
		
		if($station == '' || strlen($station) != 4)  {
			Debug::log('Invalid Airport code found: '. $station);
			return Debug::showCritical('Invalid Airport Code provided in AirportData class: '. $station, 'Invalid data!');
		}
		
		switch($type) {
			case 'metar': 
				$type = 'metar';
			break;
			
			case 'taf':
				$type = 'taf';
			break;
			
			default: 
				$type = 'metar';
		}
		
		$url = 'https://api.checkwx.com/'. $type .'/'.$station.'?key=a8cd9bccc56041e08740c0d72b';
		
		
		$response = self::fetch_data($url);
		
		if($response->results == 0) {
			Debug::log('No results fetched for '. $url.' request.');
			// Debug::showCritical('No results fetched while trying to build API request for: '. $station.'. URL: '.$url, 'WX Data API Error!');;
			return strtoupper("ERROR: Unable to fetch " . strtoupper($type). " for ". $station.'. No response received from API');
		} else {
			return $response->data[0];
		}
		
	}
	
	
	/*
		fetch_data 
		
		make a cURL request to the URL provided. 
		
		@var $url - a valid URL. 
		@response Response decoded in JSON
		
	*/
	
	protected static function fetch_data($url) {
		  $options = array(
	        CURLOPT_RETURNTRANSFER => true,   // return web page
	        CURLOPT_HEADER         => false,  // don't return headers
	        CURLOPT_FOLLOWLOCATION => true,   // follow redirects
	        CURLOPT_MAXREDIRS      => 10,     // stop after 10 redirects
	        CURLOPT_ENCODING       => "",     // handle compressed
	        CURLOPT_USERAGENT      => "test", // name of client
	        CURLOPT_AUTOREFERER    => true,   // set referrer on redirect
	        CURLOPT_CONNECTTIMEOUT => 120,    // time-out on connect
	        CURLOPT_TIMEOUT        => 120,    // time-out on response
	    ); 
	
	    $ch = curl_init($url);
	    curl_setopt_array($ch, $options);
	
	    $content  = curl_exec($ch);
	
	    curl_close($ch);
	
	    return json_decode($content);
	}
	
	
	/*
		getMETAR
		
		Fetch the METAR information for a given airport. 
		
		@var $icao - ICAO code for the airport. 
		@response METAR in text format. 
	*/
	
	public static function getMETAR($icao) {
		return self::buildAPIRequest($icao, 'metar');
	}
	
	
	/*
		getTAF
		
		Fetch the TAF information for a given airport. 
		
		@var $icao - ICAO code for the airport. 
		@response TAF in text format. 
	*/
	
	public static function getTAF($icao) {
		return self::buildAPIRequest($icao, 'taf');
	}
	
 }
 ?>