<?php
	
	/**
	 * DiscordData - A Simple Discord class that helps to send webhook messages to servers. 
	 * (c) icrewsystems.
	 */
	class DiscordData extends CodonData {

		public static function deliver($message, $url = '') {

			if($url == '') {
				$url = DISCORD_ADMIN_TEXT_CHANNEL;
			}

			if(DISCORD_ENABLE_WEBHOOKS == 0) {

			} else {
				$hookObject = json_encode([
						/*
						 * The general "message" shown above your embeds
						 */
						// "content" => $_POST['message'],
						/*
						 * The username shown in the message
						 */
						// "username" => SITE_NAME." Notifications",
						/*
						 * The image location for the senders image
						 */
						// "avatar_url" => SITE_URL."/iCrew/favicon.png",
						/*
						 * Whether or not to read the message in Text-to-speech
						 */
						"tts" => false,
						/*
						 * File contents to send to upload a file
						 */
						// "file" => "",
						/*
						 * An array of Embeds
						 */
						"embeds" => [
								/*
								 * Our first embed
								 */
								[
										// Set the title for your embed
										// "title" => "Google.com",

										// The type of your embed, will ALWAYS be "rich"
										"type" => "rich",

										// A description for your embed
										"description" => $message,

										// The URL of where your title will be a link to
										"url" => SITE_URL,

										/* A timestamp to be displayed below the embed, IE for when an an article was posted
										 * This must be formatted as ISO8601
										 */
											// "timestamp" => "2018-03-10T19:15:45-05:00",

										// The integer color to be used on the left side of the embed
										"color" => hexdec( "fafafa" ),

										// Footer object
										"footer" => [
												"text" => SITE_NAME. " | Powered by iCrew™",
													"icon_url" => SITE_URL."/iCrew/favicon.png",
										],

										// Image object
										// "image" => [
										//     "url" => "https://www.google.com/images/branding/googlelogo/1x/googlelogo_color_272x92dp.png"
										// ],
										//
										// // Thumbnail object
										// "thumbnail" => [
										//     "url" => "https://pbs.twimg.com/profile_images/972154872261853184/RnOg6UyU_400x400.jpg"
										// ],
										//
										// // Author object
										"author" => [
												"name" => "iCrew Notification Bot"
										]
								]
						]

				], JSON_UNESCAPED_SLASHES | JSON_UNESCAPED_UNICODE );

				$ch = curl_init();

				curl_setopt_array( $ch, [
						CURLOPT_URL => $url,
						CURLOPT_POST => true,
						CURLOPT_POSTFIELDS => $hookObject,
						CURLOPT_HTTPHEADER => [
								"Content-Type: application/json"
						]
				]);


				$response = curl_exec( $ch );

					if (curl_errno($ch)) {
						// his would be your first hint that something went wrong
						die('Something went wrong  ' . curl_error($ch));
					} else {
						return "Discord message sent!";
					}


			}
		}

		public static function delive_detailed($tag, $color, $message, $link, $url = '') {

			if($url == '') {
				$url = DISCORD_ADMIN_TEXT_CHANNEL;
			}

			if(DISCORD_ENABLE_WEBHOOKS == 0) {

			} else {
				$hookObject = json_encode([
						/*
						 * The general "message" shown above your embeds
						 */
						"content" => $tag,
						/*
						 * The username shown in the message
						 */
						// "username" => SITE_NAME." Notifications",
						/*
						 * The image location for the senders image
						 */
						// "avatar_url" => SITE_URL."/iCrew/favicon.png",
						/*
						 * Whether or not to read the message in Text-to-speech
						 */
						"tts" => false,
						/*
						 * File contents to send to upload a file
						 */
						// "file" => "",
						/*
						 * An array of Embeds
						 */
						"embeds" => [
								/*
								 * Our first embed
								 */
								[
										// Set the title for your embed
										"title" => "Click here to review",

										// The type of your embed, will ALWAYS be "rich"
										"type" => "rich",

										// A description for your embed
										"description" => $message,

										// The URL of where your title will be a link to
										"url" => $link,

										/* A timestamp to be displayed below the embed, IE for when an an article was posted
										 * This must be formatted as ISO8601
										 */
											// "timestamp" => "2018-03-10T19:15:45-05:00",

										// The integer color to be used on the left side of the embed
										"color" => hexdec( "$color" ),

										// Footer object
										"footer" => [
												"text" => SITE_NAME. " | Powered by iCrew™",
													"icon_url" => SITE_URL."/iCrew/favicon.png",
										],

										// Image object
										// "image" => [
										//     "url" => "https://www.google.com/images/branding/googlelogo/1x/googlelogo_color_272x92dp.png"
										// ],
										//
										// // Thumbnail object
										// "thumbnail" => [
										//     "url" => "https://pbs.twimg.com/profile_images/972154872261853184/RnOg6UyU_400x400.jpg"
										// ],
										//
										// // Author object
										"author" => [
												"name" => "iCrew PIREP Bot"
										]
								]
						]

				], JSON_UNESCAPED_SLASHES | JSON_UNESCAPED_UNICODE );

				$ch = curl_init();

				curl_setopt_array( $ch, [
						CURLOPT_URL => $url,
						CURLOPT_POST => true,
						CURLOPT_POSTFIELDS => $hookObject,
						CURLOPT_HTTPHEADER => [
								"Content-Type: application/json"
						]
				]);


				$response = curl_exec( $ch );

					if (curl_errno($ch)) {
						// his would be your first hint that something went wrong
						die('Something went wrong  ' . curl_error($ch));
					} else {
						return "Discord message sent!";
					}


			}
		}


		public static function deliver_ss($module, $description, $link, $image, $title, $message, $url) {


      			// if($url == '') {
      			// 	$url = DISCORD_ADMIN_TEXT_CHANNEL;
      			// }

      			// if(DISCORD_ENABLE_WEBHOOKS == 0) {

      			// } else {
      			// 		$msg = $message;
      			// 		$json_data = array ('content'=>"$msg");
      			// 		$make_json = json_encode($json_data);
      			// 		$ch = curl_init( $url );
      			// 		curl_setopt( $ch, CURLOPT_POST, 1);
      			// 		curl_setopt( $ch, CURLOPT_POSTFIELDS, $make_json);
      			// 		curl_setopt( $ch, CURLOPT_FOLLOWLOCATION, 1);
      			// 		curl_setopt( $ch, CURLOPT_HEADER, 0);
      			// 		curl_setopt( $ch, CURLOPT_RETURNTRANSFER, 1);
      			// 		$response = curl_exec( $ch );
      			// 		if (curl_errno($ch)) {
      			// 			// his would be your first hint that something went wrong
      			// 			die('Something went wrong  ' . curl_error($ch));
      			// 		} else {
      			// 		// check the HTTP status code of the request
      			// 		$resultStatus = curl_getinfo($ch, CURLINFO_HTTP_CODE);
      			// 		if ($resultStatus == 200 || $resultStatus == 204) {
      			// 		// everything went better than expected
      			// 		$clr = "success";
      			// 		$status = 'Payload delivered successfully to the server! Check notifications, status code : ' . $resultStatus.'';

      			// 		} else if ($resultStatus == 404) {
      			// 		// everything went better than expected
      			// 		$clr = "danger";
      			// 		$status = 'Webhook URL is invalid, get a new URL from Discord > Server Settings > Webhooks and configure at local.config.php, status code : ' . $resultStatus.'';

      			// 		} else {
      			// 		// the request did not complete as expected. common errors are 4xx
      			// 		// (not found, bad request, etc.) and 5xx (usually concerning
      			// 		// errors/exceptions in the remote script execution)
      			// 		$clr = "danger";
      			// 		$status = 'Request failed: HTTP status code: ' . $resultStatus.'';
      			// 		}

      			// 	}
      			// }


		if(DISCORD_ENABLE_WEBHOOKS == 0) {

			} else {
					$msg = $_POST['message'];
$title = $_POST['title'];
$description = $_POST['description'];
$image_url = $_POST['image_url'];
$url = $_POST['url'];
$url_text = $_POST['author'];
$json_data = array ('content'=>"$msg",
					"embeds" => [
        /*
         * Our first embed
         */
        [
            // Set the title for your embed
            "title" => "$title",

            // The type of your embed, will ALWAYS be "rich"
            "type" => "rich",

            // A description for your embed
            "description" => "$description",

            // The URL of where your title will be a link to
            "url" => "$url",

            /* A timestamp to be displayed below the embed, IE for when an an article was posted
             * This must be formatted as ISO8601
             */
            // "timestamp" => time('Y-m-d H:i:s A'),

            // The integer color to be used on the left side of the embed
            "color" => hexdec( "fafafa" ),

            // Footer object
            "footer" => [
                "text" => SITE_NAME." | Proudly powered by iCrew v4 Premium",
                "icon_url" => SITE_URL."/iCrew/v4logo.png"
            ],

            // Image object
            "image" => [
                "url" => "$image_url"
            ],

            // // Thumbnail object
            // "thumbnail" => [
            //     "url" => "https://pbs.twimg.com/profile_images/972154872261853184/RnOg6UyU_400x400.jpg"
            // ],

            // Author object
            "author" => [
                "name" => "$url_text"
            ],


			"tts" => true,

        ]
    ]

);

					$make_json = json_encode($json_data);
					$ch = curl_init( $url );
					curl_setopt( $ch, CURLOPT_POST, 1);
					curl_setopt( $ch, CURLOPT_POSTFIELDS, $make_json);
					curl_setopt( $ch, CURLOPT_FOLLOWLOCATION, 1);
					curl_setopt( $ch, CURLOPT_HEADER, 0);
					curl_setopt( $ch, CURLOPT_RETURNTRANSFER, 1);
					$response = curl_exec( $ch );
					if (curl_errno($ch)) {
						// his would be your first hint that something went wrong
						die('Something went wrong  ' . curl_error($ch));
					} else {
					// check the HTTP status code of the request
					$resultStatus = curl_getinfo($ch, CURLINFO_HTTP_CODE);
					if ($resultStatus == 200 || $resultStatus == 204) {
					// everything went better than expected
					$clr = "success";
					$status = 'Payload delivered successfully to the server! Check notifications, status code : ' . $resultStatus.'';

					} else if ($resultStatus == 404) {
					// everything went better than expected
					$clr = "danger";
					$status = 'Webhook URL is invalid, get a new URL from Discord > Server Settings > Webhooks and configure at local.config.php, status code : ' . $resultStatus.'';

					} else {
					// the request did not complete as expected. common errors are 4xx
					// (not found, bad request, etc.) and 5xx (usually concerning
					// errors/exceptions in the remote script execution)
					$clr = "danger";
					$status = 'Request failed: HTTP status code: ' . $resultStatus.'';
					}

				}
			}
 }

	}
