<?php 
	class ICSFleetData extends CodonData {
		
		
		public static function update_fleet_locations() {
			$fleets = ICSFleetData::getAllFleet();
				foreach ($fleets as $fleet) {
					$last_flight = ICSFleetData::get_last_flight($fleet->id);
					if($last_flight == '') {
						$ac_current_location = "KFDW";
					} else {
						$ac_current_location = $last_flight->arricao;
					}
					
					$id = $fleet->id;
					$sql = "UPDATE `phpvms_aircraft` SET `location` = '$ac_current_location' WHERE `id` = '$id'";
					DB::query($sql);
			}
		return true;
		}
		
		public static function acOnBids($aircraftid) {
			$sql = "SELECT * FROM ".TABLE_PREFIX."bids WHERE aircraftid='$aircraftid'";
			return DB::get_results($sql);
		}
		
		public static function findSchedules_aircraft($acicao, $airport) {
			$sql = "SELECT s.*, a.icao as aircraft FROM ".TABLE_PREFIX."schedules AS s LEFT JOIN ".TABLE_PREFIX."aircraft AS a ON a.id = s.aircraft WHERE s.depicao='$airport' AND a.icao='$acicao'";
			return DB::get_results($sql);
		}
	
		public static function getAllFleet($onlyactive = 0) {
			if($onlyactive == 1) {
				$sql = "SELECT * FROM `phpvms_aircraft` WHERE `enabled` = '1'";
			} else {
				$sql = "SELECT * FROM `phpvms_aircraft`";
			}
			
			return DB::get_results($sql);
		}
		
		public static function getAllCategories() {
			$sql = "SELECT * FROM `icrewsystems_fleet_category`";
			return DB::get_results($sql);
		}
		
		public static function getCategoryByID($id) { 
			$sql = "SELECT * FROM `icrewsystems_fleet_category`	WHERE `category_id` = '$id'";
			return DB::get_row($sql);
		}
		
		public static function getCategoryNameByID($id) { 
			$sql = "SELECT * FROM `icrewsystems_fleet_category`	WHERE `category_id` = '$id'";
			$res = DB::get_row($sql);
			return $res->name;
		}
		
		
		public static function updateCategory($data) {
			$id = $data->id;
			$name = $data->name;
			$description = $data->description;
			$active = $data->active;
			$sql = "UPDATE `icrewsystems_fleet_category` SET `name` = '$name', `description` = '$description', `active` = '$active' WHERE `id` = '$id'";
			DB::query($sql);
		}
		
		public static function addCategory($data) {
			$name = $data->name;
			$description = $data->about;
			$active = $data->active;
			$sql = "INSERT INTO `icrewsystems_fleet_category` SET `name` = '$name', `description` = '$description', `active` = '$active'";
			DB::query($sql);
		}
		
		public static function deleteCategory($data) {
			$id = $data->category_id;
			$sql = "DELETE FROM `icrewsystems_fleet_category` WHERE `category_id` = '$id'";
			DB::query($sql);
		}
		
		
		
		public static function getAllFleetGrouped($onlyactive = 0) {
			if($onlyactive == 1) {
				$sql = "SELECT * FROM `phpvms_aircraft` WHERE `enabled` = '1' GROUP BY `name` ORDER BY `icao` ASC";
			} else {
				$sql = "SELECT * FROM `phpvms_aircraft` GROUP BY `name` ORDER BY `icao` ASC";
			}
			
			return DB::get_results($sql);
		}
		
		public static function getAllFleetGrouped_rand($onlyactive = 0) {
			if($onlyactive == 1) {
				$sql = "SELECT * FROM `phpvms_aircraft` WHERE `enabled` = '1' GROUP BY `name` ORDER BY RAND() ";
			} else {
				$sql = "SELECT * FROM `phpvms_aircraft` GROUP BY `name` ORDER BY RAND()";
			}
			
			return DB::get_results($sql);
		}
		
		public static function getACbyID($id) {
			$sql = "SELECT * FROM `phpvms_aircraft` WHERE `id` LIKE '$id'";
			return DB::get_row($sql);
		}
		
		public static function getAircraftsAtAirport($icao) {
			$sql = "SELECT * FROM `phpvms_aircraft` WHERE `location` LIKE '$icao'";
			return DB::get_results($sql);
		}
		
		public static function getAircraftsAtAirport_pf($icao, $type) {
			$sql = "SELECT * FROM `phpvms_aircraft` WHERE `location` LIKE '$icao' AND `icao` = '$type'";
			return DB::get_results($sql);
		}
		
		
		
		public static function getACStatus($id, $current_location) {
			$aircraft = self::getACbyREG($id);
			$sql = "SELECT * FROM `phpvms_schedules` WHERE `aircraft` = '$id' AND `depicao` = '$current_location'";
			$result = DB::get_results($sql);
			if($result == '') {
				return "<span class='label label-danger animated-pulse'>STRANDED</span>";
			} else {
				return "<span class='label label-success'>OPERATIONAL</span>";
			}
		}
		
		public static function acStranded($id, $current_location) {
			$aircraft = self::getACbyID($id);
			$sql = "SELECT * FROM `phpvms_schedules` WHERE `aircraft` = '$id' AND `depicao` = '$current_location'";
			$result = DB::get_results($sql);
			if($result == '') {
				return 1;
			} else {
				return 0;
			}
		}
		
		public static function get_next_schedule($id, $current_location) {
			$aircraft = self::getACbyID($id);
			$sql = "SELECT * FROM `phpvms_schedules` WHERE `aircraft` = '$id' AND `depicao` = '$current_location'";
			$result = DB::get_results($sql);
			return $result;
		}
		
		
		public static function getACbyICAO($icao) {
			$sql = "SELECT * FROM `phpvms_aircraft` WHERE `icao` LIKE '$icao'";
			return DB::get_results($sql);
		}
		
		public static function get_category($id) {
			$sql = "SELECT name FROM `icrewsystems_fleet_category` WHERE `category_id` = '$id'";
			$result =  DB::get_row($sql);
			return $result->name;
		}
		public static function getACbyREG($reg) {
			$sql = "SELECT * FROM `phpvms_aircraft` WHERE `registration` LIKE '$reg'";
			return DB::get_row($sql);
		}
		
		public static function get_last_flight($id) {
			$sql = "SELECT * FROM ".TABLE_PREFIX."pireps WHERE aircraft = {$id} ORDER BY submitdate DESC LIMIT 1";
			return DB::get_row($sql);
		}

		// Apoorv - Retrieving aircraft history
		public static function getPirepsByAircraft($id) {
			$sql = "SELECT * FROM ".TABLE_PREFIX."pireps WHERE aircraft = {$id} AND accepted = 1 ORDER BY submitdate DESC";
			return DB::get_results($sql);
		}
		
		public static function time_elapsed_string($datetime, $full = false) {
			$now = new DateTime;
    		$ago = new DateTime($datetime);
    $diff = $now->diff($ago);

    $diff->w = floor($diff->d / 7);
    $diff->d -= $diff->w * 7;

    $string = array(
        'y' => 'year',
        'm' => 'month',
        'w' => 'week',
        'd' => 'day',
    );
    foreach ($string as $k => &$v) {
        if ($diff->$k) {
            $v = $diff->$k . ' ' . $v . ($diff->$k > 1 ? 's' : '');
        } else {
            unset($string[$k]);
        }
    }

    if (!$full) $string = array_slice($string, 0, 1);
    return $string ? implode(', ', $string) . ' ago' : 'just now';
}
		
	}
