<?php
	class ICSScheduleMap extends CodonData {


		public function index() {
			"it works";
		}

		public static function current_location() {
			$last_flight = PIREPData::getLastReports(Auth::$userinfo->pilotid, 1, PIREP_ACCEPTED);
			if(!$last_flight) {
				$current_location = Auth::$userinfo->hub;
			} else {
				$current_location = $last_flight->arricao;
			}

			$data = OperationsData::getAirportInfo($current_location);
			if($data == '') {
				$current_location = Auth::$userinfo->hub;
				$data = OperationsData::getAirportInfo($current_location);
			}

			return $data;
		}



		public static function flights_from_location($depicao, $limit = 100) {

			$params = array();
			$params['depicao'] = $depicao;

			$sql = 'SELECT s.id, s.code, s.flightnum, s.flighttime, s.depicao, s.arricao,
					a.id as aircraftid,
					a.name as aircraft,
					a.registration,
					dep.name as depname,
					dep.lat AS deplat,
					dep.lng AS deplng,
					arr.name as arrname,
					arr.lat AS arrlat,
					arr.lng AS arrlng
				FROM ' . TABLE_PREFIX . 'schedules AS s
				LEFT JOIN ' . TABLE_PREFIX . 'airports AS dep ON dep.icao = s.depicao
				LEFT JOIN ' . TABLE_PREFIX . 'airports AS arr ON arr.icao = s.arricao
				LEFT JOIN ' . TABLE_PREFIX . 'aircraft AS a ON a.id = s.aircraft';

			$sql .= DB::build_where($params);

        // Order matters
        if (Config::Get('SCHEDULES_ORDER_BY') != '') {
            $sql .= ' ORDER BY ' . Config::Get('SCHEDULES_ORDER_BY');
        }

        if (strlen($limit) != 0) {
            $sql .= ' LIMIT ' . $limit;
        }

        $ret = DB::get_results($sql);
		$sch = $ret;

        if(!$ret) {
            return array();
        }

		//$sch = SchedulesData::findSchedules($params, $limit);
        return $sch;


		}
	}
?>
