<?php

/**
 * NotamsData - Database abstraction class for Notams module. 
 * @author Leonard Selvaraja 
 * @version 1.3 
 * @release 01 January 2018
 * 
 * This module is included with iCrew v4. NOT TO BE SOLD SEPERATELY.
 */

class NotamsData extends CodonData {

	public static function version() {
		return self::getSettingValue('module_version');
	}

	public static function moduleStatus() {
		return self::getSettingValue('module_status');
	}

	public static function getSettingValue($setting) {
		$sql = "SELECT * FROM `icrewsystems_notams_settings` WHERE `id` = 1";
		$result = DB::get_row($sql);

		foreach ($result as $result => $key) {
			if($result == $setting) {
				return $key;
			}
		}
	}

	public static function updateSettings($active) {
		$active = DB::escape($active);
		$sql = "UPDATE `icrewsystems_notams_settings` SET `module_status` = '$active' WHERE `id` = '1'";
		return DB::query($sql);
	}


	public static function getAllSettings() {
		$sql = "SELECT * FROM `icrewsystems_notams_settings` WHERE `id` = 1";
		return DB::get_row($sql);
	}

	public static function getAllSeries($active = 1) {
		if($active == 1) {
			$sql = "SELECT * FROM `icrewsystems_notams_series` WHERE `active` = 1";
		} else {
			$sql = "SELECT * FROM `icrewsystems_notams_series`";
		}
		return DB::get_results($sql);
	}

	public static function getAll($active = 0) {
		if($active == 1) {
			$sql = "SELECT * FROM `icrewsystems_notams` WHERE `active` = '1'";
		} else {
			$sql = "SELECT * FROM `icrewsystems_notams`";
		}
		return DB::get_results($sql);
	}

	public static function getNotams($count = 3) {
		$sql = "SELECT * FROM `icrewsystems_notams` WHERE `active` = '1' LIMIT $count";	
		return DB::get_results($sql);
	}

	public static function GetNotam($id) {
		$sql = "SELECT * FROM `icrewsystems_notams` WHERE `id` = '$id'";
		return DB::get_row($sql);
	}


	public static function getSeries($id) {
		$sql = "SELECT * FROM `icrewsystems_notams_series` WHERE `id` = '$id'";
		$result = DB::get_row($sql);
		if($result == '') {
			return "Unknown / Deleted Series";
		} else {
			return $result->name;
		}
	}

	public static function readStatus($notam_id, $pilotid) {
		if($notam_id == '') {
			return false;
		} else {
			if($pilotid == '') {
				$pilotid = Auth::$userinfo->pilotid;
			}

			// First find if there's a dubpe entry.

			$sql = "SELECT * FROM `icrewsystems_notams_read` WHERE `notam_id` = '$notam_id' AND `pilotid` = '$pilotid'";
			$results = DB::get_row($sql);

			if($results == '') {
				return false;
			} else {
				return true;
			}
		}
	}


	public static function markasread($notam_id, $pilotid) {
		if($notam_id == '') {
			return false;
		} else {
			$pilotid = Auth::$userinfo->pilotid;

			// First find if there's a dubpe entry.

			$sql = "SELECT * FROM `icrewsystems_notams_read` WHERE `notam_id` = '$notam_id' AND `pilotid` = '$pilotid'";
			$results = DB::get_row($sql);

			if($results == '') {
				//No dupe, proceed.

				$sql = "INSERT INTO `icrewsystems_notams_read` (`notam_id`, `pilotid`) VALUES ('$notam_id', '$pilotid')";
				$result = DB::query($sql);
				return $result;
			} else {
				return false;
			}
		}
	}

	public static function getStatus($date1, $date2) {
		$today = date("Y-m-d");
		if($today < $date1) {
			$button = "<span class='badge badge-info'>FUTURE ISSUE</span>";
		}
		else if ($date1 < $date2){
			$button = "<span class='badge badge-success'>ACTIVE</span>";
		} else if($date1 == $date2) {
			$button = "<span class='badge badge-warning'>EXPIRES TODAY</span>";
		} else {
			$button = "<span class='badge badge-danger'>EXPIRED</span>";
		}

		return $button;
	}


	public static function getIssuedStatus($value) {
		if($value == 1) {
			$button = "<span class='badge badge-success'>Effective</span>";
		}
		 else {
			$button = "<span class='badge badge-danger'>Revoked</span>";
		}

		return $button;
	}


	public static function getSeriesStatus($value) {
		if($value == 1) {
			$button = "<span class='badge badge-success'>Active</span>";
		}
		 else {
			$button = "<span class='badge badge-danger'>Inactive</span>";
		}

		return $button;
	}


	public static function newSeries($name, $active = 1) {
		$name = DB::escape($name);
		$active = DB::escape($active);

		$sql = "INSERT INTO `icrewsystems_notams_series` (name, active)
		VALUES ('$name','$active')";
		$result = DB::query($sql);
		return $result;
	}


	public static function deleteSeries($id) {
		$id = DB::escape($id);
		$sql = "DELETE FROM `icrewsystems_notams_series` WHERE `id` = '$id'";
		$result = DB::query($sql);
		return $result;
	}

	public static function updateSeries($id, $name, $status = 1) {
		$id = DB::escape($id);
		$name = DB::escape($name);
		$status = DB::escape($status);

		$sql = "UPDATE `icrewsystems_notams_series` SET `name` = '$name', `active` = '$status' WHERE `id` = '$id'";
		return DB::query($sql);
	}



	public static function issueNewNotam($title, $code, $valid_from, $valid_till, $body, $series, $active = 1) {
		$title = DB::escape($title);
		$code = DB::escape($code);
		$valid_from = DB::escape($valid_from);
		$valid_till = DB::escape($valid_till);
		$body = DB::escape($body);
		$series = DB::escape($series);
		$active = DB::escape($active);

		$sql = "INSERT INTO `icrewsystems_notams` (title, code, valid_from, valid_till, body, series, active)
		VALUES ('$title','$code','$valid_from','$valid_till','$body','$series', '$active')";
		$result = DB::query($sql);
		return $result;
	}


	public static function updateNotam($id, $title, $code, $valid_from, $valid_till, $body, $series, $active) {
		$id = DB::escape($id);
		$title = DB::escape($title);
		$code = DB::escape($code);
		$valid_from = DB::escape($valid_from);
		$valid_till = DB::escape($valid_till);
		$body = DB::escape($body);
		$series = DB::escape($series);
		$active = DB::escape($active);


		$sql = "UPDATE `icrewsystems_notams` SET `title` = '$title',
		`code` = '$code', `valid_from` = '$valid_from',
		`valid_till` = '$valid_till', `body` = '$body',
		`series` = '$series', `active` = '$active' WHERE `id` = '$id'";
		$result = DB::query($sql);
		return $result;
	}


		public static function revokeNotam($id = 0) {

		$id = DB::escape($id);
		if($id == 0) {
			return false;
		} else {
			$sql = "UPDATE `icrewsystems_notams` SET `active` = '0' WHERE `id` = '$id'";
			$result = DB::query($sql);
			return $result;
		}


	}

	public static function deleteNotam($id = 0) {
		$id = DB::escape($id);
		if($id == 0) {
			return false;
		} else {
			$sql = "DELETE FROM `icrewsystems_notams` WHERE `id` = '$id'";
			return DB::query($sql);
		}
	}


}
