<?php 	
/**
    * PassportData - 
    * @author Leonard Selvaraja 
    * @version 1.0
    * @release 01 January 2018
    * 
    * This module is included with iCrew v4. NOT TO BE SOLD SEPERATELY.
*/
	class PassportData extends CodonData {
		
		
		public static function findPIREPS($params, $count = '', $start = '') {
        
        $sql = 'SELECT p.*, UNIX_TIMESTAMP(p.submitdate) as submitdate, 
                    UNIX_TIMESTAMP(p.modifieddate) as modifieddate, 
					u.pilotid, u.firstname, u.lastname, u.email, u.rank, u.code AS pcode,
					a.id AS aircraftid, a.name as aircraft, a.registration,
					dep.name as depname, dep.lat AS deplat, dep.lng AS deplng,
					arr.name as arrname, arr.lat AS arrlat, arr.lng AS arrlng						
				FROM ' . TABLE_PREFIX . 'pireps p
				LEFT JOIN ' . TABLE_PREFIX . 'aircraft a ON a.id = p.aircraft
				LEFT JOIN ' . TABLE_PREFIX . 'airports AS dep ON dep.icao = p.depicao
				LEFT JOIN ' . TABLE_PREFIX . 'airports AS arr ON arr.icao = p.arricao 
				LEFT JOIN ' . TABLE_PREFIX . 'pilots u ON u.pilotid = p.pilotid ';

        /* Build the select "WHERE" based on the columns passed */
        $sql .= DB::build_where($params);

        $sql .= ' ORDER BY p.submitdate ASC';

        if (strlen($count) != 0) {
            $sql .= ' LIMIT ' . $count;
        }

        if (strlen($start) != 0) {
            $sql .= ' OFFSET ' . $start;
        }

        return DB::get_results($sql);
    }
    
    
		public static function getAllReportsForPilot($pilotid) {
        return self::findPIREPS(array('p.pilotid' => $pilotid));
    }
    
    public static function getCountryCode($name) {
        $ctrys = Countries::$countries;
		$ctrys = array_flip($ctrys);
		
        return $ctrys[$name];
    }
    
	}