<?php

/*
	Module Name : Activate Pilot Account
	Author : Leonard Selvaraja
*/
	class Activate extends CodonModule {


		public function index() {

			//Check if user is active or not

			$active = Auth::$userinfo->retired;
			if($active > 0) {
				// Inactive Code goes here
				$key_contents = date('dmy').Auth::$userinfo->pilotid.''.Auth::$userinfo->firstname.''.Auth::$userinfo->lastname.''.SITE_URL;
				$auth_key = base64_encode($key_contents);
				$this->set('auth_key', $auth_key);
				$this->set('title', 'Activate Pilot Profile');
				$this->render('activate/index.php');
			} else {
				// Active code goes here
				$this->set('message', 'Your pilot profile is already active, no need to re-activate your account. Happy Flying!');
				$this->show('core_message.php');
				$this->render('profile_main.php');
			}

		}

		public function send_auth_key() {
			// Send the email. Reference the Template file here.
			$key_contents = date('dmy').Auth::$userinfo->pilotid.''.Auth::$userinfo->firstname.''.Auth::$userinfo->lastname.''.SITE_URL;
			$auth_key = base64_encode($key_contents);
			$email = Auth::$userinfo->email;
			$subject = 'Authentication Key for account activation | '.SITE_NAME.'';
			$message = '<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
        <title>Activation Email</title>
        <meta name="viewport" content="width=device-width" />
        <style type="text/css">
            @media only screen and (max-width: 550px), screen and (max-device-width: 550px) {
                body[yahoo] .buttonwrapper { background-color: transparent !important; }
                body[yahoo] .button { padding: 0 !important; }
                body[yahoo] .button a { background-color: #349ee5; padding: 15px 25px !important; }
            }

            @media only screen and (min-device-width: 601px) {
                .content { width: 600px !important; }
                .col387 { width: 387px !important; }
            }
        </style>
    </head>
    <body bgcolor="#252d2f" style="margin: 0; padding: 0;" yahoo="fix">
        <!--[if (gte mso 9)|(IE)]>
        <table width="600" align="center" cellpadding="0" cellspacing="0" border="0">
          <tr>
            <td>
        <![endif]-->
        <table align="center" border="0" cellpadding="0" cellspacing="0" style="border-collapse: collapse; width: 100%; max-width: 600px;" class="content">
            <tr>
                <td align="center" bgcolor="#cccccc" style="padding: 25px 20px 20px 20px; color: #ffffff; font-family: Arial, sans-serif; font-size: 26px;">
                    <img src="'.SITE_URL.'/iCrew/ics_logo.png" alt="'.SITE_NAME.'" width="auto;" height="80" style="display:block;" />
                </td>
            </tr>
            <tr>
                <td align="left" bgcolor="#ffffff" style="padding: 40px 20px 0 20px; color: #555555; font-family: Arial, sans-serif; font-size: 18px; line-height: 30px;">
                    <b>Hey there,</b>
                </td>
            </tr>
            <tr>
                <td align="left" bgcolor="#ffffff" style="padding: 0 20px 40px 20px; color: #777777; font-family: Arial, sans-serif; font-size: 14px;  border-bottom: 1px solid #f6f6f6;">
                      How are you mate?<br><br>My name is AdminBot, I am an AI Bot designed at '.SITE_NAME.' and it\'s been a long time.
                      I see you have requested for re-activating your pilot account since you were inactive for more than '.Config::Get('PILOT_INACTIVE_TIME').' days, I decided to take you off the active roster.
                      <br>
                      To mark yourself active again, copy and paste the code below into the activation page. <br><br>
                      <center><code>'.$auth_key.'</code></center>
                      <br><br>
                      Hope to see you around real soon!
                    <br><br>
                    Love,<br>
                    <b>AdminBot.</b>
                </td>
            </tr>

            <tr>
                <td align="center" bgcolor="#ffffff" style="padding: 0 20px 40px 20px; color: #777777; font-family: Arial, sans-serif; font-size: 12px;  border-bottom: 1px solid #f6f6f6;">
                    <br>If you are having trouble with copying, just go to this URL<br> <a href="'.SITE_URL.'/index.php/activate/verify?auth_key='.$auth_key.'">'.SITE_URL.'/index.php/activate/verify?auth_key='.$auth_key.'</a><br>
                    <br><i>This is an auto generated e-mail. For support, contact my human colleagues by submiting a ticket.</i>
                </td>
            </tr>
            <tr>
                <td align="center" bgcolor="#e9e9e9" style="padding: 12px 10px 12px 10px; color: #888888; font-family: Arial, sans-serif; font-size: 12px; line-height: 18px;">
                    <b>'.SITE_NAME.'</b> <br>Powered by iCrew v4.3 <i>Premium</i> &bull; Crafted by icrewsystems

                </td>
            </tr>
            <tr>
                <td style="padding: 15px 10px 15px 10px;">
                    <table border="0" cellpadding="0" cellspacing="0" width="100%">
                        <tr>
                            <td align="center" width="100%" style="color: #999999; font-family: Arial, sans-serif; font-size: 12px;">
                               '.VA_TAGLINE.'
                            </td>
                        </tr>
                    </table>
                </td>
            </tr>
        </table>
        <!--[if (gte mso 9)|(IE)]>
                </td>
            </tr>
        </table>
        <![endif]-->
    </body>
</html>
';
			$active = Auth::$userinfo->retired;
			if($active > 0) {
				// Inactive Code goes here
			Util::SendEmail($email, $subject, $message);
			// mail($email, $subject, $message);
			DiscordData::deliver(''.Auth::$userinfo->code.''.Auth::$userinfo->pilotid.' has requested an AuthKey!', DISCORD_ADMIN_TEXT_CHANNEL);
			$this->set('message', 'Authentication key has been sent to your registered email ID, please check.');
			$this->show('core_success.php');
			$this->render('activate/index.php');
			} else {
				// Active code goes here
				$this->set('message', 'Your pilot profile is already active, no need to re-activate your account. Happy Flying!');
				$this->show('core_message.php');
				$this->render('profile_main.php');
			}

		}

		public function verify() {
			$auth_key = $_GET['auth_key'];
			if($auth_key == '') {
				$this->set('message', 'No Authentication Key supplied! please check and try again');
				$this->show('core_error.php');
				$this->index();
			} else {
				$key_contents = date('dmy').Auth::$userinfo->pilotid.''.Auth::$userinfo->firstname.''.Auth::$userinfo->lastname.''.SITE_URL;
				if($auth_key == base64_encode($key_contents)) {
					// Code to activate pilot's account.
					$sql = "UPDATE `phpvms_pilots` SET `retired` = '0' WHERE `pilotid` = ".Auth::$userinfo->pilotid."";
					DB::query($sql);

					$this->set('message', 'Your account has been successfully activated, please keep in mind that you have to keep filing PIREPs once in every 30 days to keep your profile active!');
					$this->show('core_success.php');
					$this->render('profile_main.php');
				} else {
					$this->set('message', 'Incorrect Authentication key supplied, please check once again!');
					$this->show('core_error.php');
					$this->index();
				}
			}
		}
	}
