<?php
class AdvancedWX extends CodonModule
{
    public function index()
    {
        $this->show('advancedwx/index.php');
    }

    public function metarxml()
    {
        // Check if form is submitted

        //METAR Info
        $icao = isset($_POST['icao']) ? DB::escape($_POST['icao']) : '';
        if (empty($icao)) {
            die("ICAO code is required");
        }

        // Fetch and process METAR data
        $metar_data = $this->fetchMetar($icao);

        // Extract METAR information
        $metar = $metar_data->raw_text;
        $icao = $metar_data->icao;
        $observation_timestamp = strtotime($metar_data->observed);
        $observation_time = date('dS F, H:i', $observation_timestamp);
        $stattionname = $metar_data->station->name;
        $altimeter = $metar_data->barometer->hg;
        $country = $metar_data->station->location;
        $dewpoint = $metar_data->dewpoint->celsius;
        $flightrules = $metar_data->flight_category;
        $temperature = $metar_data->temperature->celsius;
        $visibility = $metar_data->visibility->miles_float;
        $winddir = $metar_data->wind->degrees;
        $windspd = $metar_data->wind->speed_kts;

        // Check if clouds data is available
        $clouds = isset($metar_data->clouds[0]) ? $metar_data->clouds[0]->text : '';

        $taf_data = $this->fetchTaf($icao);
        $taf = $taf_data->raw_text;

        // Set variables for rendering
        $this->set('metar', $metar);
        $this->set('time', $observation_time);
        $this->set('altimeter', $altimeter);
        $this->set('dewpoint', $dewpoint);
        $this->set('icao', $icao);
        $this->set('flightrules', $flightrules);
        $this->set('temperature', $temperature);
        $this->set('visibility', $visibility);
        $this->set('winddir', $winddir);
        $this->set('windspd', $windspd);
        $this->set('clouds', $clouds);
        $this->set('stationname', $stattionname);
        $this->set('stationcountry', $country);

        $this->set('taf', $taf);

        // Render the result
        $this->render('advancedwx/result.php');
    }

    // Function to fetch METAR data
    private function fetchMetar($icao)
    {
        $urlmet = 'https://api.checkwx.com/metar/' . $icao . '/decoded?key=a8cd9bccc56041e08740c0d72b';
        $xmlmet = file_get_contents($urlmet);
        $response_data = json_decode($xmlmet);

        // Check if data is returned properly
        if (!$response_data || !isset($response_data->data[0])) {
            die("No METAR data available for the provided ICAO code");
        }

        return $response_data->data[0];
    }

    private function fetchTaf($icao)
    {
        $urlmet = 'https://api.checkwx.com/taf/' . $icao . '/decoded?key=a8cd9bccc56041e08740c0d72b';
        $xmlmet = file_get_contents($urlmet);
        $response_data = json_decode($xmlmet);

        // Check if data is returned properly
        if (!$response_data || !isset($response_data->data[0])) {
            die("No TAF data available for the provided ICAO code");
        }

        return $response_data->data[0];
    }
}
?>