<?php
/*

	THIS MODULE IS TO BE USED ONLY WITH VIRTUAL AIRLINES USING ICREW. EDITING, REVERENGINEERING OF THIS MODULE
	IS PROHIBITED. IF FOUND OTHER WISE, CAN BE FINED UPTO $1000 USD.

	@contact hello@icrewsystems.com

	@author icrewsystems.com
	@build 02-06-2020
	@version 1.10
*/
class Charter extends CodonModule
{
	public $title = 'Charters';

	public function __construct() {
		if(CharterData::getSettingValue('module_status') == 0) {
			// Debug::showCritical('The Charters module has been disabled. Please Contact the admins to know more.', 'icrewsystems (c) Charters Module Unavailable');
			// die();
		} else {
			CodonEvent::addListener('Charter', array('pirep_filed'));
		}

	}

	public function EventListener($eventinfo) {
		$eventname = $eventinfo[0]; // Event name
		$eventmodule = $eventinfo[1]; // Class calling it
		if($eventinfo[0] == 'pirep_filed') {
			// Getting the most recent PIREP!
			$pirep = DB::get_row("SELECT * FROM ".TABLE_PREFIX."pireps ORDER BY pirepid DESC LIMIT 1");
			if($pirep->code != CharterData::getCharterAirlineCode()) {
				// Not a charter flight, so ignore!
			} else {
				$schedules = SchedulesData::getScheduleByFlight($pirep->code, $pirep->flightnum);
				if($schedules != '') {
					SchedulesData::deleteSchedule($schedules->id);
					PIREPData::addComment($pirep->pirepid, $pirep->pilotid, "This Charter Flight was Processed, Schedule ".$pirep->code.$pirep->flightnum." was deleted. (this comment was added by Admin Bot)");
				} else {

				}
			}
		}
	}


	public function index() {
		$this->set('totalairports', CharterData::getAllAirports());
		$this->show('charter/index');
	}


	public static function destination_tip() {
		$sql = "SELECT * FROM `icrewsystems_airports` WHERE length(icao) < 5 AND `city` != '' ORDER BY RAND() LIMIT 1; ";
		return DB::get_row($sql);
	}

	public function create($method = 'own') {

		if($method == 'own')	{

			/*
			@philosophy: The user must be able to choose any departure and destination
			in the world. Once he chooses, the flight must be processed.

			Flight Number: Randomly Generated
			Aircraft: Must be chosen from the available lot.
			Schedule: Generated, and must be deleted upon PIREP filed.

			@notifications: iMail only!

			/*/

			$this->set('allaircraft', CharterData::getCharterFleet());
			$this->set('allairports', CharterData::getAllAirports());
			$this->render('charter/own');


		} else if($method == 'explore') {

			if($_GET['icao'] == '') {
				$this->set('message', 'ICAO missing from URI. Try again?');
				$this->render('core_error.php');
				$this->index();
				return;
			}
			$this->set('allaircraft', CharterData::getCharterFleet());
			$this->set('allairports', CharterData::getAllAirports());
			$this->set('icao', CharterData::getAirportData($_GET['icao']));

			$this->set('message', 'Your departure ICAO is set to '.$_GET['icao'].'. You can swap this using the "Swap Airports" button');
			$this->show('core_message.php');
			$this->render('charter/explore');
		}


	}


	public function createFlight() {
		$data = $_POST;
		$sch = CharterData::addSchedule($data);
		// Now bid.
		$data = (object) $data;
		// THIS METHOD IS SPECIAL FOR UPSVAC. REMOVE IT IN OTHER VA's!
		$aircraftid = $data->aircraft;

		if($aircraftid == '') {
			 $this->set('message', 'Oh Snap! Aircraft ID missing.');
    		 $this->show('core_error.php');
    		 return;
		}

        // See if this is a valid route
        $route = SchedulesData::findSchedules(array('s.code' => $data->code, 's.flightnum' => $data->flightnum));

			foreach ($route as $route)
        if($route == '') {
			 $this->set('message', 'Oh Snap! Schedule was not added. Unable to bid flight.');
    		 $this->show('core_error.php');
    		 return;
		}

        CodonEvent::Dispatch('bid_preadd', 'Schedules', $route->id);


        // THIS METHOD IS SPECIAL FOR UPSVAC. REMOVE IT IN OTHER VA's! and use addBid ONLY!!!!!!!!!!!11

        $ret = SchedulesData::addBid(Auth::$pilot->pilotid, $route->id, $aircraftid);
        CodonEvent::Dispatch('bid_added', 'Schedules', $route->id);

        if ($ret == true) {
            $this->set('message', 'Congratulations! Your charter flight '.$route->code.$route->flightnum.' was created and has added to your bid list. To view accurate briefing, please genreate a simbrief briefing package.');
            $this->show('core_success.php');
        } else {
            $this->set('message', 'Hey, you have already bidded this route! Happy Flying!');
            $this->show('core_message.php');
        }

        $schedule = SchedulesData::getScheduleDetailed($route->id);
        $this->set('schedule', $schedule);
        $this->render('schedule_briefing.php');


	}

	public function process() {
		$data = $this->post;
		$departure = CharterData::getAirportData($data->depicao);
		$arrival = CharterData::getAirportData($data->arricao);
		$aircraft = OperationsData::GetAircraftInfo($data->aircraft);
		$airlines = OperationsData::getAllAirlines(true);
		if($departure == '') {
			$this->set('message', 'There was an error processing the airports..'.$data->depicao.' was not found in our Database. To
			add additional airports, please contact the admins / webmaster.
			');
			$this->show('core_error.php');
			$this->index();
			return;
		}

		if($arrival == '') {
			$this->set('message', 'There was an error processing the airports..'.$data->arricao.' was not found in our Database. To
			add additional airports, please contact the admins / webmaster.
			');
			$this->show('core_error.php');
			$this->index();
			return;
		}



		$this->set('airlines', $airlines);
		$this->set('departure', $departure);
		$this->set('arrival', $arrival);
		$this->set('aircraft', $aircraft);
		$this->set('distance', round(SchedulesData::distanceBetweenPoints($departure->lattitude, $departure->longitude, $arrival->lattitude, $arrival->longitude)));
		$this->render('charter/process');

	}
}
