<?php
/*
  Donation module for phpVMS
  Author : Leonard Selvaraja, 19.11.2018

  Variables required for the Module :

  Badge URL : https://www.skydream-airlines.com/donor_badge.jpg
    if you are editing the image, just rename it to 'donor_badge.jpg' and save the file.


  Award ID :
    Check with Database, if this is wrong, it won't show the donor badge in the pilot's account.

*/
  class Donate extends CodonModule {


    public function index() {
      $this->render('Donate/index.php');
    }

    public function donate_form() {

      // 15 minutes = 900 seconds.
      $tAN = $tOL + 900;
      $this->set('expire_time', $tAN);
      $this->render('Donate/donate_form.php');
    }

    public function ipn() {

      if($_POST['stripeToken']) {

      $pilotid = Auth::$userinfo->pilotid;
      $message_db  = $_POST['message'];
      $amount =  $_POST['amount'];

        Donation::add_entry($pilotid, $message_db, $amount);

        $message = Auth::$userinfo->firstname.' '.Auth::$userinfo->lastname." has donated ".Config::Get('MONEY_UNIT')."".$amount." to our VA via Stripe! Please check the Stripe account. Message from Pilot : ";
        $message .= $message_db;
        DiscordData::deliver($message, DISCORD_ADMIN_TEXT_CHANNEL);
        $this->set('message', 'Thank you '.Auth::DisplayName().', Your donation was successfull, donor badge was added to your profile! <br> - Team '.SITE_NAME.'');
        $awardID = 4; // THis has to be set by the Admin.
        $pilotID = $pilotid; // This has to be received by $_POST
		    vAwardsData::IssueAwardToPilot($pilotid, $awardID);
        $check = vAwardsData::CheckPilorAward($pilotid, $awardID);
    		if($check)
    		{
    			$this->set('message', 'Thank you '.Auth::DisplayName().', Your donation was successfull! <br> - Team '.SITE_NAME.'');
    			$this->show('core_success.php');

    		} else {

        	vAwardsData::IssueAwardToPilot($pilotID, $awardID);

      		if(DB::errno() != 0)
      		{
      			$this->set('message', 'There was an error issuing the award to your profile, Admins were already notified, you will be contacted soon. We regrest the inconvenience caused!');
				    $this->show('core_error.php');
            DiscordData::deliver(Auth::DisplayName().' has donated an amount and we were unable to issue an award to them. Please check this ASAP');
      		} else {
				      $this->set('message', 'Thank you '.Auth::DisplayName().', Your donation was successfull! <br> - Team '.SITE_NAME.'');
    			    $this->show('core_success.php');
          }
        }

        MainController::Run('Profile', 'view', Auth::$userinfo->pilotid);

      } else {
        die('Unauthorized access!');
      }
    }
  }
