<?php
//simpilotgroup addon module for phpVMS virtual airline system
//
//simpilotgroup addon modules are licenced under the following license:
//Creative Commons Attribution Non-commercial Share Alike (by-nc-sa)
//To view full license text visit http://creativecommons.org/licenses/by-nc-sa/3.0/
//
//@author David Clark (simpilot)
//@copyright Copyright (c) 2009-2010, David Clark
//@license http://creativecommons.org/licenses/by-nc-sa/3.0/

class Events extends CodonModule
{
    public function index()
    {
        $all = EventsData::get_events();
        $allev = array();
        foreach ($all as $a) {

          $allev_loop = array();
          $allev_loop['id'] = $a->id;
          $allev_loop['title'] = $a->title;
          $allev_loop['description'] = $a->description;
          $allev_loop['start'] = date('Y-m-d H:i:s', strtotime($a->date.$a->time));
          $allev_loop['end'] = date('Y-m-d H:i:s', strtotime($a->date));

          $allev[] = $allev_loop;
        }
        $this->set('allevents', json_encode($allev));
        $this->set('events', EventsData::get_upcoming_events());
        $this->set('history', EventsData::get_past_events());
        $this->show('events/events_index.tpl');
    }

    public function s() {
      if(isset($_POST)) {
        $where = $this->post->where;
        $type = $this->post->type;
        $when = $this->post->when;
        $network = $this->post->network;
        $message = $this->post->message;
        //Discord Post.
        $discord_message = '@everyone [EVENT SUGGESTION] there is a new event suggestion from '.Auth::$userinfo->code.Auth::$userinfo->pilotid.' '.Auth::$userinfo->firstname.Auth::$userinfo->lastname.', to be scheduled on '.date(DATE_FORMAT, strtotime($when)).' ('.DATE_FORMAT.'), on
        *EVENT TYPE* : '.$type.',
        *NETWORK* : '.$network.',
        *MESSAGE* : '.htmlspecialchars($message).',
        ';

        DiscordData::deliver($discord_message, DISCORD_ADMIN_TEXT_CHANNEL);
        $this->set('message', 'Your suggestion was sent to the admins! Thank you. You are awesome!');
        $this->set('response', 'success');
        $this->index();
      } else {
        $this->set('message', 'OOP! We were unable to recive your request at the moment. Please email us on '.SITE_EMAIL.', or drop an iMail to one of the staff.');
        $this->set('response', 'error');
        $this->index();
      }
    }

    public function widget()
    {
    	$this->set('events', EventsData::get_upcoming_events());
        $this->show('events/widget.php');
    }

    public function get_event()
    {
        if($id == '') {
        	$id = DB::escape($_GET['id']);
        }

        $this->set('event', EventsData::get_event($id));
        $this->set('signups', EventsData::get_signups($id));
        $this->show('events/events_event.tpl');
    }

    public function view($id)
    {
        if($id == '') {
        	$this->set('message', 'Oops! Event ID is missing');
          $this->show('core_error.php');
          $this->index();
          return;
        }

        $this->set('event', EventsData::get_event($id));
        $this->set('signups', EventsData::get_signups($id));
        $this->show('events/events_event.tpl');
    }
    public function get_past_event()
    {
        $id= DB::escape($_GET[id]);

        $this->set('event', EventsData::get_event($id));
        $this->set('signups', EventsData::get_signups($id));
        $this->show('events/events_past_event.tpl');
    }
    public function signup() //admin
    {
        $eid = DB::escape($_GET[eid]);
        $pid = DB::escape($_GET[pid]);
        $time = DB::escape($_GET[time]);

        EventsData::event_signup($eid, $pid, $time);
        EventsData::add_ranking($pid);

        $this->set('event', EventsData::get_event($eid));
        $this->set('signups', EventsData::get_signups($eid));
        $this->show('events/events_event.tpl');
    }
    public function remove_signup() //public
    {
        $id = $_GET[id];
        $event = $_GET[event];

        EventsData::remove_pilot_signup($id, $event);
        EventsData::subtract_ranking($id);

        $this->set('event', EventsData::get_event($event));
        $this->set('signups', EventsData::get_signups($event));
        $this->show('events/events_event.tpl');
    }
    public function get_rankings()
    {
        $this->set('rankings', EventsData::get_rankings());
        $this->show('events/events_rankings.tpl');
    }
}
