<?php
	class ICSMap extends CodonModule {


		public function index() {
			$this->render('ICSMap/map.php');
		}

		public function full() {
			$this->render('ICSMap/map.php');
			$this->render('ICSMap/list.php');
		}

		public function flightlist() {
			$this->render('ICSMap/list.php');
		}

		public function track($encryptedid = '') {
			if($encryptedid == '') {
				$this->set('message', 'Unique Flight ID required to track flight. Please try again.');
				$this->show('core_error.php');
				$this->flightlist();
				return;
			}


			$decrypt = base64_decode($encryptedid);
			$decrypt = explode('#', $decrypt);
			$flightnum = $decrypt[1];
			$pilotid = $decrypt[0];

			$sql = "SELECT * FROM `phpvms_positionreport` WHERE `pilotid` = '$pilotid' AND `flightnum` = '$flightnum' 	ORDER BY `id` DESC";
			$data = DB::get_results($sql);

			if($data == '') {
				$this->set('message', 'Unique Flight ID is not proper. Please try again.');
				$this->show('core_error.php');
				$this->flightlist();
			} else {
					// print_r();

			$sql = "SELECT id FROM `phpvms_acarsdata` WHERE `pilotid` = '$pilotid' AND `flightnum` = '$flightnum'";
			$acars_flight_id = DB::get_row($sql);
			$acars_flight_id = $acars_flight_id->id;


			$sql = "SELECT * FROM phpvms_positionreport
			WHERE pilotid = '$pilotid' AND flightnum = '$flightnum' AND groundspeed != 0 AND altitude > 0
			ORDER BY id ASC";
			$data_graph = DB::get_results($sql);


			$this->set('acarsdata', ACARSData::get_flight_by_id($acars_flight_id));
			$this->set('posreports', $data);
			$this->set('posreports_g', $data_graph);

				$sql = "DELETE FROM phpvms_positionreport WHERE DATE_SUB(NOW(), INTERVAL 2 DAY) > positiontime";
				$query = DB::query($sql);

			$this->show('ICSMap/trackermap.php');
			}


		}

			public function __construct() {
				CodonEvent::addListener('ICSMap', array('pirep_filed'));
			}

			public function EventListener($eventinfo)
			{
				$eventname = $eventinfo[0]; // Event name
				$eventmodule = $eventinfo[1]; // Class calling it

				if($eventinfo[0] == 'pirep_filed') {
					$query0 = "SELECT * FROM ".TABLE_PREFIX."pireps ORDER BY pirepid DESC LIMIT 1";

					$pirep =	DB::get_row($query0);
					$pirepid = $pirep->pirepid;
					$pilotid = $pirep->pilotid;
					$flightnum = $pirep->code.$pirep->flightnum;

						$sql = "SELECT * FROM `phpvms_positionreport` WHERE `pilotid` = '$pilotid' AND `flightnum` = '$flightnum' 	ORDER BY `id` DESC";
						$xmlArray = DB::get_results($sql);

    					if($xmlArray) {
                        	$xmlArray = array_reverse($xmlArray);
							$i = 0;
								foreach($xmlArray as $position) {
							$potime = '['.date('H:i', $position->positiontime).']';
							$rawdata['points'][] = array(
								'name'          => 'position'.$i,
								'time'			=> (string)$potime,
								'lat'           => (string)$position->latitude,
								'lng'           => (string)$position->longitude,
								'alt'           => (string)$position->altitude,
								'head'          => (string)$position->heading,
								'gs'            => (string)$position->groundspeed,
								'phase'         => (string)$position->phase,
								'warning'       => '1',
								'warningdetail' => '1'
								);
								$i++;
							}
						}

				if(isset($rawdata)) {
					$rawdata = DB::escape(serialize($rawdata));
				} else {
					$rawdata = '';
				}

				$query1 = "UPDATE ".TABLE_PREFIX."pireps SET rawdata = '$rawdata' WHERE pirepid = '$pirepid'";
				DB::query($query1);

				$query2 = "DELETE FROM phpvms_positionreport WHERE pilotid = '$pilotid'";
				DB::query($query2);
				}
			}
	}
