<?php 

class LicenseValidation extends CodonModule {
	
	public static function response($data) {
		header('Content-Type: application/json');
		print_r(json_encode($data));
	}
		
	/**
	 * __construct
	 *
	 * @return void
	 */
	public function __construct() { 
		// This needs to be defined by an ADMIN of icrewsystems. Entering the wrong data will not work.
		define('SITE_KEY', '0513f62c-171a-11ec-9621-0242ac130002');
		define('ICREW_VERSION', '4.3');
		define('ICREW_LICENSE_TYPE', 'UHJlbWl1bQ==');		
		define('ICS_AUTH_KEY', SITE_KEY);
		define('ICS_VERSION', ICREW_VERSION);
		define('ICS_LICENCE_TYPE', ICREW_LICENSE_TYPE);
	}
	
	public function index() {
		$data = array(
			'VA_NAME' => SITE_NAME,
			'VA_URL' => SITE_URL,
			'SITE_KEY' => SITE_KEY,
			'ICREW_VERSION' => ICS_VERSION,
			'ICREW_LICENSE_TYPE' => ICREW_LICENSE_TYPE,
			'PHPVMS_VERSION' => file_get_contents(CORE_PATH.'/version'),
			'PHP_VERSION' => phpversion(),
			'TOTAL_MODULES_COUNT' => count(MainController::getModuleList()),
			'MODULES_LIST' => MainController::getModuleList(),
		);
		
		return self::response($data);
	}
	
	public function modules() {
		return self::response(array('MODULES_LIST' => MainController::getModuleList()));
	}
	
	public static function getKey() {
		$key = DB::get_row("SELECT `authentication_key` FROM `icrewsystems_keys`");
		
		if(!$key) {
			return SITE_KEY;
		} else {
			return $key->authentication_key;
		}
	}
	
	public function updateKey($sitekey, $key, $license_id, $license_version) {
		
		if($_SERVER['SERVER_NAME'] == base64_decode($sitekey)) {
			$find_license = DB::get_row("SELECT * FROM `icrewsystems_keys` WHERE `license_id` = '$license_id'");
			if($find_license == '') {
				$add_key = "INSERT INTO `icrewsystems_keys` (`authentication_key`, `license_id`, `license_version`) VALUES ('$key', '$license_id', '$license_version')";
				// DB::query($add_key);
				$response = array(
					'code' => '200',
					'message' => 'Authentication key has been updated ('.$key.') for the first time',
				);
				
				return self::response($response);
			} else {
				$add_key = "UPDATE `icrewsystems_keys` (`authentication_key`, `license_id`, `license_version`) VALUES ('$key', '$license_id', '$license_version') WHERE `id` = '1'";
				// DB::query($add_key);
				
				$response = array(
					'code' => '200',
					'message' => 'Authentication key has been updated ('.$key.')',
				);
				return self::response($response);
			}
		} else {
			
			$response = array(
				'code' => '401X',
				'message' => 'Error: Invalid SITE_KEY, unable to update authentication key.',
			);
			return self::response($response);
			
		}
		
	}
	
	public function createTable() {
		//Create Table SQL. 
		$sql = 'CREATE TABLE IF NOT EXISTS `icrewsystems_keys` (id INT(6) UNSIGNED AUTO_INCREMENT PRIMARY KEY, authentication_key VARCHAR(100) NOT NULL, license_id VARCHAR(50) NOT NULL, license_version VARCHAR(50), updated_on TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP)';
		DB::query($sql);
		return "Executed Successfully";
	}
}

?>