<?php
/**
* Leave of Absence (LoA) v.1.0 Module
*
* phpVMS Module for pilots to submit a LoA request that is stored in a database
* and an option for staff to view all the LoA requests through the admin panel
* This module is released under the Creative Commons Attribution-NonCommercial-ShareAlike 4.0 International License
* You are free to redistribute and alter this work as you wish but you must keep the original 'copyright' information on all the places it comes in the original work.
* You are not allowed to delete the copyright information and/or gain any profit by adopting or using this module.
*
* @author Sava Markovic - savamarkovic.com
* @copyright Copyright (c) 2016, Sava Markovic
* @link http://www.savamarkovic.com
* @license http://creativecommons.org/licenses/by-nc-sa/4.0/
*/


class LoA extends CodonModule {

    public $title   = "Leave of Absence Request";

    private static $maxDuration  = 61; // Edit this value to set the max LOA Duration

    public function index ()
    {
      if (!Auth::LoggedIn())
      {
        $this->set('message', 'You are not logged in.');
        $this->render('core_error');
      }
      else
      {
        $this->render('loa/loa_index');
      }

    }



    public function submit() {
      date_default_timezone_set('UTC');
      $date_now = time();
      $date_ref = strtotime($this->post->date);
      $days = ($date_ref - $date_now)/(60*60*24);

	 if ($days > self::$maxDuration || $days < 0 || $date_ref < $date_nows)  {
        $this->set('message', 'The requested leave duration exceeds our policy, or you have submitted an invalid request date. Please try again.');
        $this->render('core_error.php');
        $this->render('loa/loa_index');
      }
      else
        if ($this->post->reason == '') {
            $this->set('message', 'You haven\'t specified a reason for your leave of absence.');
            $this->render('core_error.php');
            $this->render('loa/loa_index');
          }
        else {
          $data = array('pilotid' => Auth::$userinfo->pilotid,
                        'start' => $date_now,
                        'end' => $date_ref,
                        'reason' => $this->post->reason);


          if ($pilotid_check > 0) {
            $this->set('message', 'There is already a LoA request with your Pilot ID.');
            $this->render('core_error.php');
            $this->render('loa/loa_index');
          }
          else {
              LoAData::AddLoA($data);
              $this->sendmail($data);
              $this->set('message', 'Your LOA has been filed successfully! We will preserve your Pilot account with it\'s data');
              $this->render('core_success.php');
              $this->render('profile_main.php');
          }
        }
    }

    protected function sendmail($data)
    {
          //send mail to admin
          $email_admin = ADMIN_EMAIL;
          $subject_admin = SITE_NAME . ' LoA Request Submitted';
          $message_admin = "Dear admin, a user has sent a LoA Requst. Check the details below. To edit the LoA request, go to your admin panel. <br>
          Here are the details of your request: <br>
          Pilot ID: {$data['pilotid']} <br>
          Start Date: ".date( DATE_FORMAT, $data['start'])."<br />
          End Date: ".date(DATE_FORMAT,$data['end'])." <br />
          Reason: {$data['reason']}<br>
          Thank you for submitting the request.";
          Util::SendEmail($email_admin, $subject_admin, $message_admin);

          //send mail to pilot
          $subject = SITE_NAME . ' Leave of Absence Confirmation';
        	$email = Auth::$userinfo->email;
          $message = '<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
        <title>Welcome Email</title>
        <meta name="viewport" content="width=device-width" />
        <style type="text/css">
            @media only screen and (max-width: 550px), screen and (max-device-width: 550px) {
                body[yahoo] .buttonwrapper { background-color: transparent !important; }
                body[yahoo] .button { padding: 0 !important; }
                body[yahoo] .button a { background-color: #349ee5; padding: 15px 25px !important; }
            }

            @media only screen and (min-device-width: 601px) {
                .content { width: 600px !important; }
                .col387 { width: 387px !important; }
            }
        </style>
    </head>
    <body bgcolor="#252d2f" style="margin: 0; padding: 0;" yahoo="fix">
        <!--[if (gte mso 9)|(IE)]>
        <table width="600" align="center" cellpadding="0" cellspacing="0" border="0">
          <tr>
            <td>
        <![endif]-->
        <table align="center" border="0" cellpadding="0" cellspacing="0" style="border-collapse: collapse; width: 100%; max-width: 600px;" class="content">
            <tr>
                <td align="center" bgcolor="#cccccc" style="padding: 25px 20px 20px 20px; color: #ffffff; font-family: Arial, sans-serif; font-size: 26px;">
                    <img src="'.SITE_URL.'/iCrew/ics_logo.png" alt="RJ VIRTUAL" width="auto;" height="120" style="display:block;" />
                </td>
            </tr>
            <tr>
                <td align="left" bgcolor="#ffffff" style="padding: 40px 20px 0 20px; color: #555555; font-family: Arial, sans-serif; font-size: 18px; line-height: 30px;">
                    <b>Hey '.$pilot->firstname.' '.$pilot->lastname.',</b>
                </td>
            </tr>
            <tr>
                <td align="left" bgcolor="#ffffff" style="padding: 0 20px 40px 20px; color: #777777; font-family: Arial, sans-serif; font-size: 14px;  border-bottom: 1px solid #f6f6f6;">
                    Your leave of absence request has been submitted and processed by our system. We will continue to preserve your current pilot account for the requested period. However, pleae know that you are welcome back to fly at anytime.<br>
        			Details of your LOA are as follows : <br><br>
        			Pilot ID: '.$data['pilotid'].' <br>
        			Start Date: '.date( DATE_FORMAT, $data['start']).'<br />
        			End Date: '.date(DATE_FORMAT,$data['end']).' <br />
        			Reason of Leave: '.$data['reason'].'<br>
        			Hope to see you around soon
                    <br><br>
                    Love,<br>
                    <b>AdminBot.</b>
                </td>
            </tr>

            <tr>
                <td align="center" bgcolor="#ffffff" style="padding: 0 20px 40px 20px; color: #777777; font-family: Arial, sans-serif; font-size: 12px;  border-bottom: 1px solid #f6f6f6;">
                    <br>
                    <i>This is an AI generated e-mail. For human support, contact ceo@'.ADMIN_EMAIL.'
                </td>
            </tr>
            <tr>
                <td align="center" bgcolor="#e9e9e9" style="padding: 12px 10px 12px 10px; color: #888888; font-family: Arial, sans-serif; font-size: 12px; line-height: 18px;">
                    <b><?php echo SITE_NAME; ?></b> <br>Powered by iCrew v4.3 <i>Premium</i> &bull; Crafted by icrewsystems

                </td>
            </tr>
            <tr>
                <td style="padding: 15px 10px 15px 10px;">
                    <table border="0" cellpadding="0" cellspacing="0" width="100%">
                        <tr>
                            <td align="center" width="100%" style="color: #999999; font-family: Arial, sans-serif; font-size: 12px;">
                                '.SITE_NAME.'
                            </td>
                        </tr>
                    </table>
                </td>
            </tr>
        </table>
        <!--[if (gte mso 9)|(IE)]>
                </td>
            </tr>
        </table>
        <![endif]-->
    </body>
</html>
';
          Util::SendEmail($email, $subject, $message);
     }


}
