<?php
/**
 * phpVMS - Virtual Airline Administration Software
 * Copyright (c) 2008 Nabeel Shahzad
 * For more information, visit www.phpvms.net
 *	Forums: http://www.phpvms.net/forum
 *	Documentation: http://www.phpvms.net/docs
 *
 * phpVMS is licenced under the following license:
 *   Creative Commons Attribution Non-commercial Share Alike (by-nc-sa)
 *   View license.txt in the root, or visit http://creativecommons.org/licenses/by-nc-sa/3.0/
 *
 * @author Nabeel Shahzad
 * @copyright Copyright (c) 2008, Nabeel Shahzad
 * @link http://www.phpvms.net
 */

class Login extends CodonModule
{
	public function __construct()
	{
		parent::__construct();
	}

	public function index()
	{
		$this->login();
	}

	public function login($redir='')
	{
		if(Auth::LoggedIn() == true) {
			$this->render('login_already.tpl');
			return;
		}

		$this->set('redir', $redir);
	
		if(isset($this->post->action) && $this->post->action == 'login') {
			echo "Has POST methods, processing login for " . $this->post->email;
			$this->ProcessLogin();
		} else {
			$this->render('login_form.tpl');
		}
	}

	public function logout()
	{
		Auth::LogOut();
		$this->set('redir', SITE_URL);
		$this->render('login_complete.tpl');
	}

	public function forgotpassword()
	{
		if($this->post->action == 'resetpass') {
			$this->ResetPassword();
			return;
		}

		$this->render('login_forgotpassword.tpl');
	}

/*	public function ResetPassword()
	{
		$email = $this->post->email;

		if(!$email) {
			return false;
		} else  {

			$pilot = PilotData::GetPilotByEmail($email);

			if(!$pilot) {
				$this->render('login_notfound.tpl');
				return;
			}

			$newpw = substr(md5(date('mdYhs')), 0, 6);

			RegistrationData::ChangePassword($pilot->pilotid, $newpw);

			$this->set('firstname', $pilot->firstname);
			$this->set('lastname', $pilot->lastname);
			$this->set('newpw', $newpw);

			$message = Template::GetTemplate('email_lostpassword.tpl', true);

			Util::SendEmail($pilot->email, 'Password Reset', $message);

			$this->render('login_passwordreset.tpl');
		}
	}
	*/

	public function ResetPassword()
	/*Edited by Leonard to send Random Numbers

  ALTER TABLE `phpvms_pilots` CHANGE `password_reset` `password_reset` VARCHAR(50) NULL DEFAULT NULL;

  */
	{
		$email = $this->post->email;

		if(!$email) {
			return false;
		} else  {

			$pilot = PilotData::GetPilotByEmail($email);

			if(!$pilot) {
				$this->render('login_notfound.tpl');
				return;
			}

			/*
			$newpw = substr(md5(date('mdYhs')), 0, 6);
			*/

			$characters = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
    		for ($i = 0; $i < 30; $i++) {
        		$randomString .= $characters[rand(0, strlen($characters) - 1)];
    		}

    		$newpw = $randomString;




			/*RegistrationData::ChangePassword($pilot->pilotid, $newpw);*/

			$this->set('firstname', $pilot->firstname);
			$this->set('lastname', $pilot->lastname);
			$this->set('pid', $pilot->pilotid);
			$this->set('newpw', $newpw);

			ICSData::setRandomCode($pilot->pilotid, $randomString);
			$message = Template::GetTemplate('email_lostpassword.tpl', true);

			Util::SendEmail($pilot->email, '[iCrew] '.SITE_NAME.' | Password reset code ', $message);

			$this->render('login_passwordreset.tpl');
		}
	}

	public function resetauth() {
				  /// IF you're wondering why module is not working, you must first amend the
		$this->render('login_passauth.php');
	}

	public function authpassreset() {

		$authcode = $this->post->authcode;
		$newpassword1 = $this->post->newpassword1;
		$newpassword2 = $this->post->newpassword2;
		$pid = $this->post->pid;

		$pilot = ICSData::getPilotData($authcode);
		if($authcode != $pilot->password_reset) {
			$this->set('message', 'Authentication Code Invalid. Please get a new authentication code <a href="'.SITE_URL.'/index.php/login/forgotpassword">here </a>.');
			$this->show('core_error.php');
			$this->forgotpassword();

		}


		else if($newpassword1 != $newpassword2) {
			$this->set('message', 'Passwords donot match. Please re-try');
			$this->render('core_error.php');

		}
		else if($newpassword1 == '' || $newpassword2 == '') {
				$this->set('message', 'Passwords cannot be blank. Please re-try');
				$this->render('core_error.php');


		}
		else {
			$mail_message = Template::GetTemplate('login_pass_has_reset.tpl', true);

			Util::SendEmail($pilot->email, 'Password has been reset', $mail_message);
			ICSData::ChangePassword($pilot->pilotid, $newpassword2);
			ICSData::DestroyAuth($pilot->pilotid);
			$this->set('message', 'Your password was reset!');
			$this->show('core_success.php');
			$this->index();
		}



	}
	public function ProcessLogin()
	{
		$email = $this->post->email;
		$password = $this->post->password;

		if($email == '' || $password == '')
		{
			$this->set('message', 'You must fill out both your username and password');
			$this->render('login_form.tpl');
			return false;
		}

		if(!Auth::ProcessLogin($email, $password))
		{
			$this->set('message', Auth::$error_message);
			$this->render('login_form.tpl');
			return false;
		} else {

			if(Auth::$pilot->confirmed == PILOT_PENDING) {
				$this->render('login_unconfirmed.tpl');
				Auth::LogOut();

				// show error
			} elseif(Auth::$pilot->confirmed == PILOT_REJECTED) {
				$this->render('login_rejected.tpl');
				Auth::LogOut();
			} else {
				$pilotid = Auth::$pilot->pilotid;
				$session_id = Auth::$session_id;

				# If they choose to be "remembered", then assign a cookie
				if($this->post->remember == 'on') {
					$cookie = "{$session_id}|{$pilotid}|{$_SERVER['REMOTE_ADDR']}";
					$res = setrawcookie(VMS_AUTH_COOKIE, $cookie, time() + Config::Get('SESSION_LOGIN_TIME'), '/');
				}
					
				
				PilotData::updateLogin($pilotid);
				
				
				CodonEvent::Dispatch('login_success', 'Login', $pilotid);

				$this->post->redir = str_replace('index.php/', '', $this->post->redir);
				header('Location: '.url('/'.$this->post->redir));
				// $this->set('message', 'Loggedin');
				// $this->show('core_success.php');
			}

			return;
		}
	}
}
