<?php 
	class Passport extends CodonModule {
		
		
		public function view($id) {
			
			// If there is no Pilot ID passed
			if($id != '') {
				$pilot = PilotData::getPilotData($id);
				$this->set('pilot', $pilot);
			} else {
				$this->set('message', 'No Pilot ID Specified');
				$this->show('core_error.php');
				// $this->redirect(url('Profile'));
				$this->render('profile_main.php');
				return;
			}
			
			// Fetch data from PIREPData class. 
			// Categorize with country per pirep.
			// Set output to countries, Dates, Flight Number. 
			
			$pireps = PassportData::getAllReportsForPilot($id);
			
			$home_country = Countries::getCountryName($pilot->location);
			
			// Get all airports from that country 
				$get_hca = AirportData::getAirportCountry($home_country);
				$home_country_airports = array();
				
				foreach ($get_hca as $hca) {
					array_push($home_country_airports, $hca->icao); 
				}
				
				// ^^ Now all the Home country airports, which are to be ignored are in One Array!
				
				
			$countries = array();
			
				if(count($pireps) == 0) {
				 	$this->set('message', 'Passport unused, Pilot has not flown anywhere yet!');
					$this->show('core_error.php');
					// $this->redirect(url('Profile'));
					$this->render('profile_main.php');
					return;
				} else {
					
					$this->set('PIREPs_from_home_country', 0);
					foreach ($pireps as $pirep) {
						if(in_array($pirep->depicao, $home_country_airports) || in_array($pirep->arricao, $home_country_airports)) {
							
							// Do nothing, cuz the passport will be issued in the Pilot's Origin country right? 
							// Or atleast, for this module, we will consider so.
							$PIREPs_from_home_country++;
							
						} else {
							// Getting the country details 
							
							// Since there is both Departure & Arrival country into play, We will disregard 
							// the PIREPs which have the Same Deprature & Arrival Countries, because that doesn't count 
							// in the passport IRL.
							// 
							
							
							$dep = OperationsData::getAirportInfo($pirep->depicao);
							$dep_country = $dep->country;
							$arr = OperationsData::getAirportInfo($pirep->arricao);
							$arr_country = $arr->country;
							
							if($dep_country == $arr_country) {
								// IGNORE THIS PART
							} else {
								// All filterations done, now just add the countries into the Array!
								$pirep_date = date(DATE_FORMAT, $pirep->submitdate);
								array_push($countries, $arr_country.','.strtoupper($pirep_date)); // Because we dont add the departure country into the Passport. Only Arrival
								
							}
							
							
							
						}
					}	
				}
			
			$this->set('countries', $countries);
			$this->set('home_country_airports', $PIREPs_from_home_country);
			$this->render('passport/index.php');
		}
	}