<?php
/**
 * @author Manuel Seiwald
 * @copyright Copyright (c) 2014, Crazycreatives.com
 * @http://www.crazycreatives.com
 * @license http://creativecommons.org/licenses/by-nc-nd/4.0/
 * @ v1.00
 */


// GLOBAL SETTINGS

//Update Route in Schedules Table with Route entered by the Pilot (Set to 1 to enbale)
$routeupdate = 0;


class cACARS_Free extends CodonModule
{

public function PilotLogin()
{
$version = 1.00;
$moduleversion = DB::escape($this->post->moduleversion);
$pilotid = DB::escape($this->post->pilotid);
$password = DB::escape($this->post->password);
if(!is_numeric($pilotid))
					{
preg_match('/^([A-Za-z]*)(\d*)/', $pilotid, $matches);
						$pilot_code = $matches[1];
						$pilotid = intval($matches[2]);
					}
					else
					{
						$pilotid = DB::escape($this->post->pilotid);
					}
					$pilotid = $pilotid - Config::Get('PILOTID_OFFSET');

if($version != $moduleversion)
{
	echo "Wrong Module Version on VA Site!";
	return;
}

$confirm = Auth::ProcessLogin($this->post->pilotid, $password);
					if ($confirm)
					{
$pilotdata = PilotData::getPilotData($pilotid);
DiscordData::deliver($pilotdata->firstname.' has connected to cACARS Free.', DISCORD_ADMIN_TEXT_CHANNEL);
 $xml = new SimpleXMLElement('<Information xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:xsd="http://www.w3.org/2001/XMLSchema" />');
 $xml->addChild('PilRetCode', $pilotdata->code);
 $xml->addChild('DisplayId', str_pad(PilotData::parsePilotID($pilotdata->pilotid), Config::Get('PILOTID_LENGTH'), '0', STR_PAD_LEFT));
 $xml->addChild('PilRetId', $pilotdata->pilotid);
 $xml->addChild('PilRetFirstname', $pilotdata->firstname);
 $xml->addChild('PilRetLastname', $pilotdata->lastname);
 $xml->addChild('PilRetRank', $pilotdata->rank);
 $xml->addChild('PilRetTotalhours', $pilotdata->totalhours);
 $xml->addChild('PilRetTotalflights', $pilotdata->totalflights);

Header('Content-type: text/xml');
echo $xml->asXML();

					}
					else
					{
						echo "Login Error!";
					}
}


public function getallmybids($pilotid)
	{

		$bids = SchedulesData::getBids($pilotid);


if($bids)
{
	 $xml = new SimpleXMLElement("<BidsData />");
	foreach($bids as $row)
	{

		     	$Flight = $xml->addChild('Flight');
				$Flight->addChild('id', $row->id);
				$Flight->addChild('FlightNr', $row->code.$row->flightnum);
				$Flight->addChild('Origin', $row->depicao);
				$Flight->addChild('Deptime', $row->deptime);
				$Flight->addChild('Destination', $row->arricao);
				$Flight->addChild('Arrtime', $row->arrtime);
				$Flight->addChild('Flighttime', $row->flighttime);
				$Flight->addChild('Aircraft', $row->aircraft);
			}
			header('Content-type: text/xml');
			echo $xml->asXML();
		}


	}




public function getselectedflight()
{
$routeid = DB::escape($this->post->routeid);

$sql1 = "SELECT s.*, a.name as acname, a.registration as acregistration, a.icao as acicao, a.range as acrange, a.cruise as accruise, a.maxpax as acmaxpax, a.maxcargo as acmaxcargo, a.weight as acweight, dep.name as depname, dep.country as depcountry, dep.lat as deplat, dep.lng as deplng, arr.country as arrcountry, arr.lat as arrlat, arr.lng as arrlng, arr.name as arrname FROM ".TABLE_PREFIX."schedules s
LEFT JOIN ".TABLE_PREFIX."aircraft a ON a.id = s.aircraft
LEFT JOIN ".TABLE_PREFIX."airports dep ON dep.icao = s.depicao
LEFT JOIN ".TABLE_PREFIX."airports arr ON arr.icao = s.arricao
WHERE s.id = '$routeid'";
$result = DB::get_row($sql1);
if($result){
if($result->flighttype == 'C')
{
$actualload = round($result->acmaxcargo * (rand(66,99) / 100));
}
else
{
$actualload = round($result->acmaxpax * (rand(66,99) / 100));
}


$xml = new SimpleXMLElement('<Information xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:xsd="http://www.w3.org/2001/XMLSchema" />');
 $xml->addChild('SelCode', $result->code);
 $xml->addChild('SelFlightnum', $result->flightnum);
 $xml->addChild('SelDepicao', $result->depicao);
 $xml->addChild('SelDepname', str_replace('<', '%', str_replace('>', '*', str_replace('&', '+', ($result->depname)))));
 $xml->addChild('SelDeptime', $result->deptime);
 $xml->addChild('SelDeplat', $result->deplat);
 $xml->addChild('SelDeplng', $result->deplng);
 $xml->addChild('SelDepcountry', $result->depcountry);
 $xml->addChild('SelArrlat', $result->arrlat);
 $xml->addChild('SelArrlng', $result->arrlng);
 $xml->addChild('SelArrcountry', str_replace('<', '%', str_replace('>', '*', str_replace('&', '+', ($result->arrcountry)))));
 $xml->addChild('SelArricao', $result->arricao);
 $xml->addChild('SelArrname', str_replace('<', '%', str_replace('>', '*', str_replace('&', '+', ($result->arrname)))));
 $xml->addChild('SelArrtime', $result->arrtime);
 $xml->addChild('SelFlighttime', $result->flighttime);
 $xml->addChild('SelDistance', $result->distance);
 $xml->addChild('SelFlightlevel', $result->flightlevel);
 $xml->addChild('SelFlighttype', $result->flighttype);
 $xml->addChild('SelPrice', $result->price);
 $xml->addChild('SelRoute', $result->route);
 $xml->addChild('SelNotes', str_replace('<', '%', str_replace('>', '*', str_replace('&', '+', ($result->notes)))));
 $xml->addChild('SelAircraft', $result->aircraft);
 $xml->addChild('SelAcicao', $result->acicao);
 $xml->addChild('SelAcname', $result->acname);
 $xml->addChild('SelAcrange', $result->acrange);
 $xml->addChild('SelAcweight', $result->acweight);
 $xml->addChild('SelAccruise', $result->accruise);
 $xml->addChild('SelAcregistration', $result->acregistration);
 $xml->addChild('SelAcmaxpax', $result->acmaxpax);
 $xml->addChild('SelAcmaxcargo', $result->acmaxcargo);
 $xml->addChild('SelActload', $actualload);
Header('Content-type: text/xml');
echo $xml->asXML();
					}
					else
					{
						echo "No Data loaded!";
}

}

public function getmetars()
{
$depicao = DB::escape($this->post->depicao);
$arricao = DB::escape($this->post->arricao);
$depmetar = self::metarlookup($depicao);
$arrmetar = self::metarlookup($arricao);

$xml = new SimpleXMLElement('<Information xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:xsd="http://www.w3.org/2001/XMLSchema" />');
 $xml->addChild('Depmetar', $depmetar);
 $xml->addChild('Arrmetar', $arrmetar);
Header('Content-type: text/xml');
echo $xml->asXML();
}


public function metarlookup($icao)
{
$metar = $_POST['metar'];
$url = 'http://metar.vatsim.net/'.$icao.'';
$page = file_get_contents($url);
return $page;
}

public function posreport()
{
$pilotid = DB::escape($this->post->pilotid);
$flightnum = DB::escape($this->post->flightnum);
$pilotname = DB::escape($this->post->pilotname);
$aircraft = DB::escape($this->post->aircraft);
$lat = DB::escape($this->post->lat);
$lon = DB::escape($this->post->lng);
$heading = DB::escape($this->post->heading);
$alt = DB::escape($this->post->altitude);
$gs = DB::escape($this->post->gs);
$depicao = DB::escape($this->post->depicao);
$arricao = DB::escape($this->post->arricao);
$deptime = DB::escape($this->post->deptime);
$route = DB::escape($this->post->route);
$phasedetail = DB::escape($this->post->phasedetail);


$lat = str_replace(",", ".", $lat);
$lon = str_replace(",", ".", $lon);

$depapt = OperationsData::GetAirportInfo($depicao);
$arrapt = OperationsData::GetAirportInfo($arricao);
$dist_remain = round(SchedulesData::distanceBetweenPoints(
$lat, $lon,	$arrapt->lat, $arrapt->lng));

if($gs > 0)
{
$Minutes = round($dist_remain / $gs * 60);
$time_remain = self::ConvertTime($Minutes);
}
else
{
$time_remain = '00:00';
}

					$fields = array(
						'pilotid'        =>$pilotid,
						'flightnum'      =>$flightnum,
						'pilotname'      =>$pilotname,
						'aircraft'       =>$aircraft,
						'lat'            =>$lat,
						'lng'            =>$lon,
						'heading'        =>$heading,
						'alt'            =>$alt,
						'gs'             =>$gs,
						'depicao'        =>$depicao,
						'arricao'        =>$arricao,
						'deptime'        =>$deptime,
						'arrtime'        =>'',
						'route'          =>$route,
						'distremain'     =>$dist_remain,
						'timeremaining'  =>$time_remain,
						'phasedetail'    =>$phasedetail,
						'online'         =>'',
						'client'         =>'cACARS',
						);

					ACARSData::UpdateFlightData($pilotid, $fields);

					echo "1";
}

public function ConvertTime($Minu)
	{
		if ($Minu < 0)
		{
			$Min = Abs($Minu);
		}
		else
		{
			$Min = $Minu;
		}
		$thehours = Floor($Min / 60);
		$Minu = ($Min - ($thehours * 60)) / 100;
		$tHours = $thehours + $Minu;
		if ($Minu < 0)
		{
			$tHours = $tHours * (-1);
		}
		$aHours = explode(".", $tHours);
		$thehours = $aHours[0];
		if (empty($aHours[1]))
		{
			$aHours[1] = "00";
		}
		$Minu = $aHours[1];
		if (strlen($Minu) < 2)
		{
			$Minu = $Minu ."0";
		}
		$tHours = $thehours .":". $Minu;
		return $tHours;
	}

public function filepirep()
{
global $routeupdate;

$pilotid = DB::escape($this->post->pilotid);
$code = DB::escape($this->post->code);
$flightnum = DB::escape($this->post->flightnum);
$aircraft = DB::escape($this->post->aircraft);
$flighttime = DB::escape($this->post->flighttime);
$flighttype = DB::escape($this->post->flighttype);
$comments = DB::escape($this->post->comment);
$fuelused = DB::escape($this->post->fuelused);
$route = DB::escape($this->post->route);
$load = DB::escape($this->post->load);
$fllog = DB::escape($this->post->fllog);
$landingrate = DB::escape($this->post->landingrate);
$depicao = DB::escape($this->post->depicao);
$arricao = DB::escape($this->post->arricao);


					$pilotid = PilotData::parsePilotID($pilotid);


				$fllog = str_replace('\r\n', '*', $fllog);

					if(!OperationsData::GetAirportInfo($depicao))
					{
						OperationsData::RetrieveAirportInfo($depicao);
					}

					if(!OperationsData::GetAirportInfo($arricao))
					{
						OperationsData::RetrieveAirportInfo($arricao);
					}



					if(Config::Get('LiquidUnit') == '1')
					{
						$fuelused = $fuelused * 6.84;
					}

					elseif(Config::Get('LiquidUnit') == '2')
					{
						$fuelused = $fuelused * .45359237;
					}

					if($routeupdate == 1)
					{
				$query = "UPDATE ".TABLE_PREFIX."schedules SET route = '$route' WHERE code = '$code' AND flightnum != '$flightnum'";
		         DB::query($query);
					}

					$data = array(
						'pilotid'			=>$pilotid,
						'code'				=>$code,
						'flightnum'			=>$flightnum,
						'depicao'			=>$depicao,
						'arricao'			=>$arricao,
						'aircraft'			=>$aircraft,
						'flighttime'		=>$flighttime,
						'flighttype'		=>$flighttype,
						'submitdate'		=>'UTC_TIMESTAMP()',
						'comment'			=>$comments,
						'fuelused'			=>$fuelused,
						'route'          	=>$route,
						'source'			=>'cACARS',
						'load'				=>$load,
						'landingrate'		=>$landingrate,
						'log'				=>$fllog
					);


					DiscordData::deliver($pilotdata->firstname.' has initated PIREP prefile sequence. Waiting for PIREP to be filed on VA Website.', DISCORD_ADMIN_TEXT_CHANNEL);
					$result = ACARSData::FilePIREP($pilotid, $data);

					if ($result)
					{
						echo "1";
					}
					else
					{
						echo "2";

					}


}




}
?>
