<?php
{
    Config::Set('PILOT_STATUS_TYPES', array(

    /* DO NOT CHANGE THIS ACTIVE NUMBER OR STATUS OR THINGS WILL BREAK!!! */
    0 => array(
        'name' => 'Active',             # The title to show in the dropdown
        'message' => '',                # Message to show if they can't login (below is false)
        'default' => true,              # Should this be their default status?
        'canlogin' => true,             # Are they allowed to log in
        'active' => true,               # Are they an active pilot?
        'autoretire' => false,          # Use this status for the auto-retire functionality
        'group_add' => array(           # ID or name of the group this user is added to with this status
            'Active Pilots',
        ),
        'group_remove' => array(        # ID or name of the groups this user is removed from with this status
            'Inactive Pilots',
        ),
    ),

    /* DO NOT CHANGE THIS INACTIVE NUMBER OR STATUS OR THINGS WILL BREAK!!! */
    1 => array(
        'name' => 'Inactive',
        'message' => 'Your account was marked inactive',
        'default' => false,
        'canlogin' => false,
        'active' => false,
        'autoretire' => false,
        'group_add' => array(
            'Inactive Pilots',
        ),
        'group_remove' => array(
            'Active Pilots',
        ),
    ),

    2 => array(
        'name' => 'Banned',
        'message' => 'Your account is banned, please contact an admin!',
        'default' => false,
        'canlogin' => false,
        'active' => false,
        'autoretire' => false,
        'group_add' => array(
            'Inactive Pilots',
        ),
        'group_remove' => array(
            'Active Pilots',
        ),
    ),

    3 => array(
        'name' => 'On Leave',
        'message' => 'You have been marked as on leave',
        'default' => false,
        'canlogin' => true,
        'active' => false,
        'autoretire' => true,
        'group_add' => array(
            'Inactive Pilots',
        ),
        'group_remove' => array(
            'Active Pilots',
        ),
    ),
));
}
?>
<div id="ispilot" name="1" class="cc_hubadm_content">
<div class="cc_hubadm_box cc_hubadm_full">
    <div class="cc_hubadm_boxtitle">Edit Pilot <?php echo PilotData::getPilotCode($pil->code, $pil->pilotid)." - ".$pil->firstname." ".$pil->lastname; ?></div>
<form method="post" action="<?php echo SITE_URL ?>/<?php echo $mloc ?>.php/HubOps/editpilot">
  <table class="cc_hubadm_tablea">
    <tr>
        <td width="30%">Avatar</td>
        <td><?php
		$pilotcode = PilotData::GetPilotCode($pil->code, $pil->pilotid);

		if(!file_exists(SITE_ROOT.AVATAR_PATH.'/'.$pilotcode.'.png')) {
			echo 'None selected';
		} else {
		?>
			<img src="<?php	echo SITE_URL.AVATAR_PATH.'/'.$pilotcode.'.png';?>" />
		<?php
		}
		?></td>
      </tr>
      <tr>
        <td>Pilot ID</td>
        <td><?php echo $pilotcode ?></td>
      </tr>
	  <tr>
        <td>First Name</td>
        <td><input type="text" name="firstname" value="<?php echo $pil->firstname;?>" /></td>
      </tr>
	  <tr>
        <td>Last Name</td>
        <td><input type="text" name="lastname" value="<?php echo $pil->lastname;?>" /></td>
      </tr>
    <tr>
        <td>Email Address</td>
        <td><input type="text" name="email" value="<?php echo $pil->email;?>" /></td>
      </tr>
    <tr>
        <td>Airline</td>
        <td><select name="code">
		<?php
		$allairlines = OperationsData::GetAllAirlines();
		foreach($allairlines as $airline) {
			if($pil->code == $airline->code)
				$sel =  ' selected';
			else
				$sel = '';
				
			echo '<option value="'.$airline->code.'" '
						.$sel.'>'.$airline->name.'</option>';
		}
		?>	
		</select></td>
      </tr>
    <tr>
        <td>Location</td>
        <td><select name="location">
			<?php
			foreach($countries as $countryCode=>$countryName) {
				if($pil->location == $countryCode)
					$sel = 'selected="selected"';
				else	
					$sel = '';
				
				echo '<option value="'.$countryCode.'" '.$sel.'>'.$countryName.'</option>';
			}
					?>
		</select></td>
      </tr>
    <tr>
        <td>Hub</td>
        <td><select name="hub">
		<?php
		$allhubs = OperationsData::GetAllHubs();
		foreach($allhubs as $hub) {
			if($pil->hub == $hub->icao)
				$sel = ' selected';
			else
				$sel = '';
			
			echo '<option value="'.$hub->icao.'" '.$sel.'>'.$hub->icao.' - ' . $hub->name .'</option>';
		}
		?>	
		</select></td>
      </tr>
	  <tr>
        <td>Current Rank</td>
        <td><?php
	if(Config::Get('RANKS_AUTOCALCULATE') == false) {
		$allranks = RanksData::GetAllRanks();
		echo '<select name="rank">';
		
		foreach($allranks as $rank) {
            $selected = ($pil->rank == $rank->rank) ? "selected=\"selected\"": '';
			echo "<option value=\"{$rank->rankid}\" {$selected}>{$rank->rank}</option>";
		}
		echo '</select>';
	} else {
		echo $pil->rank;
	}
	?></td>
      </tr>
	  <tr>
        <td>Date Joined</td>
        <td><?php echo date(DATE_FORMAT, strtotime($pil->joindate));?></td>
      </tr>
	  <tr>
        <td>Last Login</td>
        <td><?php echo date(DATE_FORMAT, strtotime($pil->lastlogin));?></td>
      </tr>
	  <tr>
        <td>Last Flight</td>
        <td><?php echo date(DATE_FORMAT, strtotime($pil->lastpirep));?></td>
      </tr>
	  <tr>
        <td>Total Flights</td>
        <td><?php echo $pil->totalflights;?>
		  <input type="hidden" name="totalflights" value="<?php echo $pil->totalhours;?>" /></td>
      </tr>
	  <tr>
        <td>Total Hours</td>
        <td><?php echo $pil->totalhours;?>
		<input type="hidden" name="totalhours" value="<?php echo $pil->totalhours;?>" /></td>
      </tr>
	  <tr>
        <td>Transfer Hours</td>
        <td><input type="text" name="transferhours" value="<?php echo $pil->transferhours;?>" /></td>
      </tr>
	  <tr>
        <td>Total Pay</td>
        <td><input type="text" name="totalpay" value="<?php echo $pil->totalpay;?>" /></td>
      </tr>
	  <tr>
        <td>Pay Adjustment</td>
        <td><input type="text" name="payadjust" value="<?php echo $pil->payadjust;?>" /></td>
      </tr>
	  <tr>
        <td>Current Location</td>
        <td><?php echo $location; ?></td>
      </tr>
	  <tr>
        <td>Pilot active?</td>
        <td><select name="retired">
        <?php 
    
        $pilotStatuses = Config::get('PILOT_STATUS_TYPES');
        foreach($pilotStatuses as $id => $info) {
            if($pil->retired == $id) {
                $active = 'selected';
            } else {
                $active = '';
            }
            
            echo '<option value="'.$id.'" '.$active.'>'.$info['name'].'</option>';
        }
        
		?>
		</select>
        
        <input type="checkbox" name="resend_email" value="true" />Check to resend the welcome email</td>
      </tr>
	  <tr>
        <td>Admin Comment</td>
        <td><textarea style="width: 100%; height: 70px;" name="comment"><?php echo $pil->comment;?></textarea></td>
      </tr>
   <?php
if($customfields) {
	foreach($customfields as $field) {
?>
	<tr>
		<td><?php echo $field->title;?></td>
		<td>
		<?php
		if($field->type == 'dropdown') {
			
			echo "<select name=\"{$field->fieldname}\">";
			$values = explode(',', $field->fieldvalues);
		
			if(is_array($values)) {						
				foreach($values as $val) {
					$sel = ($field->value === $val) ? 'sel="selected"' : '';
					
					$val = trim($val);
					echo "<option value=\"{$val}\" {$sel} >{$val}</option>";
				}
			}
			
			echo '</select>';
		} elseif($field->type == 'textarea') {
			echo '<textarea name="'.$field->fieldname.'" style="width: 400px; height: 100px" class="customfield_textarea">'.$field->value.'</textarea>';
		} else {
			echo '<input type="text" name="'.$field->fieldname.'" value="'.$field->value.'" />';
		}
		?>
		</td>
	</tr>
<?php
	}
}
?>
   <tr>
	   <td></td>
		<td>
			<input type="hidden" name="pilotid" value="<?php echo $pil->pilotid;?>" />
			<input type="submit" name="submit" class="cc_hubadm_greenbutt" value="Save Changes" />
			<div id="results"></div>
		</td>
	</tr>
    </table>
</form>
</div>
	
	<div class="cc_hubadm_box cc_hubadm_full">
    <div class="cc_hubadm_boxtitle"><?php echo PilotData::getPilotCode($pil->code, $pil->pilotid)." - ".$pil->firstname." ".$pil->lastname; ?>'s PIREPs</div>
	<div id="pilotspireps"><?php
        Template::Show('hubops/pireplist.tpl');
    ?>
	</div>
		</div>
	
</div>

