<?php
{
    Config::Set('PILOT_STATUS_TYPES', array(

    /* DO NOT CHANGE THIS ACTIVE NUMBER OR STATUS OR THINGS WILL BREAK!!! */
    0 => array(
        'name' => 'Active',             # The title to show in the dropdown
        'message' => '',                # Message to show if they can't login (below is false)
        'default' => true,              # Should this be their default status?
        'canlogin' => true,             # Are they allowed to log in
        'active' => true,               # Are they an active pilot?
        'autoretire' => false,          # Use this status for the auto-retire functionality
        'group_add' => array(           # ID or name of the group this user is added to with this status
            'Active Pilots',
        ),
        'group_remove' => array(        # ID or name of the groups this user is removed from with this status
            'Inactive Pilots',
        ),
    ),

    /* DO NOT CHANGE THIS INACTIVE NUMBER OR STATUS OR THINGS WILL BREAK!!! */
    1 => array(
        'name' => 'Inactive',
        'message' => 'Your account was marked inactive',
        'default' => false,
        'canlogin' => false,
        'active' => false,
        'autoretire' => false,
        'group_add' => array(
            'Inactive Pilots',
        ),
        'group_remove' => array(
            'Active Pilots',
        ),
    ),

    2 => array(
        'name' => 'Banned',
        'message' => 'Your account is banned, please contact an admin!',
        'default' => false,
        'canlogin' => false,
        'active' => false,
        'autoretire' => false,
        'group_add' => array(
            'Inactive Pilots',
        ),
        'group_remove' => array(
            'Active Pilots',
        ),
    ),

    3 => array(
        'name' => 'On Leave',
        'message' => 'You have been marked as on leave',
        'default' => false,
        'canlogin' => true,
        'active' => false,
        'autoretire' => true,
        'group_add' => array(
            'Inactive Pilots',
        ),
        'group_remove' => array(
            'Active Pilots',
        ),
    ),
));
}
?>

<div class="cc_hubadm_content">
    <?php if($penpilots) { ?>
    <div class="cc_hubadm_box cc_hubadm_full">
    <div class="cc_hubadm_boxtitle">Pending Pilots</div>
 <table class="cc_hubadm_tablea">
    <tr>
        <th>Pilot ID</th>
        <th>First</th>
        <th>Last</th>
        <th>Email</th>
        <th>IP</th>
        <th>Country</th>
        <th>Rank</th>
        <th>Flights</th>
        <th>Hours</th>
        <th>Status</th>
        <th>Edit</th>
        <th>Options</th>
        </tr>
     <?php foreach($penpilots as $pil) { 
     $location = HubOpsData::getpilotlocation($pil->pilotid);
     $statuses = Config::get('PILOT_STATUS_TYPES');
     foreach($statuses as $sid => $statusdetail) {
      if($pil->retired == $sid) {
      $status = $statusdetail['name'];
                    break;
                }
            }
     ?>
     <tr class="cc_hubadm_pendingfield">
     <td><?php echo PilotData::getPilotCode($pil->code, $pil->pilotid); ?></td>
     <td><?php echo $pil->firstname; ?></td>
     <td><?php echo $pil->lastname; ?></td>
     <td><a href="mailto:<?php echo $pil->email; ?>"><?php echo $pil->email; ?></a></td>
     <td><?php echo $pil->lastip; ?></td>
     <td><?php echo '<img src="' . Countries::getCountryImage($pil->location) . '" alt="' . $pil->location . '" />'; ?></td>
     <td><?php echo $pil->rank; ?></td>
     <td><?php echo $pil->totalflights; ?></td>
     <td><?php echo $pil->totalhours; ?></td>
     <td><?php echo $status; ?></td>
     <td><a href="<?php echo SITE_URL ?>/<?php echo $mloc ?>.php/HubOps/pilotdetail/<?php echo $pil->pilotid ?>" class="cc_hubadm_greenbutt">Edit</a></td>
     <td><a href="<?php echo SITE_URL ?>/<?php echo $mloc ?>.php/HubOps/acceptpilot/<?php echo $pil->pilotid ?>" class="cc_hubadm_greenbutt">Accept</a></td>
     <td><a href="<?php echo SITE_URL ?>/<?php echo $mloc ?>.php/HubOps/rejectpilot/<?php echo $pil->pilotid ?>" class="cc_hubadm_redbutt">Reject</a></td>
     </tr>
     <?php } ?>
    </table>
</div>
    <?php } ?>
    
    
<div class="cc_hubadm_box cc_hubadm_full">
    <?php if($detail->hubpilots == '1')
         { ?>
    <div class="cc_hubadm_boxtitle"><?php if($piwarning != '1') { echo "Pilots based in ".$hub->icao; } else { echo "The following pilots have not submitted a PIREP within the last ".$detail->pirepdays." days"; } ?></div>
    <?php } else { ?>
    <div class="cc_hubadm_boxtitle"><?php if($piwarning != '1') { echo "All VA Pilots"; } else { echo "The following pilots have not submitted a PIREP within the last ".$detail->pirepdays." days"; } ?></div>
    <?php } ?>
    <?php if($piwarning == '1') { echo "The list shows active and inactive pilots! Pilots who are banned or on leave will not show up in the list"; } ?>
    <?php if(!$pilots) { echo "<br /><br />No pilots available!"; } else { ?>
 <table class="cc_hubadm_tablea">
    <tr>
        <th>Pilot ID</th>
        <th>First</th>
        <th>Last</th>
        <th>Email</th>
        <th>IP</th>
        <th>Country</th>
        <th>Rank</th>
        <th>Flights</th>
        <th>Hours</th>
        <th>Last Flight</th>
        <th>Location</th>
        <th>Status</th>
        <?php if($piwarning == '1') { ?>
        <th>Email Pilot</th>
        <?php } else { ?>
        <th>Edit</th>
        <?php } ?>
        </tr>
     <?php foreach($pilots as $pil) { 
     $location = HubOpsData::getpilotlocation($pil->pilotid);
     $statuses = Config::get('PILOT_STATUS_TYPES');
     foreach($statuses as $sid => $statusdetail) {
      if($pil->retired == $sid) {
      $status = $statusdetail['name'];
                    break;
                }
            }
     ?>
     <tr>
     <td><?php echo PilotData::getPilotCode($pil->code, $pil->pilotid); ?></td>
     <td><?php echo $pil->firstname; ?></td>
     <td><?php echo $pil->lastname; ?></td>
     <td><a href="mailto:<?php echo $pil->email; ?>"><?php echo $pil->email; ?></a></td>
     <td><?php echo $pil->lastip; ?></td>
     <td><?php echo '<img src="' . Countries::getCountryImage($pil->location) . '" alt="' . $pil->location . '" />'; ?></td>
     <td><?php echo $pil->rank; ?></td>
     <td><?php echo $pil->totalflights; ?></td>
     <td><?php echo $pil->totalhours; ?></td>
     <td><?php if($pil->lastpirep == '0000-00-00 00:00:00') { echo "No Flights"; } else { echo date(DATE_FORMAT, strtotime($pil->lastpirep)); } ?></td>
     <td><?php echo $location; ?></td>
     <td><?php echo $status; ?></td>
     <?php if($piwarning == '1') { ?>
     <td><a href="<?php echo SITE_URL ?>/<?php echo $mloc ?>.php/HubOps/emailpilwarn/<?php echo $pil->pilotid ?>" class="cc_hubadm_greenbutt">Send Email</a></td>
     <?php } else { ?>
     <td><a href="<?php echo SITE_URL ?>/<?php echo $mloc ?>.php/HubOps/pilotdetail/<?php echo $pil->pilotid ?>" class="cc_hubadm_greenbutt">Edit</a></td>
     <?php } ?>
     </tr>
     <?php } ?>
    </table>
    <?php } ?>
</div>
</div>