<?php
if(!$pireps)
{
	echo '<p>No reports have been found</p></div>';
}
else
{
?>
<p>There are a total of <?php echo count($pireps);?> flight reports in this category. <a href="<?php echo SITE_URL ?>/<?php echo $mloc ?>.php/HubOps/approveallpireps/<?php echo $hub->icao ?>">Click to approve all PIREPs for this Hub</a></p>

<table class="cc_hubadm_tablea">
    <tr>
		<th>Date</th>
        <th>Flight</th>
        <th>From</th>
		<th>To</th>
		<th>Pilot</th>
		<th>Aircraft</th>
		<th>Flighttime</th>
		<th>Fuel Used</th>
		<th>Landingrate</th>
		<th>Finance</th>
		<th>Log</th>
		<?php if(PilotGroups::group_has_perm(Auth::$usergroups, FULL_ADMIN) || $pilotpermissions->editpireps == '1')
            { ?>
		<th>Comments</th>
		<th>Edit</th>
		<th>Options</th>
		<?php } ?>
        </tr>
    <?php
foreach($pireps as $pirep)
{	
	if($pirep->accepted == PIREP_PENDING)
		$td_class = 'pending';
	else
		$td_class = '';
	
	$error = false;
?>
	<?php if($pirep->accepted == "0")
			{
	?>
	    <tr class="cc_hubadm_pendingfield">
		<?php } elseif($pirep->accepted == "2") { ?>
		<tr class="cc_hubadm_rejectedfield">
		<?php } else { ?>
			<tr>
		<?php } ?>
	<td><?php echo date(DATE_FORMAT, $pirep->submitdate); ?></td>
	<td><?php echo $pirep->code.$pirep->flightnum; ?><br />ID: <?php echo $pirep->pirepid; ?></td>
	<td><?php echo $pirep->depicao; ?><br /><?php echo substr($pirep->depname,0,20); ?></td>
	<td><?php echo $pirep->arricao; ?><br /><?php echo substr($pirep->arrname,0,20); ?></td>
	<td><?php echo PilotData::GetPilotCode($pirep->pcode, $pirep->pilotid) . '<br />' .$pirep->firstname .' ' . $pirep->lastname;?></td>
	<td><?php 
			if($pirep->aircraft == '')
			{
				$error = true;
				echo '<span style="color: red">No aircraft! Edit to change</span>';
			}
			else
				echo $pirep->aircraft. "<br />($pirep->registration)";
			?></td>
	<td><?php echo $pirep->flighttime_stamp; ?></td>
	<td><?php echo ($pirep->fuelused!='') ? $pirep->fuelused.Config::Get('LIQUID_UNIT_NAMES', Config::Get('LiquidUnit')) : '-';?></td>
	<td><?php echo $pirep->landingrate; ?> ft/min</td>
	<td>Revenue: <?php echo FinanceData::formatMoney($pirep->revenue);?><br />
		Pilot Pay: <?php echo FinanceData::formatMoney($pirep->pilotpay);?></td>
	<td><span id="<?php echo $pirep->pirepid; ?>" class="log cc_hubadm_link_tbl_pir">View Log</span></td>
			<?php if(PilotGroups::group_has_perm(Auth::$usergroups, FULL_ADMIN) || $pilotpermissions->editpireps == '1')
            { ?>
	<td><span id="<?php echo $pirep->pirepid; ?>" class="comment cc_hubadm_link_tbl_pir">Comments <span class="hubcommentcount<?php echo $pirep->pirepid; ?>" style="font-size: 12px; margin-top: -3px; font-weight:bold;">(<?php echo PIREPData::getCommentCount($pirep->pirepid); ?>)</span></span></td>
	<td><span id="<?php echo $pirep->pirepid; ?>" class="editpirep cc_hubadm_link_tbl_pir">Edit</span></td>
				<td><span id="<?php echo $pirep->pirepid ?>" name="<?php echo $pirep->pilotid; ?>" class="acceptpirep cc_hubadm_greenbutt pirepactions">Accept</span><br /><span id="<?php echo $pirep->pirepid ?>" name="<?php echo $pirep->pilotid; ?>" class="rejectpirep cc_hubadm_redbutt pirepactions">Reject</span><br /><span id="<?php echo $pirep->pirepid ?>" name="<?php echo $pirep->pilotid; ?>" class="deletepirep cc_hubadm_redbutt pirepactions">Delete</span></td>
				<?php } ?>
	</tr>
	<?php
}
?>
</table>
<?php } ?>
<div id="pirepinfoscreen"></div>
