<?php
if(!$notams) {
	echo "<div id='error'>There are no NOTAMs.</div>";
	return;
}
?>
<div class="sectheader">NOTAMs</div>
<table class="table table-bordered table-striped tablesorter">
	<thead>
		<tr class="info">
			<th>
				Status
			</th>
			<th>
				Subject
			</th>
			<th>
				Date
			</th>
		</tr>
	</thead>
	<tbody>
<?php foreach($notams as $notam) { ?>
		<tr>
			<td style="text-align:center">
				<?php if(NotamsData::notamIsRead($notam->id)) echo "<span class='label label-success'>Read</span>"; else echo "<span class='label label-danger'>Unread</span>"; ?>
			</td>
			<td style="text-align:center">
				<a href="<?php echo url('notams/view/'.$notam->id); ?>"><?php echo $notam->subject; ?></a>
			</td>
			<td style="text-align:center">
				<?php echo date(DATE_FORMAT, $notam->timestamp); ?>
			</td>
		</tr>
<?php } ?>
	</tbody>
</table>