<center>
<img src="https://cdn.discordapp.com/attachments/861662752174506035/1153927335960125570/icrewtracker_logo.png" style="width: 50px height: auto" />
</center>

# iCrewTracker Client
### by icrewsystems

## Changelog

### v0.5
- Initial release of iCrewTracker Client with Oblivia v2.
- [BUG] Updated all folder names
---

## Introduction

iCrewTracker is a paid software developed by icrewsystems which uses their 
propreitary lightweight PHP MVC framework called "Oblivia Framework v2"

@author Leonard Selvaraja

Read LICENSE.md for more information.

## Directory Structure

```
- icrewtracker-client/
    - app/
        - base/      
            - base/AppContainer.php
            - base/BaseController.php
            - base/Config.php
            - base/Router.php
        - config/
            - config/config.json
        - controllers/    
            - controller files
        - models/          
            - model files
        - views/
            - view files
    - index.php
    - .htaccess
    - composer.json
    - bootstrap.php
    - routes.php
```

## Architecture

Oblivia v2 uses the MVC (Model-View-Controller) pattern which promotes the separation of application concerns:

- **Models**: Represent and manage the data of your application.
- **Views**: Display the application's user interface (UI).
- **Controllers**: Handle user input and update the Model and View accordingly.

## Packages Used

Oblivia utilizes the following external packages:

- [illuminate/database](https://packagist.org/packages/illuminate/database): Provides the Eloquent ORM, which offers a beautiful and simple ActiveRecord implementation to work with your databases.

## Application Flow

1. The `.htaccess` file redirects all requests to `index.php`.
2. `index.php` in turn includes `bootstrap.php` and `routes.php`.
3. Routing is managed by the `Router.php` class which maps URL routes to specific controller methods.
4. The application logic is then processed by the corresponding Controller which might utilize a Model for data-related operations and potentially render a View for the user.

### Raw Queries

For those who wish to use raw SQL queries, you can use the Capsule manager provided by Laravel's Eloquent ORM. First, make sure to import it at the beginning of your file:

```php
use Illuminate\Database\Capsule\Manager as DB;
```

With this, you can execute direct SQL statements.

### Configuration File

The configuration file is central to the Oblivia framework. It contains important settings related to the database, application meta data, and other custom fields.

A typical configuration is:

```json
{
    "database": {
        "host": "127.0.0.1",
        "user": "root",
        "pass": "password",
        "name": "YOUR_DATABASE_NAME",
        "prefix": "phpvms_"
    },
    "app": {
        "name": "iCrewTracker",
        "version": "0.5",
        "env": "local"
    },
    "custom_fields": {
        "ivao": "1",
        "vatsim": "2"
    }
}
```

**Note**: The `custom_fields` section is especially important as it helps the framework recognize specific fields. Without proper configuration of these fields, the application will not boot.

## Developing Additional Features

### Adding a New Route

1. Open `routes.php`.
2. Utilize the `Router` class to define a new route. For example, to add a GET route, use: `Router::get('your_route', 'ControllerName@methodName');`.

### Creating a Model

1. Inside the `Models` directory, create a new PHP file.
2. Define a class that extends the base model or Eloquent Model if using the Eloquent ORM.
3. Define any relationships or specific queries/methods inside this class.

### Creating a Controller

1. Inside the `Controllers` directory, create a new PHP file.
2. Define a class that extends the `BaseController`.
3. Add methods that correspond to different actions or routes. Use the `input` method from the `BaseController` to retrieve GET/POST data.

### Creating a View

While this hasn't been detailed previously, if your framework supports views, you would typically:

1. Create a new file in a hypothetical `Views` directory.
2. In the relevant controller method, after performing any necessary logic, you'd render the view passing it any necessary data.

## TODO

- [ ] Enhance error reporting
- [ ] Implement logging & diagnostics
- [ ] Implement license verification system
- [ ] Implement user authentication and registration.
- [ ] Add support for caching.
- [ ] Enhance the routing mechanism to support group routes.



