<?php 

/**
 * (c) 2023 iCrewTracker. All rights reserved.
 * 
 * This file is part of the iCrewTracker software suite.
 * Unauthorized copying, modification, distribution, or use of this file, 
 * via any medium, is strictly prohibited. This file is proprietary and confidential.
 * For license information, please see the LICENSE.md file.
 *
 * @author ICREWSYSTEMS SOFTWARE ENGINEERING LLP
 * @contact legal(at)icrewsystems.com 
 * @license UID cbb8060f-5d4c-45aa-8850-f4b8a87d0bcc
 * @package-bundle-hash:fe8Hghmq7t7GsZsW7KzHuTe/38L9upjcIflUqo8C5qr9iv/PeQNS
 */

namespace iCrewTracker\Base;

/**
 * AppContainer - This simple container will give you an instance of the 
 * desired class. It follows a basic singleton pattern, ensuring only one 
 * instance of each class. 
 * 
 * 
 * Please note: This is a very rudimentary container inspired by Laravel's 
 * service container. 
 * 
 * @author Leonard Selvaraja
 */
class AppContainer {

    private static $instances = [];
    
    /**
     * make
     *
     * @param  mixed $className
     * @return mixed
     */
    public static function make($className) {
        if (!isset(self::$instances[$className])) {
            self::$instances[$className] = new $className();
        }
        return self::$instances[$className];
    }
}


?>