<?php

/**
 * (c) 2023 iCrewTracker. All rights reserved.
 * 
 * This file is part of the iCrewTracker software suite.
 * Unauthorized copying, modification, distribution, or use of this file, 
 * via any medium, is strictly prohibited. This file is proprietary and confidential.
 * For license information, please see the LICENSE.md file.
 *
 * @author ICREWSYSTEMS SOFTWARE ENGINEERING LLP
 * @contact legal(at)icrewsystems.com 
 * @license UID cbb8060f-5d4c-45aa-8850-f4b8a87d0bcc
 * @package-bundle-hash:fe8Hghmq7t7GsZsW7KzHuTe/38L9upjcIflUqo8C5qr9iv/PeQNS
 */

namespace iCrewTracker\Base;

/**
 * Config - This class will load the contents of the 
 * config/config.json and make it available as an object throughout 
 * the app via `Config::get('KEY')->values`
 * 
 * @author Leonard Selvaraja
 */
class Config {
    private static $configurations = [];

    public static function set($key, $value) {
        self::$configurations[$key] = $value;
    }

    public static function get($key, $default = null) {
        return isset(self::$configurations[$key]) ? self::$configurations[$key] : $default;
    }

    public static function load(array $configurations) {
        self::$configurations = $configurations + self::$configurations;
    }
}
?>