<?php 

/**
 * (c) 2023 iCrewTracker. All rights reserved.
 * 
 * This file is part of the iCrewTracker software suite.
 * Unauthorized copying, modification, distribution, or use of this file, 
 * via any medium, is strictly prohibited. This file is proprietary and confidential.
 * For license information, please see the LICENSE.md file.
 *
 * @author ICREWSYSTEMS SOFTWARE ENGINEERING LLP
 * @contact legal(at)icrewsystems.com 
 * @license UID cbb8060f-5d4c-45aa-8850-f4b8a87d0bcc
 * @package-bundle-hash:fe8Hghmq7t7GsZsW7KzHuTe/38L9upjcIflUqo8C5qr9iv/PeQNS
 */


namespace iCrewTracker\Controllers;

use Exception;
use iCrewTracker\Base\Config;
use iCrewTracker\Models\Acars;
use iCrewTracker\Models\Pirep;
use iCrewTracker\Models\Pilots;
use iCrewTracker\Models\Airline;
use iCrewTracker\Models\Aircraft;
use iCrewTracker\Models\Schedule;
use iCrewTracker\Base\BaseController;
use Illuminate\Database\Capsule\Manager as DB;

class HomeController extends BaseController {

    public function index() {

        return $this->json([
            'virtual_airline' => [
                'name' => DB::table('settings')->select(['name', 'value', 'friendlyName'])->where('name', 'SITE_NAME')->first()->value,
                'php' => phpversion(),
            ],
            'version' => Config::get('app')->version,
            'message' => 'iCrewTracker has been installed. WARNING! This is an early-beta, things are expected to fail, when they do, please report them to icrewsystems. We appreciate your understanding',            
        ]);

        // return $this->view('sampleView', [
        //     'pilots' => Pilots::all(),
        // ]);
    }

    public function phpvms() {      
        
        
        $data['details'] = [
            'name' => DB::table('settings')->select(['name', 'value', 'friendlyName'])->where('name', 'SITE_NAME')->first()->value,
        ];

        $data['stats'] = [
            'pilots' => Pilots::count(),
            'pireps' => Pirep::count(),
            'schedules' => Schedule::count(),
            'aircraft' => Aircraft::count(),
            'acars_data' => Acars::count(),
        ];
                
        return $this->json($data);
    }
    
    /**
     * pilots
     *
     * @return void
     */
    public function pilots() {     
        $pilot_id = $this->get('pilot_id');
        if(!is_null($pilot_id)) {
            $pilot = Pilots::where('pilotid', $pilot_id)->get();            
            if($pilot == '[]') {
                throw new Exception("No pilot found with ID {$pilot_id}");
            } else {
                return $this->json($pilot);    
            }
            
        } else {
            $pilots = Pilots::all();        
            return $this->json($pilots);
        }        
    }
    
    /**
     * airlines
     *
     * @return void
     */
    public function airlines() {
        return $this->json(Airline::get());
    } 
}

?>