<?php 

/**
 * (c) 2023 iCrewTracker. All rights reserved.
 * 
 * This file is part of the iCrewTracker software suite.
 * Unauthorized copying, modification, distribution, or use of this file, 
 * via any medium, is strictly prohibited. This file is proprietary and confidential.
 * For license information, please see the LICENSE.md file.
 *
 * @author ICREWSYSTEMS SOFTWARE ENGINEERING LLP
 * @contact legal(at)icrewsystems.com 
 * @license UID cbb8060f-5d4c-45aa-8850-f4b8a87d0bcc
 * @package-bundle-hash:fe8Hghmq7t7GsZsW7KzHuTe/38L9upjcIflUqo8C5qr9iv/PeQNS
 */

use iCrewTracker\Base\Router;

$router = new Router();

$router->get('/', 'iCrewTracker\Controllers\HomeController@index');
$router->get('/test', 'iCrewTracker\Controllers\HomeController@test');
$router->get('/phpvms', 'iCrewTracker\Controllers\HomeController@phpvms');


# Pilot Routes
$router->get('/pilots/all', 'iCrewTracker\Controllers\PilotController@get_all_pilots');
$router->get('/pilots/find', 'iCrewTracker\Controllers\PilotController@find_pilot');
$router->get('/pilots/find-by-vid', 'iCrewTracker\Controllers\PilotController@find_pilot_by_vid');

# Schedules / Airlines
$router->get('/airlines', 'iCrewTracker\Controllers\ScheduleController@get_all_airlines');
$router->get('/airlines/find', 'iCrewTracker\Controllers\ScheduleController@find_airline');

$router->get('/schedule/find-by-id', 'iCrewTracker\Controllers\ScheduleController@find_schedule_by_id');
$router->get('/schedule/find-by-flightnumber', 'iCrewTracker\Controllers\ScheduleController@find_schedule_by_flightnumber');
$router->get('/schedule/find-by-airports', 'iCrewTracker\Controllers\ScheduleController@find_schedule_by_airports');
$router->get('/schedule/bids', 'iCrewTracker\Controllers\ScheduleController@find_current_bids');

// $router->get('/posrep', 'iCrewTracker\Controllers\ACARSController@posrep');
$router->post('/posrep', 'iCrewTracker\Controllers\ACARSController@posrep');
// $router->get('/posrep/file-pirep', 'iCrewTracker\Controllers\ACARSController@file_pirep');
$router->post('/posrep/file-pirep', 'iCrewTracker\Controllers\ACARSController@file_pirep');

// * GET /pilot/all
// * GET /pilot/find/{id}
// * GET /airlines
// * GET /schedule/find/{id}
// * POST /schedule/find/params
// * POST /schedule/is-flight-in-bid-list/{schedule?}/{pilot?}
// * GET /schedule/does-schedule-exist?dep=VOMM&arr=VOBL&aircraft=B737
// *
// * POST /posrep/{flight?}
// * POST /posrep/file-pirep/{flight?}
// * GET /pirep/get/{id}
// * GET /pirep/status/{id}

?>